/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.utils.deb;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.packagedrone.utils.deb.ParserException;

public final class ControlFileParser {
    private ControlFileParser() {
    }

    public static List<Map<String, String>> parseMulti(InputStream stream) throws IOException, ParserException {
        return ControlFileParser.parseMulti(new InputStreamReader(stream, StandardCharsets.UTF_8));
    }

    public static List<Map<String, String>> parseMulti(Reader inputReader) throws IOException, ParserException {
        LinkedHashMap<String, String> entry;
        LinkedList<Map<String, String>> result = new LinkedList<Map<String, String>>();
        BufferedReader reader = new BufferedReader(inputReader);
        while ((entry = ControlFileParser.parseInternal(reader)) != null) {
            result.add(entry);
        }
        return result;
    }

    public static LinkedHashMap<String, String> parse(InputStream stream) throws IOException, ParserException {
        return ControlFileParser.parse(new InputStreamReader(stream));
    }

    public static LinkedHashMap<String, String> parse(Reader inputReader) throws IOException, ParserException {
        return ControlFileParser.parseInternal(new BufferedReader(inputReader));
    }

    private static LinkedHashMap<String, String> parseInternal(BufferedReader reader) throws IOException, ParserException {
        String line;
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        String currentKey = null;
        StringBuilder currentValue = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            if (line.isEmpty()) break;
            if (line.startsWith("#")) continue;
            if (!line.startsWith(" ") && !line.startsWith("\t")) {
                int idx = line.indexOf(58);
                if (idx > 0) {
                    if (currentKey != null) {
                        result.put(currentKey, currentValue.toString());
                        currentValue = new StringBuilder();
                    }
                    currentKey = line.substring(0, idx);
                    String val = line.substring(idx + 1, line.length());
                    if (val.startsWith(" ")) {
                        val = val.substring(1);
                    }
                    currentValue.append(val);
                    continue;
                }
                throw new ParserException(String.format("Missing ':' field delimiter in line: '%s'", line));
            }
            currentValue.append('\n');
            line = line.substring(1);
            if (line.equals(".")) continue;
            currentValue.append(line);
        }
        if (line == null && result.isEmpty()) {
            return null;
        }
        if (currentKey != null) {
            result.put(currentKey, currentValue.toString());
        }
        return result;
    }
}

