/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.aspect.upgrade;

import java.util.Collection;
import org.eclipse.packagedrone.job.JobFactory;
import org.eclipse.packagedrone.job.JobFactoryDescriptor;
import org.eclipse.packagedrone.job.JobInstance;
import org.eclipse.packagedrone.repo.channel.ChannelInformation;
import org.eclipse.packagedrone.repo.channel.ChannelService;
import org.eclipse.packagedrone.repo.channel.ModifiableChannel;
import org.eclipse.packagedrone.utils.profiler.Profile;
import org.eclipse.packagedrone.web.LinkTarget;

public class UpgradeAllChannelsJob
implements JobFactory {
    private static final JobFactoryDescriptor DESCRIPTOR = new JobFactoryDescriptor(){

        public LinkTarget getResultTarget() {
            return null;
        }
    };
    public static final String ID = "drone.aspect.refreshAllChannels";
    private ChannelService service;

    public void setService(ChannelService service) {
        this.service = service;
    }

    public JobFactoryDescriptor getDescriptor() {
        return DESCRIPTOR;
    }

    public JobInstance createInstance(String data) throws Exception {
        return ctx -> this.process(ctx);
    }

    private void process(JobInstance.Context ctx) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Profile.Handle handle = Profile.start((Object)this, (String)"process");){
            Collection channels = this.service.list();
            ctx.beginWork("Refreshing channels", (long)channels.size());
            for (ChannelInformation channelInformation : channels) {
                ctx.setCurrentTaskName(String.format("Processing %s", channelInformation.getId()));
                this.service.accessRun(ChannelService.By.id((String)channelInformation.getId()), ModifiableChannel.class, channel -> channel.getContext().refreshAspects(null));
                ctx.worked(1L);
            }
            ctx.complete();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public String encodeConfiguration(Object data) {
        return null;
    }

    public String makeLabel(String data) {
        return "Reprocess all channels";
    }
}

