/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.cleanup.web;

import com.google.common.net.UrlEscapers;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.Consumer;
import javax.servlet.jsp.JspWriter;
import org.eclipse.packagedrone.repo.channel.ReadableChannel;
import org.eclipse.packagedrone.repo.channel.web.breadcrumbs.Breadcrumbs;
import org.eclipse.packagedrone.repo.cleanup.Cleaner;
import org.eclipse.packagedrone.utils.io.IOConsumer;
import org.eclipse.packagedrone.web.ModelAndView;
import org.eclipse.packagedrone.web.ViewResolver;

@ViewResolver(value="/WEB-INF/views/%s.jsp")
public final class TestConfigurationController {
    private TestConfigurationController() {
    }

    public static ModelAndView performTest(ReadableChannel channel, Consumer<Cleaner> cleanerConfigurator) {
        return TestConfigurationController.performTestCustomized(channel, cleanerConfigurator, null);
    }

    public static ModelAndView performTestCustomized(ReadableChannel channel, Consumer<Cleaner> cleanerConfigurator, IOConsumer<JspWriter> customizer) {
        Cleaner cleaner = new Cleaner(() -> ((ReadableChannel)channel).getArtifacts());
        cleanerConfigurator.accept(cleaner);
        return TestConfigurationController.makeTestResultPage(channel, cleaner, customizer);
    }

    private static ModelAndView makeTestResultPage(ReadableChannel channel, Cleaner cleaner, IOConsumer<JspWriter> customizer) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("channel", channel.getInformation());
        TestConfigurationController.fillBreadcrumbs(model, channel.getId().getId());
        model.put("cleaner", cleaner);
        model.put("result", cleaner.compute());
        model.put("customizer", customizer);
        ModelAndView result = new ModelAndView("testResult", model);
        result.setAlternateViewResolver(TestConfigurationController.class);
        return result;
    }

    private static void fillBreadcrumbs(Map<String, Object> model, String channelId) {
        LinkedList<Breadcrumbs.Entry> entries = new LinkedList<Breadcrumbs.Entry>();
        entries.add(new Breadcrumbs.Entry("Home", "/"));
        entries.add(new Breadcrumbs.Entry("Channel", "/channel/" + UrlEscapers.urlPathSegmentEscaper().escape(channelId) + "/view"));
        entries.add(new Breadcrumbs.Entry("Cleanup"));
        model.put("breadcrumbs", new Breadcrumbs(entries));
    }
}

