/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.job;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.function.Supplier;
import org.eclipse.packagedrone.job.JobFactory;
import org.eclipse.packagedrone.job.JobInstance;

public abstract class AbstractJsonJobFactory<T, R>
implements JobFactory {
    private static final GsonBuilder DEFAULT = new GsonBuilder();
    private Supplier<GsonBuilder> gsonBuilder;
    private Class<T> dataClazz;
    private GsonBuilder builder;

    public AbstractJsonJobFactory(Class<T> dataClazz, Supplier<GsonBuilder> gsonBuilder) {
        this.dataClazz = dataClazz;
        this.gsonBuilder = gsonBuilder == null ? () -> DEFAULT : gsonBuilder;
    }

    public AbstractJsonJobFactory(Class<T> dataClazz, GsonBuilder gsonBuilder) {
        this.dataClazz = dataClazz;
        this.gsonBuilder = null;
        this.builder = gsonBuilder;
    }

    public AbstractJsonJobFactory(Class<T> dataClazz) {
        this(dataClazz, new GsonBuilder());
    }

    protected Gson createGson() {
        if (this.builder == null) {
            this.builder = this.gsonBuilder.get();
        }
        return this.builder.create();
    }

    protected abstract R process(JobInstance.Context var1, T var2) throws Exception;

    @Override
    public JobInstance createInstance(String data) {
        final Gson gson = this.createGson();
        final Object cfg = gson.fromJson(data, this.dataClazz);
        return new JobInstance(){

            @Override
            public void run(JobInstance.Context context) throws Exception {
                Object result = AbstractJsonJobFactory.this.process(context, cfg);
                context.setResult(gson.toJson(result));
            }
        };
    }

    @Override
    public String encodeConfiguration(Object data) {
        if (data == null) {
            return null;
        }
        if (!this.dataClazz.isAssignableFrom(data.getClass())) {
            throw new IllegalArgumentException(String.format("Job data must be of type: %s (is %s)", this.dataClazz, data.getClass()));
        }
        return this.createGson().toJson(data);
    }

    @Override
    public String makeLabel(String data) {
        Object cfg = this.createGson().fromJson(data, this.dataClazz);
        return this.makeLabelFromData(cfg);
    }

    protected abstract String makeLabelFromData(T var1);
}

