/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.adapter.p2.internal.aspect;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.packagedrone.repo.adapter.p2.internal.aspect.ArtifactRule;
import org.eclipse.packagedrone.repo.adapter.p2.internal.aspect.ChannelStreamer;
import org.eclipse.packagedrone.repo.aspect.aggregate.AggregationContext;
import org.eclipse.packagedrone.repo.aspect.aggregate.ChannelAggregator;
import org.eclipse.packagedrone.repo.channel.ArtifactInformation;
import org.eclipse.packagedrone.utils.profiler.Profile;

public class P2RepoChannelAggregator
implements ChannelAggregator {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    public Map<String, String> aggregateMetaData(AggregationContext context) throws Exception {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Profile.Handle handle = Profile.start((Object)this, (String)"aggregateMetaData");){
            handle.task("Process : " + context.getArtifacts().size());
            HashMap<String, String> result = new HashMap<String, String>();
            ChannelStreamer streamer = new ChannelStreamer(context.getChannelId(), context.getChannelMetaData(), true, true, ArtifactRule.getDefaultRepositoryRules());
            Date lastTimestamp = null;
            for (ArtifactInformation ai : context.getArtifacts()) {
                Date cts = ai.getCreationTimestamp();
                if (lastTimestamp == null || lastTimestamp.before(cts)) {
                    lastTimestamp = cts;
                }
                streamer.process(ai, (arg_0, arg_1) -> ((AggregationContext)context).streamArtifact(arg_0, arg_1));
            }
            if (lastTimestamp != null) {
                result.put("last-change", Long.toString(lastTimestamp.getTime()));
                result.put("last-change-string", DATE_FORMAT.format(lastTimestamp.getTime()));
            }
            handle.task("Spool out");
            streamer.spoolOut((arg_0, arg_1, arg_2, arg_3) -> ((AggregationContext)context).createCacheEntry(arg_0, arg_1, arg_2, arg_3));
            handle.task("Validate");
            Map<String, Set<String>> duplicates = streamer.checkDuplicates();
            for (Map.Entry<String, Set<String>> arts : duplicates.entrySet()) {
                context.validationError(String.format("Installable units have the same ID (%s) but different checksums. This will cause an \"MD5 hash is not as expected\" error when working with P2.", arts.getKey()), arts.getValue());
            }
            return result;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

