/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.aspect.cleanup.internal;

import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.packagedrone.repo.MetaKeys;
import org.eclipse.packagedrone.repo.aspect.cleanup.CleanupConfiguration;
import org.eclipse.packagedrone.repo.aspect.listener.ChannelListener;
import org.eclipse.packagedrone.repo.aspect.listener.PostAddContext;
import org.eclipse.packagedrone.repo.cleanup.Cleaner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CleanupListener
implements ChannelListener {
    private static final Logger logger = LoggerFactory.getLogger(CleanupListener.class);

    public void artifactAdded(PostAddContext context) throws Exception {
        Map metaData = context.getChannelMetaData();
        CleanupConfiguration cfg = (CleanupConfiguration)MetaKeys.bind((Object)new CleanupConfiguration(), (Map)metaData);
        if (cfg.getNumberOfVersions() <= 0 || cfg.getSorter() == null) {
            logger.info("Cleanup is not configured");
            return;
        }
        Cleaner cleaner = new Cleaner(() -> ((PostAddContext)context).getChannelArtifacts());
        cfg.applyTo(cleaner);
        Cleaner.Result result = cleaner.compute();
        Set deleteSet = result.deletedSetStream().collect(Collectors.toSet());
        logger.debug("Deleting: {}", deleteSet);
        context.deleteArtifacts(deleteSet);
    }
}

