/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.channel.impl;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.packagedrone.repo.ChannelAspectInformation;
import org.eclipse.packagedrone.repo.aspect.ChannelAspectProcessor;
import org.eclipse.packagedrone.repo.channel.ChannelId;
import org.eclipse.packagedrone.repo.channel.ModifiableChannel;
import org.eclipse.packagedrone.repo.channel.impl.ReadableChannelAdapter;
import org.eclipse.packagedrone.repo.channel.provider.AccessContext;
import org.eclipse.packagedrone.repo.channel.provider.ModifyContext;
import org.eclipse.packagedrone.utils.profiler.Profile;

public class ModifiableChannelAdapter
extends ReadableChannelAdapter
implements ModifiableChannel {
    private final ModifyContext context;
    private final ChannelAspectProcessor aspectProcessor;

    public ModifiableChannelAdapter(ChannelId descriptor, ModifyContext context, ChannelAspectProcessor aspectProcessor) {
        super(descriptor, (AccessContext)context);
        this.context = context;
        this.aspectProcessor = aspectProcessor;
    }

    public ModifyContext getContext() {
        return this.context;
    }

    public void addAspects(boolean withDependencies, String ... aspectIds) {
        HashSet<String> aspects = new HashSet<String>(Arrays.asList(aspectIds));
        if (withDependencies) {
            this.getContext().addAspects(this.expandDependencies(aspects));
        } else {
            this.getContext().addAspects(aspects);
        }
    }

    private Set<String> expandDependencies(Set<String> aspects) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Profile.Handle handle = Profile.start((String)(String.valueOf(ModifiableChannelAdapter.class.getName()) + ".expandDependencies"));){
            Map all = this.aspectProcessor.getAspectInformations();
            HashSet<String> result = new HashSet<String>();
            TreeSet<String> requested = new TreeSet<String>();
            requested.addAll(aspects);
            while (!requested.isEmpty()) {
                String id = (String)requested.pollFirst();
                if (!result.add(id)) continue;
                ChannelAspectInformation asp = (ChannelAspectInformation)all.get(id);
                HashSet reqs = new HashSet(asp.getRequires());
                reqs.removeAll(requested);
                requested.addAll(reqs);
            }
            return result;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

