/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.web.controller.validator;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Path;
import org.eclipse.packagedrone.utils.validation.ValidationBundle;
import org.eclipse.packagedrone.web.controller.binding.BindingError;
import org.eclipse.packagedrone.web.controller.validator.ValidationResult;
import org.eclipse.packagedrone.web.controller.validator.Validator;

public class JavaValidator
implements Validator {
    @Override
    public ValidationResult validate(Object target) {
        Set vr = ValidationBundle.getValidator().validate(target, new Class[0]);
        if (vr == null || vr.isEmpty()) {
            return ValidationResult.EMPTY;
        }
        HashMap<String, List<BindingError>> result = new HashMap<String, List<BindingError>>();
        for (ConstraintViolation entry : vr) {
            String path = this.makePath((ConstraintViolation<Object>)entry);
            LinkedList<BindingError> errors = (LinkedList<BindingError>)result.get(path);
            if (errors == null) {
                errors = new LinkedList<BindingError>();
                result.put(path, errors);
            }
            errors.add(this.convert((ConstraintViolation<Object>)entry));
        }
        ValidationResult validationResult = new ValidationResult();
        validationResult.setErrors(result);
        return validationResult;
    }

    private BindingError convert(ConstraintViolation<Object> entry) {
        return new ConstraintViolationBindingError(entry);
    }

    private String makePath(ConstraintViolation<Object> entry) {
        StringBuilder sb = new StringBuilder();
        Path p = entry.getPropertyPath();
        for (Path.Node n : p) {
            if (sb.length() > 0) {
                sb.append('.');
            }
            sb.append(n.getName());
        }
        return sb.toString();
    }

    public static class ConstraintViolationBindingError
    implements BindingError {
        private final ConstraintViolation<?> violation;

        public ConstraintViolationBindingError(ConstraintViolation<?> violation) {
            this.violation = violation;
        }

        @Override
        public String getMessage() {
            return this.violation.getMessage();
        }
    }
}

