/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.web;

import java.util.HashMap;
import java.util.Map;

public class ModelAndView {
    public static final String REDIRECT_PREFIX = "redirect:";
    public static final String REFERER_PREFIX = "referer:";
    private String viewName;
    private Map<String, Object> model = new HashMap<String, Object>();
    private Class<?> alternateViewResolver;

    public ModelAndView(String viewName, Map<String, ?> model) {
        this.viewName = viewName;
        this.model = ModelAndView.copyModel(model);
    }

    public ModelAndView(String viewName, String key, Object value) {
        this.viewName = viewName;
        this.model = new HashMap<String, Object>(1);
        this.model.put(key, value);
    }

    public ModelAndView(String viewName) {
        this(viewName, null);
    }

    public ModelAndView() {
    }

    public static ModelAndView redirect(String target) {
        return new ModelAndView(REDIRECT_PREFIX + target);
    }

    public static ModelAndView referer(String target) {
        return new ModelAndView(REFERER_PREFIX + target);
    }

    public void setAlternateViewResolver(Class<?> alternateViewResolver) {
        this.alternateViewResolver = alternateViewResolver;
    }

    public Class<?> getAlternateViewResolver() {
        return this.alternateViewResolver;
    }

    public void setModel(Map<String, Object> model) {
        this.model = ModelAndView.copyModel(model);
    }

    public Map<String, Object> getModel() {
        return this.model;
    }

    public String getViewName() {
        return this.viewName;
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    public ModelAndView put(String key, Object value) {
        this.model.put(key, value);
        return this;
    }

    public boolean isRedirect() {
        if (this.viewName == null) {
            return false;
        }
        return this.viewName.startsWith(REDIRECT_PREFIX);
    }

    public boolean isReferer() {
        if (this.viewName == null) {
            return false;
        }
        return this.viewName.startsWith(REFERER_PREFIX);
    }

    public String getRedirect() {
        if (this.isRedirect()) {
            return this.viewName.substring(REDIRECT_PREFIX.length());
        }
        return null;
    }

    public String getReferer() {
        if (this.isRedirect()) {
            return this.viewName.substring(REFERER_PREFIX.length());
        }
        return null;
    }

    public String toString() {
        return String.format("[ModelAndView - %s]", this.viewName);
    }

    private static HashMap<String, Object> copyModel(Map<String, ?> model) {
        return model != null ? new HashMap<String, Object>(model) : new HashMap();
    }
}

