/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.adapter.rpm.yum.internal;

import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.repo.adapter.rpm.Constants;
import org.eclipse.packagedrone.repo.adapter.rpm.RpmInformationsJson;
import org.eclipse.packagedrone.repo.aspect.aggregate.AggregationContext;
import org.eclipse.packagedrone.repo.aspect.aggregate.ChannelAggregator;
import org.eclipse.packagedrone.repo.aspect.common.spool.ChannelCacheTarget;
import org.eclipse.packagedrone.repo.channel.ArtifactInformation;
import org.eclipse.packagedrone.repo.signing.SigningService;
import org.eclipse.packagedrone.utils.io.SpoolOutTarget;
import org.eclipse.packagedrone.utils.rpm.HashAlgorithm;
import org.eclipse.packagedrone.utils.rpm.info.RpmInformation;
import org.eclipse.packagedrone.utils.rpm.yum.RepositoryCreator;
import org.eclipse.packagedrone.utils.xml.XmlToolsFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class YumChannelAggregator
implements ChannelAggregator {
    private static final MetaKey KEY_SIGNING_ID = new MetaKey("yum", "signingServiceId");
    private static final MetaKey KEY_SHA1 = new MetaKey("hasher", "sha1");
    private final BundleContext context;
    private final XmlToolsFactory xml;

    public YumChannelAggregator(XmlToolsFactory xml) {
        this.xml = xml;
        this.context = FrameworkUtil.getBundle(YumChannelAggregator.class).getBundleContext();
    }

    public Map<String, String> aggregateMetaData(AggregationContext context) throws Exception {
        HashMap<String, String> hashMap;
        block5: {
            String signingServiceId = (String)context.getChannelMetaData().get(KEY_SIGNING_ID);
            ServiceReference ssref = null;
            SigningService signingService = null;
            if (signingServiceId != null && !signingServiceId.isEmpty()) {
                Collection services = this.context.getServiceReferences(SigningService.class, String.format("(%s=%s)", "service.pid", signingServiceId));
                if (services == null || services.isEmpty()) {
                    throw new IllegalStateException(String.format("Unable to find configured signing service: %s", signingServiceId));
                }
                ssref = (ServiceReference)services.iterator().next();
                signingService = (SigningService)this.context.getService(ssref);
            }
            try {
                RepositoryCreator.DefaultXmlContext xmlCtx = this.makeXmlContext();
                Function<OutputStream, OutputStream> signingStreamCreator = this.makeSigningStreamCreator(signingService);
                RepositoryCreator.Builder builder = new RepositoryCreator.Builder();
                builder.setTarget((SpoolOutTarget)new ChannelCacheTarget(context));
                builder.setXmlContext((RepositoryCreator.XmlContext)xmlCtx);
                builder.setSigning(signingStreamCreator);
                RepositoryCreator creator = builder.build();
                HashMap<String, String> result = new HashMap<String, String>();
                creator.process(repoContext -> {
                    for (ArtifactInformation art : context.getArtifacts()) {
                        RpmInformation info = RpmInformationsJson.fromJson((String)art.getMetaData().get(Constants.KEY_INFO));
                        if (info == null) continue;
                        String sha1 = (String)art.getMetaData().get(KEY_SHA1);
                        Map<HashAlgorithm, String> checksums = Collections.singletonMap(HashAlgorithm.SHA1, sha1);
                        String location = String.format("pool/%s/%s", art.getId(), art.getName());
                        RepositoryCreator.FileInformation file = new RepositoryCreator.FileInformation(art.getCreationInstant(), art.getSize(), location);
                        repoContext.addPackage(file, info, checksums, HashAlgorithm.SHA1);
                    }
                });
                hashMap = result;
                if (signingService == null || ssref == null) break block5;
            }
            catch (Throwable throwable) {
                if (signingService != null && ssref != null) {
                    this.context.ungetService(ssref);
                }
                throw throwable;
            }
            this.context.ungetService(ssref);
        }
        return hashMap;
    }

    private Function<OutputStream, OutputStream> makeSigningStreamCreator(SigningService signingService) {
        Function<OutputStream, OutputStream> signingStreamCreator = null;
        if (signingService != null) {
            SigningService signingServiceFinal = signingService;
            signingStreamCreator = output -> signingServiceFinal.signingStream(output, false);
        }
        return signingStreamCreator;
    }

    private RepositoryCreator.DefaultXmlContext makeXmlContext() {
        DocumentBuilderFactory dbf = this.xml.newDocumentBuilderFactory();
        dbf.setNamespaceAware(true);
        RepositoryCreator.DefaultXmlContext xmlCtx = new RepositoryCreator.DefaultXmlContext(dbf, this.xml.newTransformerFactory());
        return xmlCtx;
    }
}

