/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.channel.search.stream;

import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.packagedrone.repo.channel.ArtifactInformation;
import org.eclipse.packagedrone.repo.channel.search.And;
import org.eclipse.packagedrone.repo.channel.search.Equal;
import org.eclipse.packagedrone.repo.channel.search.IsNull;
import org.eclipse.packagedrone.repo.channel.search.Like;
import org.eclipse.packagedrone.repo.channel.search.Literal;
import org.eclipse.packagedrone.repo.channel.search.MetaKeyValue;
import org.eclipse.packagedrone.repo.channel.search.Not;
import org.eclipse.packagedrone.repo.channel.search.Or;
import org.eclipse.packagedrone.repo.channel.search.Predicate;
import org.eclipse.packagedrone.repo.channel.search.Value;

public class PredicateFilterBuilder {
    private final Predicate predicate;

    public PredicateFilterBuilder(Predicate predicate) {
        Objects.requireNonNull(predicate);
        this.predicate = predicate;
    }

    public java.util.function.Predicate<ArtifactInformation> build() {
        return this.buildFrom(this.predicate);
    }

    protected java.util.function.Predicate<ArtifactInformation> buildFrom(Predicate current) {
        if (current instanceof And) {
            return this.buildAnd((And)current);
        }
        if (current instanceof Or) {
            return this.buildOr((Or)current);
        }
        if (current instanceof Equal) {
            return this.buildEqual((Equal)current);
        }
        if (current instanceof Like) {
            return this.buildLike((Like)current);
        }
        if (current instanceof Not) {
            return this.buildNot((Not)current);
        }
        if (current instanceof IsNull) {
            return this.buildIsNull((IsNull)current);
        }
        throw new IllegalArgumentException(String.format("Predicate type '%s' (%s) is unknown", current.getClass().getSimpleName(), current.getClass().getName()));
    }

    protected Function<ArtifactInformation, String> buildFrom(Value current) {
        if (current instanceof Literal) {
            return this.buildLiteral((Literal)current);
        }
        if (current instanceof MetaKeyValue) {
            return this.buildMetaKeyValue((MetaKeyValue)current);
        }
        throw new IllegalArgumentException(String.format("Value type '%s' (%s) is unknown", current.getClass().getSimpleName(), current.getClass().getName()));
    }

    protected Function<ArtifactInformation, String> buildLiteral(Literal current) {
        return t -> current.getValue();
    }

    protected Function<ArtifactInformation, String> buildMetaKeyValue(MetaKeyValue current) {
        return t -> t.getMetaData().get(current.getMetaKey());
    }

    protected java.util.function.Predicate<ArtifactInformation> buildAnd(And current) {
        return new AndPredicate<ArtifactInformation>(current.getPredicates().stream().map(this::buildFrom).collect(Collectors.toList()));
    }

    protected java.util.function.Predicate<ArtifactInformation> buildOr(Or current) {
        return new OrPredicate<ArtifactInformation>(current.getPredicates().stream().map(this::buildFrom).collect(Collectors.toList()));
    }

    protected java.util.function.Predicate<ArtifactInformation> buildEqual(Equal current) {
        return new EqualPredicate<ArtifactInformation, String>(this.buildFrom(current.getValue1()), this.buildFrom(current.getValue2()));
    }

    protected java.util.function.Predicate<ArtifactInformation> buildLike(Like current) {
        return new LikePredicate<ArtifactInformation, String>(this.buildFrom(current.getValue()), current.getPattern().getValue(), current.isCaseSensitive());
    }

    protected java.util.function.Predicate<ArtifactInformation> buildNot(Not current) {
        java.util.function.Predicate<ArtifactInformation> p = this.buildFrom(current.getPredicate());
        return t -> !p.test((ArtifactInformation)t);
    }

    protected java.util.function.Predicate<ArtifactInformation> buildIsNull(IsNull current) {
        Function<ArtifactInformation, String> v1 = this.buildFrom(current.getValue());
        return t -> v1.apply((ArtifactInformation)t) == null;
    }

    private static final class AndPredicate<T>
    implements java.util.function.Predicate<T> {
        private final List<java.util.function.Predicate<T>> predicates;

        public AndPredicate(List<java.util.function.Predicate<T>> predicates) {
            this.predicates = predicates;
        }

        @Override
        public boolean test(T t) {
            for (java.util.function.Predicate<T> p : this.predicates) {
                if (p.test(t)) continue;
                return false;
            }
            return true;
        }
    }

    private static final class EqualPredicate<T, V>
    implements java.util.function.Predicate<T> {
        private final Function<T, V> valueFunction1;
        private final Function<T, V> valueFunction2;

        public EqualPredicate(Function<T, V> valueFunction1, Function<T, V> valueFunction2) {
            this.valueFunction1 = valueFunction1;
            this.valueFunction2 = valueFunction2;
        }

        @Override
        public boolean test(T t) {
            V v2;
            V v1 = this.valueFunction1.apply(t);
            if (v1 == (v2 = this.valueFunction2.apply(t))) {
                return true;
            }
            if (v1 == null || v2 == null) {
                return false;
            }
            return v1.equals(v2);
        }
    }

    private static final class LikePredicate<T, V>
    implements java.util.function.Predicate<T> {
        private final Function<T, V> valueFunction;
        private final Pattern pattern;

        public LikePredicate(Function<T, V> valueFunction, String pattern, boolean caseSensitive) {
            this.valueFunction = valueFunction;
            this.pattern = LikePredicate.makePattern(pattern, caseSensitive);
        }

        @Override
        public boolean test(T t) {
            V v1 = this.valueFunction.apply(t);
            if (v1 == null) {
                return false;
            }
            String sv1 = v1.toString();
            return this.pattern.matcher(sv1).matches();
        }

        private static Pattern makePattern(String pattern, boolean caseSensitive) {
            StringBuilder patternBuilder = new StringBuilder(pattern.length());
            boolean escaped = false;
            StringBuilder sb = new StringBuilder(pattern.length());
            int i = 0;
            while (i < pattern.length()) {
                char c = pattern.charAt(i);
                if (escaped) {
                    sb.append(c);
                    escaped = false;
                } else {
                    switch (c) {
                        case '%': {
                            if (sb.length() > 0) {
                                patternBuilder.append(Pattern.quote(sb.toString()));
                                sb.setLength(0);
                            }
                            patternBuilder.append(".*");
                            break;
                        }
                        case '_': {
                            if (sb.length() > 0) {
                                patternBuilder.append(Pattern.quote(sb.toString()));
                                sb.setLength(0);
                            }
                            patternBuilder.append(".");
                            break;
                        }
                        case '\\': {
                            escaped = true;
                            break;
                        }
                        default: {
                            sb.append(c);
                        }
                    }
                }
                ++i;
            }
            if (sb.length() > 0) {
                patternBuilder.append(Pattern.quote(sb.toString()));
            }
            return Pattern.compile(patternBuilder.toString(), caseSensitive ? 0 : 2);
        }
    }

    private static final class OrPredicate<T>
    implements java.util.function.Predicate<T> {
        private final List<java.util.function.Predicate<T>> predicates;

        public OrPredicate(List<java.util.function.Predicate<T>> predicates) {
            this.predicates = predicates;
        }

        @Override
        public boolean test(T t) {
            for (java.util.function.Predicate<T> p : this.predicates) {
                if (!p.test(t)) continue;
                return true;
            }
            return false;
        }
    }
}

