/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.channel;

import java.util.Collection;
import org.eclipse.packagedrone.repo.Severity;
import org.eclipse.packagedrone.repo.channel.ValidationMessage;

public interface Validated {
    public Collection<ValidationMessage> getValidationMessages();

    default public long getValidationErrorCount() {
        return this.getValidationMessages().stream().filter(msg -> Severity.ERROR == msg.getSeverity()).count();
    }

    default public long getValidationWarningCount() {
        return this.getValidationMessages().stream().filter(msg -> Severity.WARNING == msg.getSeverity()).count();
    }

    default public Severity getOverallValidationState() {
        if (this.getValidationErrorCount() > 0L) {
            return Severity.ERROR;
        }
        if (this.getValidationWarningCount() > 0L) {
            return Severity.WARNING;
        }
        return null;
    }
}

