/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.channel;

import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.repo.MetaKeys;
import org.eclipse.packagedrone.repo.channel.Validated;
import org.eclipse.packagedrone.repo.channel.ValidationMessage;
import org.eclipse.packagedrone.utils.io.FileNames;

public class ArtifactInformation
implements Comparable<ArtifactInformation>,
Validated {
    public static final Comparator<ArtifactInformation> NAME_COMPARATOR = Comparator.nullsFirst(Comparator.comparing(ArtifactInformation::getName));
    private final String id;
    private final String parentId;
    private final Set<String> modChildIds;
    private final Set<String> childIds;
    private final String name;
    private final long size;
    private final Instant creationTimestamp;
    private final Set<String> modFacets;
    private final Set<String> facets;
    private final List<ValidationMessage> modMessages;
    private final List<ValidationMessage> messages;
    private final Map<MetaKey, String> providedMetaData;
    private final Map<MetaKey, String> extractedMetaData;
    private final Map<MetaKey, String> metaData;
    private final String virtualizerAspectId;

    public ArtifactInformation(String id, String parentId, Set<String> childIds, String name, long size, Instant creationTimestamp, Set<String> facets, List<ValidationMessage> messages, Map<MetaKey, String> providedMetaData, Map<MetaKey, String> extractedMetaData, String virtualizerAspectId) {
        this.id = id;
        this.parentId = parentId;
        if (childIds != null) {
            this.modChildIds = new CopyOnWriteArraySet<String>(childIds);
            this.childIds = Collections.unmodifiableSet(this.modChildIds);
        } else {
            this.modChildIds = Collections.emptySet();
            this.childIds = this.modChildIds;
        }
        this.name = name;
        this.size = size;
        this.creationTimestamp = creationTimestamp;
        this.modFacets = new CopyOnWriteArraySet<String>(facets);
        this.facets = Collections.unmodifiableSet(this.modFacets);
        this.modMessages = new CopyOnWriteArrayList<ValidationMessage>(messages);
        this.messages = Collections.unmodifiableList(this.modMessages);
        this.providedMetaData = providedMetaData != null ? Collections.unmodifiableMap(new HashMap<MetaKey, String>(providedMetaData)) : Collections.emptyMap();
        this.extractedMetaData = extractedMetaData != null ? Collections.unmodifiableMap(new HashMap<MetaKey, String>(extractedMetaData)) : Collections.emptyMap();
        this.metaData = MetaKeys.union(providedMetaData, extractedMetaData);
        this.virtualizerAspectId = virtualizerAspectId;
    }

    protected ArtifactInformation(ArtifactInformation other) {
        this.id = other.id;
        this.parentId = other.parentId;
        this.childIds = other.childIds;
        this.modChildIds = other.modChildIds;
        this.name = other.name;
        this.size = other.size;
        this.creationTimestamp = other.creationTimestamp;
        this.facets = other.facets;
        this.modFacets = other.modFacets;
        this.messages = other.messages;
        this.modMessages = other.modMessages;
        this.providedMetaData = other.providedMetaData;
        this.extractedMetaData = other.extractedMetaData;
        this.metaData = other.metaData;
        this.virtualizerAspectId = other.virtualizerAspectId;
    }

    public boolean is(String type) {
        return this.facets.contains(type);
    }

    public Set<String> getFacets() {
        return this.facets;
    }

    public String getId() {
        return this.id;
    }

    public String getParentId() {
        return this.parentId;
    }

    public Set<String> getChildIds() {
        return this.childIds;
    }

    public String getName() {
        return this.name;
    }

    public String getBasename() {
        return FileNames.getBasename((String)this.name);
    }

    public long getSize() {
        return this.size;
    }

    public Instant getCreationInstant() {
        return this.creationTimestamp;
    }

    public Date getCreationTimestamp() {
        return new Date(this.creationTimestamp.toEpochMilli());
    }

    public Map<MetaKey, String> getMetaData() {
        return this.metaData;
    }

    public Map<MetaKey, String> getExtractedMetaData() {
        return this.extractedMetaData;
    }

    public Map<MetaKey, String> getProvidedMetaData() {
        return this.providedMetaData;
    }

    public String getVirtualizerAspectId() {
        return this.virtualizerAspectId;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ArtifactInformation)) {
            return false;
        }
        ArtifactInformation other = (ArtifactInformation)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    @Override
    public int compareTo(ArtifactInformation o) {
        return this.id.compareTo(o.id);
    }

    @Override
    public Collection<ValidationMessage> getValidationMessages() {
        return this.messages;
    }

    public String toString() {
        return String.format("[%s = %s]", this.id, this.name);
    }

    public Manipulator createManipulator() {
        return new Manipulator(this);
    }

    public static class Manipulator {
        private final ArtifactInformation original;
        private Set<String> childIds;
        private Map<MetaKey, String> providedMetaData;
        private Map<MetaKey, String> extractedMetaData;
        private List<ValidationMessage> validationMessages;

        public Manipulator(ArtifactInformation original) {
            this.original = original;
            this.childIds = new CopyOnWriteArraySet<String>(original.modChildIds);
            this.providedMetaData = new HashMap<MetaKey, String>(original.providedMetaData);
            this.extractedMetaData = new HashMap<MetaKey, String>(original.extractedMetaData);
            this.validationMessages = new CopyOnWriteArrayList<ValidationMessage>(original.modMessages);
        }

        public void setChildIds(Set<String> childIds) {
            this.childIds = childIds;
        }

        public Set<String> getChildIds() {
            return this.childIds;
        }

        public ArtifactInformation build() {
            return new ArtifactInformation(this.original.id, this.original.parentId, this.childIds, this.original.name, this.original.size, this.original.creationTimestamp, this.original.modFacets, this.validationMessages, this.providedMetaData, this.extractedMetaData, this.original.virtualizerAspectId);
        }

        public Map<MetaKey, String> getProvidedMetaData() {
            return this.providedMetaData;
        }

        public void setProvidedMetaData(Map<MetaKey, String> providedMetaData) {
            this.providedMetaData = providedMetaData;
        }

        public Map<MetaKey, String> getExtractedMetaData() {
            return this.extractedMetaData;
        }

        public void setExtractedMetaData(Map<MetaKey, String> extractedMetaData) {
            this.extractedMetaData = extractedMetaData;
        }

        public void setValidationMessages(List<ValidationMessage> validationMessages) {
            this.validationMessages = validationMessages;
        }
    }
}

