/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.adapter.maven.upload;

import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import org.eclipse.packagedrone.repo.adapter.maven.upload.ChecksumValidationException;
import org.eclipse.packagedrone.repo.adapter.maven.upload.Coordinates;
import org.eclipse.packagedrone.repo.adapter.maven.upload.Options;
import org.eclipse.packagedrone.repo.adapter.maven.upload.UploadTarget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Uploader {
    private static final Logger logger = LoggerFactory.getLogger(Uploader.class);
    private final Options options;
    private final UploadTarget target;

    public Uploader(UploadTarget target, Options options) {
        this.target = target;
        this.options = new Options(options);
    }

    public boolean receive(String path, InputStream stream) throws ChecksumValidationException, IOException {
        Set<String> parents;
        Coordinates c = Coordinates.parse(path);
        if (c == null) {
            logger.info("Unable to parse maven coordinates from path: {}", (Object)path);
            return false;
        }
        if (this.options.getIgnoreExtensions().contains(c.getExtension())) {
            return false;
        }
        String alg = this.isCheckSum(c);
        if (alg != null) {
            this.target.validateChecksum(c.replaceExtension(c.getExtension().substring(0, c.getExtension().length() - (alg.length() + 1))), alg, this.toChecksumString(stream));
            return false;
        }
        if (c.getClassifier() == null) {
            return this.target.createArtifact(c, stream, null) != null;
        }
        Coordinates cp = c.makeUnclassified();
        if (!"jar".equals(cp.getExtension())) {
            cp = cp.replaceExtension("pom");
        }
        if ((parents = this.target.findArtifacts(cp)).isEmpty()) {
            switch (this.options.getNoParentMode()) {
                case ADD: {
                    return this.target.createArtifact(c, stream, null) != null;
                }
                case IGNORE: {
                    return false;
                }
                case FAIL: {
                    throw new IOException(String.format("No parent found for: %s (parent: %s)", c, cp));
                }
            }
            throw new RuntimeException(String.format("Unknown mode: %s", new Object[]{this.options.getNoParentMode()}));
        }
        if (parents.size() > 1) {
            throw new IOException(String.format("Duplicate parents detected: %s", parents));
        }
        return this.target.createArtifact(parents.iterator().next(), c, stream, null) != null;
    }

    private String toChecksumString(InputStream stream) throws IOException {
        if (stream == null) {
            return "";
        }
        return CharStreams.toString((Readable)new InputStreamReader(stream, StandardCharsets.UTF_8));
    }

    private String isCheckSum(Coordinates c) {
        String cext = c.getExtension();
        if (cext == null) {
            return null;
        }
        for (String ext : this.options.getChecksumExtensions()) {
            if (!cext.endsWith("." + ext)) continue;
            return ext;
        }
        return null;
    }

    public static enum NoParentMode {
        IGNORE,
        ADD,
        FAIL;

    }
}

