/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.utils.osgi;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.osgi.framework.Version;

public final class ParserHelper {
    private static final GsonBuilder gb = new GsonBuilder();

    static {
        gb.registerTypeAdapter(Version.class, (Object)new TypeAdapter<Version>(){

            public Version read(JsonReader reader) throws IOException {
                block19: {
                    if (reader.peek() == JsonToken.NULL) {
                        reader.nextNull();
                        return null;
                    }
                    if (reader.peek() != JsonToken.BEGIN_OBJECT) break block19;
                    reader.beginObject();
                    int major = 0;
                    int minor = 0;
                    int micro = 0;
                    String qualifier = null;
                    while (reader.hasNext()) {
                        String name;
                        switch (name = reader.nextName()) {
                            case "major": {
                                major = reader.nextInt();
                                break;
                            }
                            case "minor": {
                                minor = reader.nextInt();
                                break;
                            }
                            case "micro": {
                                micro = reader.nextInt();
                                break;
                            }
                            case "qualifier": {
                                String string = qualifier = reader.peek() == JsonToken.NULL ? null : reader.nextString();
                            }
                        }
                    }
                    reader.endObject();
                    return new Version(major, minor, micro, qualifier);
                }
                String str = reader.nextString();
                if (str == null) {
                    return null;
                }
                return new Version(str);
            }

            public void write(JsonWriter writer, Version value) throws IOException {
                if (value == null) {
                    writer.nullValue();
                } else {
                    writer.value(value.toString());
                }
            }
        });
    }

    private ParserHelper() {
    }

    public static Map<String, Properties> loadLocalization(ZipFile file, String loc) throws IOException {
        HashMap<String, Properties> locs = new HashMap<String, Properties>();
        Pattern pattern = Pattern.compile(String.valueOf(Pattern.quote(loc)) + "(|_[a-z]{2}-[A-Z]{2})\\.properties");
        Enumeration<? extends ZipEntry> en = file.entries();
        while (en.hasMoreElements()) {
            ZipEntry ze = en.nextElement();
            Matcher m = pattern.matcher(ze.getName());
            if (!m.matches()) continue;
            String locale = ParserHelper.makeLocale(m.group(1));
            Properties properties = ParserHelper.loadProperties(file, ze);
            locs.put(locale, properties);
        }
        return locs;
    }

    private static Properties loadProperties(ZipFile file, ZipEntry ze) throws IOException {
        Properties p = new Properties();
        p.load(file.getInputStream(ze));
        return p;
    }

    private static String makeLocale(String localeString) {
        if (localeString.isEmpty()) {
            return "df_LT";
        }
        return localeString;
    }

    public static Gson newGson() {
        return gb.create();
    }
}

