/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.signing.web;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.packagedrone.repo.signing.SigningService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class SigningServiceEntry
implements Comparable<SigningServiceEntry> {
    private final String id;
    private final String label;

    public SigningServiceEntry(String id, String label) {
        this.id = id;
        this.label = label == null ? id : label;
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    @Override
    public int compareTo(SigningServiceEntry o) {
        return this.label.compareTo(o.label);
    }

    public String toString() {
        if (this.label != null) {
            return String.format("%s (%s)", this.label, this.id);
        }
        return this.id;
    }

    public static List<SigningServiceEntry> getSigningServices() {
        Collection refs;
        LinkedList<SigningServiceEntry> result = new LinkedList<SigningServiceEntry>();
        BundleContext ctx = FrameworkUtil.getBundle(SigningServiceEntry.class).getBundleContext();
        try {
            refs = ctx.getServiceReferences(SigningService.class, null);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            return Collections.emptyList();
        }
        if (refs != null) {
            for (ServiceReference ref : refs) {
                String pid = SigningServiceEntry.makeString(ref.getProperty("service.pid"));
                String description = SigningServiceEntry.makeString(ref.getProperty("service.description"));
                result.add(new SigningServiceEntry(pid, description));
            }
        }
        return result;
    }

    public static String makeString(Object property) {
        if (property instanceof String) {
            return (String)property;
        }
        return null;
    }
}

