/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.utils.rpm.build;

import java.io.IOException;
import org.eclipse.packagedrone.utils.rpm.build.FileInformation;
import org.eclipse.packagedrone.utils.rpm.build.FileInformationCustomizer;
import org.eclipse.packagedrone.utils.rpm.build.PayloadEntryType;
import org.eclipse.packagedrone.utils.rpm.build.SimpleFileInformationCustomizer;

@FunctionalInterface
public interface FileInformationProvider<T> {
    public FileInformation provide(T var1, PayloadEntryType var2) throws IOException;

    default public FileInformationProvider<T> customize(FileInformationCustomizer<T> customizer) {
        if (customizer == null) {
            return this;
        }
        return (object, type) -> {
            FileInformation information = this.provide(object, type);
            customizer.perform(object, information);
            return information;
        };
    }

    default public FileInformationProvider<T> customize(SimpleFileInformationCustomizer customizer) {
        if (customizer == null) {
            return this;
        }
        return (object, type) -> {
            FileInformation information = this.provide(object, type);
            customizer.perform(information);
            return information;
        };
    }
}

