/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.manage.usage;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.servlet.annotation.HttpConstraint;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.packagedrone.repo.manage.usage.PingJob;
import org.eclipse.packagedrone.repo.manage.usage.Statistics;
import org.eclipse.packagedrone.sec.web.controller.HttpContraintControllerInterceptor;
import org.eclipse.packagedrone.sec.web.controller.Secured;
import org.eclipse.packagedrone.sec.web.controller.SecuredControllerInterceptor;
import org.eclipse.packagedrone.web.Controller;
import org.eclipse.packagedrone.web.LinkTarget;
import org.eclipse.packagedrone.web.ModelAndView;
import org.eclipse.packagedrone.web.RequestMapping;
import org.eclipse.packagedrone.web.ViewResolver;
import org.eclipse.packagedrone.web.common.InterfaceExtender;
import org.eclipse.packagedrone.web.common.Modifier;
import org.eclipse.packagedrone.web.common.menu.MenuEntry;
import org.eclipse.packagedrone.web.controller.ControllerInterceptor;
import org.eclipse.packagedrone.web.controller.ControllerInterceptors;

@Controller
@Secured
@HttpConstraint(rolesAllowed={"ADMIN"})
@ControllerInterceptors(value={@ControllerInterceptor(value=SecuredControllerInterceptor.class), @ControllerInterceptor(value=HttpContraintControllerInterceptor.class)})
@ViewResolver(value="/WEB-INF/views/%s.jsp")
@RequestMapping(value={"/system/usage"})
public class UsageController
implements InterfaceExtender {
    private static final List<MenuEntry> MAIN_ENTRIES = Collections.singletonList(new MenuEntry("System", Integer.MAX_VALUE, "Usage", 6000, LinkTarget.createFromController(UsageController.class, (String)"main"), Modifier.DEFAULT, null));
    private PingJob pingJob;

    public void setPingJob(PingJob pingJob) {
        this.pingJob = pingJob;
    }

    @RequestMapping(value={"/"})
    public ModelAndView main() {
        HashMap<String, Object> data = new HashMap<String, Object>(3);
        data.put("enabled", this.pingJob.isActive());
        data.put("data", this.makeJson(this.pingJob.buildStatistics()));
        data.put("lastPingTimestamp", this.pingJob.getLastPing());
        return new ModelAndView("index", data);
    }

    private String makeJson(Statistics stats) {
        GsonBuilder gb = new GsonBuilder();
        gb.setPrettyPrinting();
        Gson g = gb.create();
        return g.toJson((Object)stats);
    }

    public List<MenuEntry> getMainMenuEntries(HttpServletRequest request) {
        if (request.isUserInRole("ADMIN")) {
            return MAIN_ENTRIES;
        }
        return null;
    }
}

