/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.utils.converter;

import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.packagedrone.utils.converter.BooleanToStringConverter;
import org.eclipse.packagedrone.utils.converter.ConversionException;
import org.eclipse.packagedrone.utils.converter.Converter;
import org.eclipse.packagedrone.utils.converter.DefaultProvider;
import org.eclipse.packagedrone.utils.converter.IntegerToStringConverter;
import org.eclipse.packagedrone.utils.converter.JsonToStringConverter;
import org.eclipse.packagedrone.utils.converter.LongToStringConverter;
import org.eclipse.packagedrone.utils.converter.PrimitiveBooleanDefault;
import org.eclipse.packagedrone.utils.converter.StringToBooleanConverter;
import org.eclipse.packagedrone.utils.converter.StringToIntegerConverter;
import org.eclipse.packagedrone.utils.converter.StringToJsonConverter;
import org.eclipse.packagedrone.utils.converter.StringToLongConverter;
import org.eclipse.packagedrone.utils.converter.StringToPrimitiveBooleanConverter;
import org.eclipse.packagedrone.utils.converter.StringToPrimitiveIntegerConverter;
import org.eclipse.packagedrone.utils.converter.StringToPrimitiveLongConverter;
import org.eclipse.packagedrone.utils.converter.StringToSetConverter;

public class ConverterManager {
    private final Collection<Converter> converters = new LinkedList<Converter>();
    private final Collection<DefaultProvider> defaults = new LinkedList<DefaultProvider>();

    public static ConverterManager create() {
        ConverterManager result = new ConverterManager();
        result.addConverter(StringToIntegerConverter.INSTANCE);
        result.addConverter(StringToBooleanConverter.INSTANCE);
        result.addConverter(StringToPrimitiveBooleanConverter.INSTANCE);
        result.addConverter(StringToPrimitiveIntegerConverter.INSTANCE);
        result.addConverter(StringToPrimitiveLongConverter.INSTANCE);
        result.addConverter(BooleanToStringConverter.INSTANCE);
        result.addConverter(IntegerToStringConverter.INSTANCE);
        result.addConverter(StringToSetConverter.INSTANCE);
        result.addConverter(StringToJsonConverter.INSTANCE);
        result.addConverter(JsonToStringConverter.INSTANCE);
        result.addConverter(LongToStringConverter.INSTANCE);
        result.addConverter(StringToLongConverter.INSTANCE);
        result.addDefault(PrimitiveBooleanDefault.INSTANCE);
        return result;
    }

    public void addConverter(Converter converter) {
        this.converters.add(converter);
    }

    public void addDefault(DefaultProvider defaultProvider) {
        this.defaults.add(defaultProvider);
    }

    public <T> T convertTo(Object value, Class<T> clazz) throws Exception {
        if (value == null) {
            return this.getDefault(clazz);
        }
        if (clazz.isAssignableFrom(value.getClass())) {
            return clazz.cast(value);
        }
        Class<?> from = value.getClass();
        for (Converter cvt : this.converters) {
            if (!cvt.canConvert(from, clazz)) continue;
            Object o = cvt.convertTo(value, clazz);
            if (o == null) {
                return null;
            }
            if (clazz.isAssignableFrom(o.getClass())) {
                return clazz.cast(o);
            }
            if (clazz.isPrimitive()) {
                return (T)o;
            }
            throw new ConversionException(String.format("Invalid result type (expected: %s, actual: %s)", clazz.getName(), o.getClass().getName()));
        }
        throw new ConversionException(String.format("Unable to convert %s to %s", value.getClass(), clazz.getName()));
    }

    private <T> T getDefault(Class<T> clazz) {
        for (DefaultProvider provider : this.defaults) {
            if (!provider.providesFor(clazz)) continue;
            return (T)provider.defaultValue();
        }
        return null;
    }
}

