/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.sec.web.filter;

import java.security.Principal;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;
import org.eclipse.packagedrone.sec.UserInformation;
import org.eclipse.packagedrone.sec.UserInformationPrincipal;
import org.eclipse.packagedrone.sec.service.LoginException;
import org.eclipse.packagedrone.sec.service.SecurityService;
import org.eclipse.packagedrone.sec.web.filter.SecurityFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityHttpRequestWrapper
extends HttpServletRequestWrapper {
    private static final Logger logger = LoggerFactory.getLogger(SecurityHttpRequestWrapper.class);
    private final SecurityService service;
    private final HttpServletRequest parent;

    public SecurityHttpRequestWrapper(SecurityService service, HttpServletRequest request) {
        super(request);
        this.parent = request;
        this.service = service;
    }

    public void login(String username, String password) throws ServletException {
        Object value = this.getSession().getAttribute(SecurityFilter.ATTR_USER_INFORMATION);
        if (value != null) {
            logger.warn("Already logged in as: {}", value);
            throw new ServletException("Already logged in");
        }
        try {
            if (this.service == null) {
                throw new LoginException("No security service");
            }
            boolean rememberMe = Boolean.TRUE.equals(this.getAttribute(SecurityFilter.ATTR_REMEMBER_ME));
            UserInformation user = this.service.login(username, password, rememberMe);
            SecurityFilter.applyUserInformation((HttpServletRequest)this, user);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public Principal getUserPrincipal() {
        UserInformation user = SecurityHttpRequestWrapper.getUserDetails(this.service, this.getSession(false));
        if (user == null) {
            return null;
        }
        return new UserInformationPrincipal(user);
    }

    public String getAuthType() {
        Principal user = this.getUserPrincipal();
        if (user != null) {
            return "FORM";
        }
        return null;
    }

    public String getRemoteUser() {
        Principal user = this.getUserPrincipal();
        if (user == null) {
            return null;
        }
        return user.getName();
    }

    public boolean isUserInRole(String role) {
        UserInformation user = SecurityHttpRequestWrapper.getUserDetails(this.service, this.getSession(false));
        if (user == null) {
            return false;
        }
        Set roles = user.getRoles();
        if (roles == null) {
            return false;
        }
        return roles.contains(role);
    }

    public void logout() throws ServletException {
        this.getSession().removeAttribute(SecurityFilter.ATTR_USER_INFORMATION);
    }

    private static UserInformation getUserDetails(SecurityService service, HttpSession session) {
        if (session == null) {
            return null;
        }
        Object user = session.getAttribute(SecurityFilter.ATTR_USER_INFORMATION);
        if (!(user instanceof UserInformation)) {
            return null;
        }
        if (session.getAttribute(SecurityFilter.ATTR_USER_RELOAD) != null) {
            session.removeAttribute(SecurityFilter.ATTR_USER_RELOAD);
            UserInformation result = service.refresh((UserInformation)user);
            session.setAttribute(SecurityFilter.ATTR_USER_INFORMATION, (Object)result);
            return result;
        }
        return (UserInformation)user;
    }

    public String toString() {
        return String.format("[Security Wrapped Request: %s]", this.parent);
    }
}

