/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.channel.util;

import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Optional;
import java.util.function.Function;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.repo.channel.ArtifactInformation;
import org.eclipse.packagedrone.repo.channel.ChannelArtifactInformation;
import org.eclipse.packagedrone.repo.channel.ChannelNotFoundException;
import org.eclipse.packagedrone.repo.channel.ChannelService;
import org.eclipse.packagedrone.repo.channel.ReadableChannel;
import org.eclipse.packagedrone.utils.io.IOConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DownloadHelper {
    private static final MetaKey KEY_MIME_TYPE = new MetaKey("mime", "type");
    private static final Logger logger = LoggerFactory.getLogger(DownloadHelper.class);
    public static final String APPLICATION_OCTET_STREAM = "application/octet-stream";

    private DownloadHelper() {
    }

    public static void streamArtifact(HttpServletResponse response, ChannelService service, String channelId, String artifactId, String mimetype, boolean download) throws IOException {
        DownloadHelper.streamArtifact(response, service, channelId, artifactId, mimetype, download, ArtifactInformation::getName);
    }

    public static void streamArtifact(HttpServletResponse response, ChannelService service, String channelId, String artifactId, @NonNull Optional<String> mimetype, boolean download, Function<ArtifactInformation, String> nameFunc) throws IOException {
        try {
            service.accessRun(ChannelService.By.id(channelId), ReadableChannel.class, channel -> {
                ArtifactInformation artifact = channel.getContext().getArtifacts().get(artifactId);
                if (artifact == null) {
                    response.setStatus(404);
                    response.setContentType("text/plain");
                    response.getWriter().format("Artifact '%s' in channel '%s' could not be found", artifact, channelId);
                    return;
                }
                DownloadHelper.streamArtifact(response, artifact, mimetype, download, channel, nameFunc);
            });
        }
        catch (ChannelNotFoundException channelNotFoundException) {
            response.setStatus(404);
            response.setContentType("text/plain");
            response.getWriter().format("Channel '%s' could not be found", channelId);
        }
    }

    public static void streamArtifact(HttpServletResponse response, ChannelService service, String channelId, String artifactId, String mimetype, boolean download, Function<ArtifactInformation, String> nameFunc) throws IOException {
        DownloadHelper.streamArtifact(response, service, channelId, artifactId, Optional.ofNullable(mimetype), download, nameFunc);
    }

    public static boolean streamArtifact(HttpServletResponse response, String artifactId, @NonNull Optional<String> mimetype, boolean download, ReadableChannel channel, Function<ArtifactInformation, String> nameFunc) throws IOException {
        Optional<ChannelArtifactInformation> artifact = channel.getArtifact(artifactId);
        if (!artifact.isPresent()) {
            return false;
        }
        return channel.getContext().stream(artifactId, (IOConsumer<InputStream>)((IOConsumer)stream -> DownloadHelper.streamArtifact(response, (ArtifactInformation)artifact.get(), stream, mimetype, download, nameFunc)));
    }

    public static boolean streamArtifact(HttpServletResponse response, ArtifactInformation artifact, @NonNull Optional<String> mimetype, boolean download, ReadableChannel channel, Function<ArtifactInformation, String> nameFunc) throws IOException {
        return channel.getContext().stream(artifact.getId(), (IOConsumer<InputStream>)((IOConsumer)stream -> DownloadHelper.streamArtifact(response, artifact, stream, mimetype, download, nameFunc)));
    }

    public static void streamArtifact(HttpServletResponse response, ArtifactInformation artifact, InputStream stream, @NonNull Optional<String> mimetype, boolean download, Function<ArtifactInformation, String> nameFunc) throws IOException {
        String mt = mimetype.orElseGet(() -> DownloadHelper.evalMimeType(artifact));
        response.setStatus(200);
        response.setContentType(mt);
        response.setDateHeader("Last-Modified", artifact.getCreationInstant().toEpochMilli());
        response.setContentLengthLong(artifact.getSize());
        if (download) {
            if (nameFunc != null) {
                response.setHeader("Content-Disposition", String.format("attachment; filename=%s", nameFunc.apply(artifact)));
            } else {
                response.setHeader("Content-Disposition", String.format("attachment; filename=%s", artifact.getName()));
            }
        }
        long size = ByteStreams.copy((InputStream)stream, (OutputStream)response.getOutputStream());
        logger.debug("Copyied {} bytes", (Object)size);
    }

    private static String evalMimeType(ArtifactInformation artifact) {
        String mimetype = artifact.getMetaData().get(KEY_MIME_TYPE);
        return mimetype == null ? APPLICATION_OCTET_STREAM : mimetype;
    }
}

