/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.channel;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.repo.channel.ArtifactInformation;
import org.eclipse.packagedrone.repo.channel.CacheEntry;
import org.eclipse.packagedrone.repo.channel.CacheEntryInformation;
import org.eclipse.packagedrone.repo.channel.ChannelArtifactInformation;
import org.eclipse.packagedrone.repo.channel.ChannelId;
import org.eclipse.packagedrone.repo.channel.ChannelInformation;
import org.eclipse.packagedrone.repo.channel.provider.AccessContext;
import org.eclipse.packagedrone.utils.io.IOConsumer;

public interface ReadableChannel {
    public ChannelId getId();

    public AccessContext getContext();

    default public ChannelInformation getInformation() {
        AccessContext ctx = this.getContext();
        return new ChannelInformation(this.getId(), ctx.getState(), ctx.getMetaData(), ctx.getAspectStates());
    }

    default public ChannelArtifactInformation withChannel(ArtifactInformation artifact) {
        if (artifact == null) {
            return null;
        }
        return new ChannelArtifactInformation(this.getId(), artifact);
    }

    default public Optional<ChannelArtifactInformation> getArtifact(String id) {
        return Optional.ofNullable(this.withChannel(this.getContext().getArtifacts().get(id)));
    }

    default public Optional<Collection<ArtifactInformation>> getChildrenOf(String artifactId) {
        AccessContext ctx = this.getContext();
        ArtifactInformation art = ctx.getArtifacts().get(artifactId);
        if (art == null) {
            return Optional.empty();
        }
        @NonNull List<T> result = art.getChildIds().stream().map(childId -> ctx.getArtifacts().get(childId)).collect(Collectors.toList());
        return Optional.of(result);
    }

    default public boolean hasAspect(String aspectId) {
        return this.getInformation().getAspectStates().containsKey(aspectId);
    }

    default public Map<MetaKey, String> getMetaData() {
        return this.getContext().getMetaData();
    }

    default public Map<MetaKey, CacheEntryInformation> getCacheEntries() {
        return this.getContext().getCacheEntries();
    }

    default public boolean streamCacheEntry(MetaKey key, IOConsumer<CacheEntry> consumer) throws IOException {
        return this.getContext().streamCacheEntry(key, consumer);
    }

    default public Collection<ArtifactInformation> getArtifacts() {
        return this.getContext().getArtifacts().values();
    }

    default public List<ArtifactInformation> findByName(String name) {
        return this.getContext().getArtifacts().values().stream().filter(art -> art.getName().equals(name)).collect(Collectors.toList());
    }
}

