/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.utils;

import java.math.RoundingMode;
import java.text.Format;
import java.text.MessageFormat;
import java.text.NumberFormat;

public final class Strings {
    private static final Format bytesPattern = new MessageFormat("{0,choice,0#0 bytes|1#1 byte|1<{0,number,integer} bytes}");
    private static final NumberFormat numberPattern1 = NumberFormat.getNumberInstance();
    private static final NumberFormat numberPattern2 = NumberFormat.getNumberInstance();

    static {
        numberPattern1.setRoundingMode(RoundingMode.HALF_UP);
        numberPattern1.setMaximumFractionDigits(1);
        numberPattern1.setGroupingUsed(false);
        numberPattern2.setRoundingMode(RoundingMode.HALF_UP);
        numberPattern2.setMaximumFractionDigits(2);
        numberPattern2.setGroupingUsed(false);
    }

    private Strings() {
    }

    public static String hex(byte[] digest) {
        StringBuilder sb = new StringBuilder(digest.length * 2);
        int i = 0;
        while (i < digest.length) {
            sb.append(String.format("%02x", digest[i] & 0xFF));
            ++i;
        }
        return sb.toString();
    }

    public static String bytes(long amount) {
        if (amount < 1024L) {
            return bytesPattern.format(new Object[]{amount});
        }
        if (amount < 0x100000L) {
            return String.valueOf(numberPattern1.format((double)amount / 1024.0)) + " KiB";
        }
        if (amount < 0x40000000L) {
            return String.valueOf(numberPattern2.format((double)amount / 1048576.0)) + " MiB";
        }
        return String.valueOf(numberPattern2.format((double)amount / 1.073741824E9)) + " GiB";
    }
}

