/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.servlet;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import org.apache.jasper.EmbeddedServletOptions;
import org.apache.jasper.Options;
import org.apache.jasper.compiler.JspRuntimeContext;
import org.apache.jasper.compiler.JspUtil;
import org.apache.jasper.compiler.Localizer;
import org.apache.jasper.runtime.JspApplicationContextImpl;
import org.apache.jasper.servlet.JspServletWrapper;
import org.glassfish.jsp.api.JspProbeEmitter;

public class JspServlet
extends HttpServlet {
    private static Logger log = Logger.getLogger(JspServlet.class.getName());
    private static final int CHAR_LIMIT = 256;
    private ServletContext context;
    private ServletConfig config;
    private Options options;
    private JspRuntimeContext rctxt;
    private AtomicInteger countErrors = new AtomicInteger(0);
    private String httpMethodsString = null;
    private HashSet<String> httpMethodsSet = null;
    private ConcurrentHashMap<String, TagLibraryInfo> taglibs;
    private ConcurrentHashMap<String, URL> tagFileJarUrls;
    private JspProbeEmitter jspProbeEmitter;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.config = config;
        this.context = config.getServletContext();
        this.options = new EmbeddedServletOptions(config, this.context);
        this.rctxt = new JspRuntimeContext(this.context, this.options);
        this.httpMethodsString = config.getInitParameter("httpMethods");
        if (this.httpMethodsString != null && !this.httpMethodsString.equals("*")) {
            this.httpMethodsSet = new HashSet();
            StringTokenizer tokenizer = new StringTokenizer(this.httpMethodsString, ", \t\n\r\f");
            while (tokenizer.hasMoreTokens()) {
                this.httpMethodsSet.add(tokenizer.nextToken());
            }
        }
        this.taglibs = new ConcurrentHashMap();
        this.context.setAttribute("com.sun.jsp.taglibraryCache", this.taglibs);
        this.tagFileJarUrls = new ConcurrentHashMap();
        this.context.setAttribute("com.sun.jsp.tagFileJarUrlsCache", this.tagFileJarUrls);
        if (log.isLoggable(Level.FINEST)) {
            log.finest(Localizer.getMessage("jsp.message.scratch.dir.is", this.options.getScratchDir().toString()));
            log.finest(Localizer.getMessage("jsp.message.dont.modify.servlets"));
        }
        this.jspProbeEmitter = (JspProbeEmitter)config.getServletContext().getAttribute("org.glassfish.jsp.monitor.probeEmitter");
    }

    public int getJspCount() {
        return this.rctxt.getJspCount();
    }

    public void setJspReloadCount(int count) {
        this.rctxt.setJspReloadCount(count);
    }

    public int getJspReloadCount() {
        return this.rctxt.getJspReloadCount();
    }

    public int getJspErrorCount() {
        return this.countErrors.get();
    }

    boolean preCompile(HttpServletRequest request) throws ServletException {
        String value;
        String queryString = request.getQueryString();
        if (queryString == null) {
            return false;
        }
        int start = queryString.indexOf("jsp_precompile");
        if (start < 0) {
            return false;
        }
        if ((queryString = queryString.substring(start + "jsp_precompile".length())).length() == 0) {
            return true;
        }
        if (queryString.startsWith("&")) {
            return true;
        }
        if (!queryString.startsWith("=")) {
            return false;
        }
        int limit = queryString.length();
        int ampersand = queryString.indexOf("&");
        if (ampersand > 0) {
            limit = ampersand;
        }
        if ((value = queryString.substring(1, limit)).equals("true")) {
            return true;
        }
        if (value.equals("false")) {
            return true;
        }
        throw new ServletException("Cannot have request parameter jsp_precompile set to " + value);
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.httpMethodsSet != null) {
            String method = request.getMethod();
            if (method == null) {
                return;
            }
            if (!this.httpMethodsSet.contains(method)) {
                super.service(request, response);
                return;
            }
            if (method.equals("OPTIONS")) {
                response.addHeader("Allow", this.httpMethodsString);
                return;
            }
        }
        String jspUri = null;
        String jspFile = (String)request.getAttribute("org.apache.catalina.jsp_file");
        if (jspFile != null) {
            jspUri = jspFile;
            request.removeAttribute("org.apache.catalina.jsp_file");
        } else {
            String pathInfo;
            jspUri = (String)request.getAttribute("javax.servlet.include.servlet_path");
            if (jspUri != null) {
                pathInfo = (String)request.getAttribute("javax.servlet.include.path_info");
                if (pathInfo != null) {
                    jspUri = String.valueOf(jspUri) + pathInfo;
                }
            } else {
                jspUri = request.getServletPath();
                pathInfo = request.getPathInfo();
                if (pathInfo != null) {
                    jspUri = String.valueOf(jspUri) + pathInfo;
                }
            }
        }
        if (log.isLoggable(Level.FINE)) {
            StringBuilder msg = new StringBuilder();
            msg.append("JspEngine --> [" + jspUri);
            msg.append("] ServletPath: [" + request.getServletPath());
            msg.append("] PathInfo: [" + request.getPathInfo());
            msg.append("] RealPath: [" + this.context.getRealPath(jspUri));
            msg.append("] RequestURI: [" + request.getRequestURI());
            msg.append("] QueryString: [" + request.getQueryString());
            msg.append("]");
            log.fine(msg.toString());
        }
        try {
            boolean precompile = this.preCompile(request);
            this.serviceJspFile(request, response, jspUri, null, precompile);
        }
        catch (RuntimeException e) {
            this.incrementErrorCount(jspUri);
            throw e;
        }
        catch (Error e) {
            this.incrementErrorCount(jspUri);
            throw e;
        }
        catch (ServletException e) {
            this.incrementErrorCount(jspUri);
            throw e;
        }
        catch (IOException e) {
            this.incrementErrorCount(jspUri);
            throw e;
        }
        catch (Throwable e) {
            this.incrementErrorCount(jspUri);
            throw new ServletException(e);
        }
    }

    public void destroy() {
        if (log.isLoggable(Level.FINE)) {
            log.fine("JspServlet.destroy()");
        }
        this.rctxt.destroy();
        JspApplicationContextImpl.removeJspApplicationContext(this.context);
        this.taglibs.clear();
        this.tagFileJarUrls.clear();
        HashMap tldUriToLocationMap = (HashMap)this.context.getAttribute("com.sun.jsp.tldUriToLocationMap");
        if (tldUriToLocationMap != null) {
            tldUriToLocationMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serviceJspFile(HttpServletRequest request, HttpServletResponse response, String jspUri, Throwable exception, boolean precompile) throws ServletException, IOException {
        JspServletWrapper wrapper = this.rctxt.getWrapper(jspUri);
        if (wrapper == null) {
            JspServlet jspServlet = this;
            synchronized (jspServlet) {
                wrapper = this.rctxt.getWrapper(jspUri);
                if (wrapper == null) {
                    if (this.context.getResource(jspUri) == null && !this.options.getUsePrecompiled()) {
                        String includeRequestUri = (String)request.getAttribute("javax.servlet.include.request_uri");
                        if (includeRequestUri != null) {
                            throw new FileNotFoundException(JspUtil.escapeXml(jspUri));
                        }
                        response.sendError(404);
                        log.severe(Localizer.getMessage("jsp.error.file.not.found", this.context.getRealPath(jspUri)));
                        return;
                    }
                    boolean isErrorPage = exception != null;
                    wrapper = new JspServletWrapper(this.config, this.options, jspUri, isErrorPage, this.rctxt);
                    this.rctxt.addWrapper(jspUri, wrapper);
                }
            }
        }
        wrapper.service(request, response, precompile);
    }

    private void incrementErrorCount(String jspUri) {
        this.countErrors.incrementAndGet();
        if (this.jspProbeEmitter != null) {
            this.jspProbeEmitter.jspErrorEvent(jspUri);
        }
    }
}

