/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.job.apm;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.packagedrone.job.JobFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class FactoryManager {
    private final BundleContext context;
    private final Map<String, JobFactory> services = new HashMap<String, JobFactory>();
    private final Map<ServiceReference<JobFactory>, String> refMap = new HashMap<ServiceReference<JobFactory>, String>();
    private final ReentrantReadWriteLock.ReadLock readLock;
    private final ReentrantReadWriteLock.WriteLock writeLock;
    private final ServiceTracker<JobFactory, JobFactory> tracker;
    private final ServiceTrackerCustomizer<JobFactory, JobFactory> customizer = new ServiceTrackerCustomizer<JobFactory, JobFactory>(){

        public JobFactory addingService(ServiceReference<JobFactory> reference) {
            return FactoryManager.this.handleAdding(reference);
        }

        public void modifiedService(ServiceReference<JobFactory> reference, JobFactory service) {
            FactoryManager.this.handleModified(reference, service);
        }

        public void removedService(ServiceReference<JobFactory> reference, JobFactory service) {
            FactoryManager.this.handleRemoved(reference, service);
        }
    };

    public FactoryManager(BundleContext context) {
        this.context = context;
        ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
        this.readLock = rwLock.readLock();
        this.writeLock = rwLock.writeLock();
        this.tracker = new ServiceTracker(context, JobFactory.class, this.customizer);
    }

    public void start() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (Locked l = new Locked(this.writeLock);){
            this.tracker.open();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void stop() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (Locked l = new Locked(this.writeLock);){
            this.tracker.close();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static String getId(ServiceReference<JobFactory> reference) {
        Object idValue = reference.getProperty("package.drone.job.factoryId");
        if (idValue instanceof String) {
            return (String)idValue;
        }
        if (idValue instanceof String[]) {
            return ((String[])idValue)[0];
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected JobFactory handleAdding(ServiceReference<JobFactory> reference) {
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            Locked l = new Locked(this.writeLock);
            try {
                String id = FactoryManager.getId(reference);
                if (id == null) {
                    return null;
                }
                JobFactory service = (JobFactory)this.context.getService(reference);
                this.putService(id, reference, service);
                return service;
            }
            catch (Throwable throwable2) {
                throw throwable2;
            }
            finally {
                if (l == null) return null;
                l.close();
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            }
            if (throwable == throwable3) throw throwable;
            throwable.addSuppressed(throwable3);
            throw throwable;
        }
    }

    private void putService(String id, ServiceReference<JobFactory> reference, JobFactory service) {
        this.services.put(id, service);
        this.refMap.put(reference, id);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void handleModified(ServiceReference<JobFactory> reference, JobFactory service) {
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            Locked l = new Locked(this.writeLock);
            try {
                this.removeService(reference);
                String newId = FactoryManager.getId(reference);
                if (newId == null) {
                    return;
                }
                this.putService(newId, reference, service);
                return;
            }
            finally {
                if (l == null) return;
                l.close();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    private void removeService(ServiceReference<JobFactory> reference) {
        String oldId = this.refMap.remove(reference);
        if (oldId != null) {
            this.services.remove(oldId);
        }
    }

    protected synchronized void handleRemoved(ServiceReference<JobFactory> reference, JobFactory service) {
        Throwable throwable = null;
        Object var4_5 = null;
        try (Locked l = new Locked(this.writeLock);){
            this.removeService(reference);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public Optional<JobFactory> getFactory(String id) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Locked l = new Locked(this.readLock);){
            return Optional.ofNullable(this.services.get(id));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static class Locked
    implements AutoCloseable {
        private final Lock lock;

        public Locked(Lock lock) {
            lock.lock();
            this.lock = lock;
        }

        @Override
        public void close() {
            this.lock.unlock();
        }
    }
}

