/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.signing.pgp.web.managed;

import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.annotation.HttpConstraint;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.bc.BcPBESecretKeyDecryptorBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPGPDigestCalculatorProvider;
import org.eclipse.packagedrone.repo.signing.pgp.ManagedPgpFactory;
import org.eclipse.packagedrone.repo.signing.pgp.PgpHelper;
import org.eclipse.packagedrone.repo.signing.pgp.web.managed.AddEntry;
import org.eclipse.packagedrone.sec.web.controller.HttpContraintControllerInterceptor;
import org.eclipse.packagedrone.sec.web.controller.Secured;
import org.eclipse.packagedrone.sec.web.controller.SecuredControllerInterceptor;
import org.eclipse.packagedrone.web.Controller;
import org.eclipse.packagedrone.web.LinkTarget;
import org.eclipse.packagedrone.web.ModelAndView;
import org.eclipse.packagedrone.web.RequestMapping;
import org.eclipse.packagedrone.web.RequestMethod;
import org.eclipse.packagedrone.web.ViewResolver;
import org.eclipse.packagedrone.web.common.InterfaceExtender;
import org.eclipse.packagedrone.web.common.Modifier;
import org.eclipse.packagedrone.web.common.menu.MenuEntry;
import org.eclipse.packagedrone.web.common.page.Pagination;
import org.eclipse.packagedrone.web.common.page.PaginationResult;
import org.eclipse.packagedrone.web.controller.ControllerInterceptor;
import org.eclipse.packagedrone.web.controller.ControllerInterceptors;
import org.eclipse.packagedrone.web.controller.binding.BindingError;
import org.eclipse.packagedrone.web.controller.binding.BindingResult;
import org.eclipse.packagedrone.web.controller.binding.ExceptionError;
import org.eclipse.packagedrone.web.controller.binding.PathVariable;
import org.eclipse.packagedrone.web.controller.binding.RequestParameter;
import org.eclipse.packagedrone.web.controller.form.FormData;
import org.eclipse.packagedrone.web.controller.validator.ControllerValidator;
import org.eclipse.packagedrone.web.controller.validator.ValidationContext;
import org.eclipse.scada.utils.ExceptionHelper;

@Controller
@Secured
@ControllerInterceptors(value={@ControllerInterceptor(value=SecuredControllerInterceptor.class), @ControllerInterceptor(value=HttpContraintControllerInterceptor.class)})
@HttpConstraint(rolesAllowed={"ADMIN"})
@ViewResolver(value="/WEB-INF/views/managed/%s.jsp")
@RequestMapping(value={"/pgp.sign.managed"})
public class ServiceController
implements InterfaceExtender {
    public static final Object ACTION_TAG_PGP = new Object();
    private ManagedPgpFactory factory;

    public void setFactory(ManagedPgpFactory factory) {
        this.factory = factory;
    }

    public List<MenuEntry> getMainMenuEntries(HttpServletRequest request) {
        LinkedList<MenuEntry> result = new LinkedList<MenuEntry>();
        if (request.isUserInRole("ADMIN")) {
            result.add(new MenuEntry("Signing", 4100, "PGP Signers (Managed)", 1100, LinkTarget.createFromController(ServiceController.class, (String)"index"), null, null));
        }
        return result;
    }

    public List<MenuEntry> getActions(HttpServletRequest request, Object object) {
        LinkedList<MenuEntry> result = new LinkedList<MenuEntry>();
        if (object == ACTION_TAG_PGP && request.isUserInRole("ADMIN")) {
            result.add(new MenuEntry("Add", 100, LinkTarget.createFromController(ServiceController.class, (String)"add"), Modifier.PRIMARY, "plus"));
        }
        return result;
    }

    @RequestMapping
    public ModelAndView index(@RequestParameter(value="start", required=false) Integer start) throws Exception {
        HashMap<String, PaginationResult> model = new HashMap<String, PaginationResult>();
        model.put("configurations", Pagination.paginate((Integer)start, (int)20, (arg_0, arg_1) -> ((ManagedPgpFactory)this.factory).list(arg_0, arg_1)));
        return new ModelAndView("index", model);
    }

    @ControllerValidator(formDataClass=AddEntry.class)
    public void validateKey(AddEntry entry, ValidationContext context) {
        if (entry != null && entry.getSecretKey() != null && !entry.getSecretKey().isEmpty()) {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (Stream<PGPSecretKey> s = PgpHelper.streamSecretKeys((InputStream)PgpHelper.fromString((String)entry.getSecretKey())).filter(PGPSecretKey::isSigningKey);){
                    List keys = s.collect(Collectors.toList());
                    if (keys.size() <= 0) {
                        context.error("secretKey", "Import does not contain secret signing keys");
                    } else {
                        String passphrase = entry.getPassphrase() == null ? "" : entry.getPassphrase();
                        for (PGPSecretKey key : keys) {
                            try {
                                key.extractPrivateKey(new BcPBESecretKeyDecryptorBuilder((PGPDigestCalculatorProvider)new BcPGPDigestCalculatorProvider()).build(passphrase.toCharArray()));
                            }
                            catch (PGPException e) {
                                context.error("secretKey", String.format("Failed to extract key. Passphrase might be wrong. (%s)", ExceptionHelper.getMessage((Throwable)e)));
                            }
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                context.error("secretKey", (BindingError)new ExceptionError((Throwable)e));
            }
        }
    }

    @RequestMapping(value={"/add"})
    public ModelAndView add() {
        HashMap<String, AddEntry> model = new HashMap<String, AddEntry>();
        model.put("command", new AddEntry());
        return new ModelAndView("add", model);
    }

    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    public ModelAndView addPost(@FormData(value="command") @Valid AddEntry command, BindingResult result) {
        HashMap model = new HashMap();
        if (!result.hasErrors()) {
            this.factory.createService(command.getLabel(), command.getSecretKey(), command.getPassphrase());
            return new ModelAndView("redirect:/pgp.sign.managed");
        }
        return new ModelAndView("add", model);
    }

    @RequestMapping(value={"/{id}/delete"})
    public ModelAndView delete(@PathVariable(value="id") String id) {
        this.factory.deleteService(id);
        return new ModelAndView("redirect:/pgp.sign.managed");
    }
}

