/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.signing.pgp.web;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.annotation.HttpConstraint;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.bc.BcPBESecretKeyDecryptorBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPGPDigestCalculatorProvider;
import org.eclipse.packagedrone.repo.signing.pgp.PgpHelper;
import org.eclipse.packagedrone.repo.signing.pgp.web.AddEntry;
import org.eclipse.packagedrone.repo.signing.pgp.web.InformationEntry;
import org.eclipse.packagedrone.repo.signing.pgp.web.ServiceManager;
import org.eclipse.packagedrone.sec.web.controller.HttpContraintControllerInterceptor;
import org.eclipse.packagedrone.sec.web.controller.Secured;
import org.eclipse.packagedrone.sec.web.controller.SecuredControllerInterceptor;
import org.eclipse.packagedrone.web.Controller;
import org.eclipse.packagedrone.web.LinkTarget;
import org.eclipse.packagedrone.web.ModelAndView;
import org.eclipse.packagedrone.web.RequestMapping;
import org.eclipse.packagedrone.web.RequestMethod;
import org.eclipse.packagedrone.web.ViewResolver;
import org.eclipse.packagedrone.web.common.CommonController;
import org.eclipse.packagedrone.web.common.InterfaceExtender;
import org.eclipse.packagedrone.web.common.Modifier;
import org.eclipse.packagedrone.web.common.menu.MenuEntry;
import org.eclipse.packagedrone.web.controller.ControllerInterceptor;
import org.eclipse.packagedrone.web.controller.ControllerInterceptors;
import org.eclipse.packagedrone.web.controller.binding.BindingResult;
import org.eclipse.packagedrone.web.controller.binding.PathVariable;
import org.eclipse.packagedrone.web.controller.form.FormData;
import org.eclipse.packagedrone.web.controller.validator.ControllerValidator;
import org.eclipse.packagedrone.web.controller.validator.ValidationContext;
import org.eclipse.scada.utils.ExceptionHelper;

@Controller
@Secured
@ControllerInterceptors(value={@ControllerInterceptor(value=SecuredControllerInterceptor.class), @ControllerInterceptor(value=HttpContraintControllerInterceptor.class)})
@HttpConstraint(rolesAllowed={"ADMIN"})
@ViewResolver(value="/WEB-INF/views/local/%s.jsp")
@RequestMapping(value={"/pgp.sign"})
public class ServiceController
implements InterfaceExtender {
    private ServiceManager manager;

    public void setManager(ServiceManager manager) {
        this.manager = manager;
    }

    public List<MenuEntry> getMainMenuEntries(HttpServletRequest request) {
        LinkedList<MenuEntry> result = new LinkedList<MenuEntry>();
        if (request.isUserInRole("ADMIN")) {
            result.add(new MenuEntry("Signing", 4100, "PGP Signers", 1000, LinkTarget.createFromController(ServiceController.class, (String)"index"), null, null));
        }
        return result;
    }

    public List<MenuEntry> getActions(HttpServletRequest request, Object object) {
        LinkedList<MenuEntry> result = new LinkedList<MenuEntry>();
        if (object == ServiceManager.ACTION_TAG_PGP && request.isUserInRole("ADMIN")) {
            result.add(new MenuEntry("Add", 100, LinkTarget.createFromController(ServiceController.class, (String)"add"), Modifier.PRIMARY, "plus"));
        }
        return result;
    }

    @RequestMapping
    public ModelAndView index() throws Exception {
        HashMap<String, List<InformationEntry>> model = new HashMap<String, List<InformationEntry>>();
        model.put("services", this.manager.list());
        return new ModelAndView("index", model);
    }

    @RequestMapping(value={"/{id}/delete"})
    public ModelAndView delete(@PathVariable(value="id") String id) {
        try {
            this.manager.delete(id);
        }
        catch (IOException e) {
            return CommonController.createError((String)"Delete", (String)"Failed to delete", (Throwable)e);
        }
        return new ModelAndView("redirect:/pgp.sign");
    }

    @RequestMapping(value={"/add"})
    public ModelAndView add() {
        HashMap model = new HashMap();
        return new ModelAndView("add", model);
    }

    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    public ModelAndView addPost(@Valid @FormData(value="command") AddEntry data, BindingResult result) {
        HashMap model = new HashMap();
        if (result.hasErrors()) {
            return new ModelAndView("add", model);
        }
        try {
            this.manager.add(data);
        }
        catch (IOException e) {
            return CommonController.createError((String)"Add PGP Signer", (String)"Failed to add signer", (Throwable)e);
        }
        return new ModelAndView("redirect:/pgp.sign");
    }

    @ControllerValidator(formDataClass=AddEntry.class)
    public void validateAdd(AddEntry data, ValidationContext context) {
        block19: {
            String keyring = data.getKeyring();
            File file = new File(keyring);
            if (!file.exists()) {
                context.error("keyring", String.format("File '%s' does not exist on the server", file.getAbsolutePath()));
                return;
            }
            if (!file.isFile()) {
                context.error("keyring", String.format("File '%s' is not a file", file.getAbsolutePath()));
                return;
            }
            if (!file.canRead()) {
                context.error("keyring", String.format("File '%s' cannot be read", file.getAbsolutePath()));
                return;
            }
            String keyId = data.getKeyId();
            if (keyId != null) {
                try {
                    Throwable throwable = null;
                    Object var7_9 = null;
                    try (FileInputStream input = new FileInputStream(file);){
                        PGPSecretKey key = PgpHelper.loadSecretKey((InputStream)input, (String)keyId);
                        if (key == null) {
                            context.error("keyId", "Key not found in keyring");
                            break block19;
                        }
                        if (data.getKeyPassphrase() == null) break block19;
                        try {
                            PGPPrivateKey privateKey = key.extractPrivateKey(new BcPBESecretKeyDecryptorBuilder((PGPDigestCalculatorProvider)new BcPGPDigestCalculatorProvider()).build(data.getKeyPassphrase().toCharArray()));
                            if (privateKey == null) {
                                Thread.sleep(1000L);
                                context.error("keyPassphrase", "Unable to unlock private key");
                            }
                        }
                        catch (Exception e) {
                            context.error("Failed to load key. Probably a wrong phassphrase: " + ExceptionHelper.getMessage((Throwable)e));
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    context.error("Failed to load key: " + ExceptionHelper.getMessage((Throwable)e));
                }
            }
        }
    }
}

