/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.jetty.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.eclipse.jetty.server.AbstractConnectionFactory;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.ForwardedRequestCustomizer;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.NegotiatingServerConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.web.service.jetty.internal.JettyFactory;
import org.ops4j.pax.web.service.jetty.internal.JettyServer;
import org.ops4j.pax.web.service.jetty.internal.JettyServerImpl;
import org.ops4j.pax.web.service.spi.model.ServerModel;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JettyFactoryImpl
implements JettyFactory {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private final ServerModel serverModel;
    private Bundle bundle;
    private List<Connector> connectors;
    private List<Handler> handlers;

    JettyFactoryImpl(ServerModel serverModel, Bundle bundle) {
        this(serverModel, bundle, null, null);
    }

    JettyFactoryImpl(ServerModel serverModel, Bundle bundle, List<Handler> handlers, List<Connector> connectors) {
        NullArgumentException.validateNotNull(serverModel, "Service model");
        this.serverModel = serverModel;
        this.bundle = bundle;
        this.handlers = handlers;
        this.connectors = connectors;
    }

    @Override
    public JettyServer createServer() {
        return new JettyServerImpl(this.serverModel, this.bundle, this.handlers, this.connectors);
    }

    public ServerConnector createConnector(Server server, String name, int port, String host, Boolean checkForwaredHeaders) {
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.setSecureScheme("https");
        httpConfig.setSecurePort(8443);
        httpConfig.setOutputBufferSize(32768);
        if (checkForwaredHeaders.booleanValue()) {
            httpConfig.addCustomizer((HttpConfiguration.Customizer)new ForwardedRequestCustomizer());
        }
        this.log.info("SPDY not available, creating standard ServerConnector for Http");
        ServerConnector http = new ServerConnector(server, new ConnectionFactory[]{new HttpConnectionFactory(httpConfig)});
        http.setPort(port);
        http.setHost(host);
        http.setName(name);
        http.setIdleTimeout(30000L);
        return http;
    }

    public ServerConnector createSecureConnector(Server server, String name, int port, String sslKeystore, String sslPassword, String sslKeyPassword, String host, String sslKeystoreType, boolean isClientAuthNeeded, boolean isClientAuthWanted) {
        SslContextFactory sslContextFactory = new SslContextFactory();
        sslContextFactory.setKeyStorePath(sslKeystore);
        sslContextFactory.setKeyStorePassword(sslKeyPassword);
        sslContextFactory.setKeyManagerPassword(sslPassword);
        sslContextFactory.setNeedClientAuth(isClientAuthNeeded);
        sslContextFactory.setWantClientAuth(isClientAuthWanted);
        if (sslKeystoreType != null) {
            sslContextFactory.setKeyStoreType(sslKeystoreType);
        }
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.setSecureScheme("https");
        httpConfig.setSecurePort(port);
        httpConfig.setOutputBufferSize(32768);
        HttpConfiguration httpsConfig = new HttpConfiguration(httpConfig);
        httpsConfig.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
        ArrayList<Object> connectionFactories = new ArrayList<Object>();
        HttpConnectionFactory httpConFactory = new HttpConnectionFactory(httpsConfig);
        SslConnectionFactory sslFactory = null;
        AbstractConnectionFactory spdyFactory = null;
        NegotiatingServerConnectionFactory alpnFactory = null;
        if (this.spdyCLassesAvailable()) {
            this.log.info("SPDY available, creating HttpSpdyServerConnector for Https");
            sslFactory = new SslConnectionFactory(sslContextFactory, "alpn");
            connectionFactories.add(sslFactory);
            try {
                Class loadClass = this.bundle.loadClass("org.eclipse.jetty.alpn.server.ALPNServerConnectionFactory");
                alpnFactory = (NegotiatingServerConnectionFactory)ConstructorUtils.invokeConstructor(loadClass, new Object[]{new String[]{"spdy/3", "http/1.1"}});
                alpnFactory.setDefaultProtocol("http/1.1");
                connectionFactories.add(alpnFactory);
                loadClass = this.bundle.loadClass("org.eclipse.jetty.spdy.server.http.HTTPSPDYServerConnectionFactory");
                spdyFactory = (AbstractConnectionFactory)ConstructorUtils.invokeConstructor(loadClass, 3, httpsConfig);
                connectionFactories.add(spdyFactory);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        } else {
            this.log.info("SPDY not available, creating standard ServerConnector for Https");
            sslFactory = new SslConnectionFactory(sslContextFactory, "http/1.1");
        }
        ServerConnector https = new ServerConnector(server, new ConnectionFactory[]{sslFactory, httpConFactory});
        for (AbstractConnectionFactory abstractConnectionFactory : connectionFactories) {
            https.addConnectionFactory((ConnectionFactory)abstractConnectionFactory);
        }
        https.setPort(port);
        https.setName(name);
        https.setHost(host);
        https.setIdleTimeout(500000L);
        return https;
    }

    private boolean spdyCLassesAvailable() {
        try {
            ConstructorUtils.invokeConstructor(this.bundle.loadClass("org.eclipse.jetty.alpn.ALPN"), new Object[]{new String[]{"spdy/3", "http/1.1"}});
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            this.log.info("No ALPN class available");
            return false;
        }
        try {
            this.bundle.loadClass("org.eclipse.jetty.spdy.server.http.HTTPSPDYServerConnectionFactory");
        }
        catch (ClassNotFoundException e) {
            this.log.info("No HTTPSPDYServerConnector class available");
            return false;
        }
        try {
            this.bundle.loadClass("org.eclipse.jetty.alpn.server.ALPNServerConnectionFactory");
        }
        catch (ClassNotFoundException e) {
            this.log.info("No ALPNServerConnectionFactory class available");
            return false;
        }
        try {
            this.bundle.loadClass("org.eclipse.jetty.spdy.server.proxy.ProxyHTTPConnectionFactory");
        }
        catch (ClassNotFoundException e) {
            this.log.info("No ProxyHTTPConnectionFactory found");
            return false;
        }
        return true;
    }
}

