/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.channel.apm;

import java.util.Map;
import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.repo.channel.ChannelService;
import org.eclipse.packagedrone.repo.channel.apm.ChannelModelProvider;
import org.eclipse.packagedrone.repo.channel.apm.ChannelProviderImpl;
import org.eclipse.packagedrone.repo.channel.provider.AccessContext;
import org.eclipse.packagedrone.repo.channel.provider.Channel;
import org.eclipse.packagedrone.repo.channel.provider.ModifyContext;
import org.eclipse.packagedrone.storage.apm.StorageManager;
import org.eclipse.packagedrone.storage.apm.StorageModelProvider;
import org.eclipse.packagedrone.storage.apm.StorageRegistration;
import org.eclipse.packagedrone.utils.Exceptions;
import org.osgi.service.event.EventAdmin;

public class ChannelImpl
implements Channel {
    private final String storageId;
    private final MetaKey storageKey;
    private final StorageManager manager;
    private final ChannelProviderImpl provider;
    private final StorageRegistration handle;

    public ChannelImpl(String storageId, EventAdmin eventAdmin, StorageManager manager, ChannelProviderImpl provider, Map<MetaKey, String> configuration) {
        this.storageId = storageId;
        this.manager = manager;
        this.provider = provider;
        this.storageKey = new MetaKey("channel", storageId);
        String dir = configuration.get(new MetaKey("apm", "dir-override"));
        if (dir == null) {
            dir = storageId;
        }
        this.handle = manager.registerModel(10000L, this.storageKey, (StorageModelProvider)new ChannelModelProvider(eventAdmin, storageId, dir));
    }

    public void dispose() {
        this.handle.unregister();
    }

    public String getLocalId() {
        return this.storageId;
    }

    public <T> T accessCall(ChannelService.ChannelOperation<T, AccessContext> operation) {
        return (T)this.manager.accessCall(this.storageKey, AccessContext.class, model -> Exceptions.wrapException(() -> operation.process(model)));
    }

    public <T> T modifyCall(ChannelService.ChannelOperation<T, ModifyContext> operation) {
        return (T)this.manager.modifyCall(this.storageKey, ModifyContext.class, model -> Exceptions.wrapException(() -> operation.process(model)));
    }

    public void delete() {
        this.handle.unregister();
        this.provider.deleteChannel(this);
    }
}

