/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.web.forms.tags;

import com.google.common.escape.Escaper;
import com.google.common.html.HtmlEscapers;
import java.io.IOException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;

public class WriterHelper {
    private final PageContext pageContext;
    private final JspWriter out;
    private final Escaper escaper = HtmlEscapers.htmlEscaper();

    public WriterHelper(PageContext pageContext) {
        this.pageContext = pageContext;
        this.out = this.pageContext.getOut();
    }

    public void write(String string) throws JspException {
        try {
            this.out.write(string);
        }
        catch (IOException e) {
            throw new JspException((Throwable)e);
        }
    }

    public void writeOptionalAttribute(String name, Object value) throws JspException {
        this.writeOptionalAttribute(name, value, true);
    }

    public void writeOptionalAttribute(String name, Object value, boolean leadingSpace) throws JspException {
        if (value != null) {
            this.writeAttribute(name, value, leadingSpace);
        }
    }

    public void writeEscaped(Object value) throws JspException {
        if (value != null) {
            this.write(this.escaper.escape(value.toString()));
        }
    }

    public void writeAttribute(String name, Object value) throws JspException {
        this.writeAttribute(name, value, true);
    }

    public void writeAttribute(String name, Object value, boolean leadingSpace) throws JspException {
        StringBuilder sb = new StringBuilder();
        if (leadingSpace) {
            sb.append(' ');
        }
        String strValue = value == null ? "" : value.toString();
        sb.append(name).append("=\"");
        sb.append(this.escaper.escape(strValue));
        sb.append('\"');
        this.write(sb.toString());
    }

    public void writeFlagAttribute(String name, boolean state) throws JspException {
        if (state) {
            this.writeAttribute(name, name);
        }
    }
}

