/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.api.upload;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.repo.channel.ArtifactInformation;
import org.eclipse.packagedrone.repo.channel.ChannelNotFoundException;
import org.eclipse.packagedrone.repo.channel.ChannelService;
import org.eclipse.packagedrone.repo.channel.ModifiableChannel;
import org.eclipse.packagedrone.repo.channel.servlet.AbstractChannelServiceServlet;
import org.eclipse.scada.utils.ExceptionHelper;

public class UploadServlet
extends AbstractChannelServiceServlet {
    private static final long serialVersionUID = 1L;

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.processUpload(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.processUpload(req, resp);
    }

    private void processUpload(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String targetType;
        String path = req.getPathInfo();
        path = path.replaceFirst("^/+", "");
        String[] toks = (path = path.replaceFirst("/+$", "")).split("/", 3);
        if (toks.length == 0) {
            UploadServlet.sendResponse(resp, 400, "No target");
            return;
        }
        if (toks.length == 1) {
            UploadServlet.sendResponse(resp, 400, "Missing target");
            return;
        }
        if (toks.length == 2) {
            UploadServlet.sendResponse(resp, 400, "Missing artifact name");
            return;
        }
        switch (targetType = toks[0]) {
            case "channel": {
                if (toks.length <= 3) {
                    this.processChannel(req, resp, toks[1], null, toks[2]);
                    break;
                }
                this.processChannel(req, resp, toks[1], toks[2], toks[3]);
                break;
            }
            default: {
                UploadServlet.sendResponse(resp, 400, "Unkown target type: " + targetType);
            }
        }
    }

    private void processChannel(HttpServletRequest req, HttpServletResponse resp, String channelIdOrName, String parentArtifactId, String artifactName) throws IOException {
        resp.setContentType("text/plain");
        ChannelService service = this.getService(req);
        ChannelService.By by = ChannelService.By.nameOrId((String)channelIdOrName);
        if (!this.authenticate(by, req, resp)) {
            return;
        }
        try {
            String artifactId = (String)service.accessCall(by, ModifiableChannel.class, channel -> UploadServlet.store(channel, parentArtifactId, artifactName, req, resp));
            UploadServlet.sendResponse(resp, 200, artifactId != null ? artifactId : "");
        }
        catch (ChannelNotFoundException channelNotFoundException) {
            UploadServlet.sendResponse(resp, 404, String.format("Unable to find channel: %s", channelIdOrName));
            return;
        }
        catch (Exception e) {
            Throwable cause = ExceptionHelper.getRootCause((Throwable)e);
            int state = 500;
            if (cause instanceof IllegalArgumentException) {
                state = 400;
            }
            UploadServlet.sendResponse(resp, state, ExceptionHelper.getMessage((Throwable)e));
        }
    }

    private static void sendResponse(HttpServletResponse response, int status, String message) throws IOException {
        response.setStatus(status);
        response.setContentType("text/plain");
        response.getWriter().println(message);
    }

    private static String store(ModifiableChannel channel, String parentArtifactId, String name, HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            ArtifactInformation art = channel.getContext().createArtifact(parentArtifactId, (InputStream)request.getInputStream(), name, UploadServlet.makeMetaData(request));
            response.setStatus(200);
            if (art != null) {
                return art.getId();
            }
            return null;
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    private static Map<MetaKey, String> makeMetaData(HttpServletRequest request) {
        HashMap<MetaKey, String> result = new HashMap<MetaKey, String>();
        for (Map.Entry entry : request.getParameterMap().entrySet()) {
            MetaKey key = MetaKey.fromString((String)((String)entry.getKey()));
            if (key == null) {
                throw new IllegalArgumentException(String.format("Invalid meta data key format: %s", entry.getKey()));
            }
            String[] values = (String[])entry.getValue();
            if (values == null || values.length < 1) continue;
            result.put(key, values[0]);
        }
        return result;
    }
}

