/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.utils.osgi.bundle;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.repo.utils.osgi.ParserHelper;
import org.eclipse.packagedrone.repo.utils.osgi.TranslatedInformation;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;

public class BundleInformation
implements TranslatedInformation {
    public static final MetaKey META_KEY = new MetaKey("osgi", "bundle-information");
    private String id;
    private Version version;
    private String name;
    private String vendor;
    private String docUrl;
    private String license;
    private String description;
    private boolean singleton;
    private String bundleLocalization;
    private Map<String, Properties> localization = new HashMap<String, Properties>();
    private Set<PackageImport> packageImports = new LinkedHashSet<PackageImport>();
    private Set<PackageExport> packageExports = new LinkedHashSet<PackageExport>();
    private Set<BundleRequirement> bundleRequirements = new LinkedHashSet<BundleRequirement>();
    private List<String> requiredExecutionEnvironments = new LinkedList<String>();
    private String eclipseBundleShape;

    public void setEclipseBundleShape(String eclipseBundleShape) {
        this.eclipseBundleShape = eclipseBundleShape;
    }

    public String getEclipseBundleShape() {
        return this.eclipseBundleShape;
    }

    public void setRequiredExecutionEnvironments(List<String> requiredExecutionEnvironments) {
        this.requiredExecutionEnvironments = requiredExecutionEnvironments != null ? new ArrayList<String>(requiredExecutionEnvironments) : new LinkedList<String>();
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public String getLicense() {
        return this.license;
    }

    public void setDocUrl(String docUrl) {
        this.docUrl = docUrl;
    }

    public String getDocUrl() {
        return this.docUrl;
    }

    public List<String> getRequiredExecutionEnvironments() {
        return this.requiredExecutionEnvironments;
    }

    public void setBundleLocalization(String bundleLocalization) {
        this.bundleLocalization = bundleLocalization;
    }

    public String getBundleLocalization() {
        return this.bundleLocalization;
    }

    public void setPackageExports(Set<PackageExport> packageExports) {
        this.packageExports = packageExports;
    }

    public Set<PackageExport> getPackageExports() {
        return this.packageExports;
    }

    public Set<BundleRequirement> getBundleRequirements() {
        return this.bundleRequirements;
    }

    public void setBundleRequirements(Set<BundleRequirement> bundleImports) {
        this.bundleRequirements = bundleImports;
    }

    public void setPackageImports(Set<PackageImport> packageImports) {
        this.packageImports = packageImports;
    }

    public Set<PackageImport> getPackageImports() {
        return this.packageImports;
    }

    public void setSingleton(boolean singleton) {
        this.singleton = singleton;
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    @Override
    public Map<String, Properties> getLocalization() {
        return this.localization;
    }

    public void setLocalization(Map<String, Properties> localization) {
        this.localization = localization;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Version getVersion() {
        return this.version;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public static BundleInformation fromJson(String string) {
        return BundleInformation.fromJson(string, BundleInformation.class);
    }

    public static <T extends BundleInformation> T fromJson(String string, Class<T> clazz) {
        if (string == null) {
            return null;
        }
        return (T)((BundleInformation)ParserHelper.newGson().fromJson(string, clazz));
    }

    public String toJson() {
        return ParserHelper.newGson().toJson((Object)this);
    }

    public static class BundleRequirement {
        private final String id;
        private final VersionRange versionRange;
        private final boolean optional;
        private final boolean reexport;

        public BundleRequirement(String id, VersionRange versionRange, boolean optional, boolean reexport) {
            this.id = id;
            this.versionRange = versionRange;
            this.optional = optional;
            this.reexport = reexport;
        }

        public String getId() {
            return this.id;
        }

        public VersionRange getVersionRange() {
            return this.versionRange;
        }

        public boolean isOptional() {
            return this.optional;
        }

        public boolean isReexport() {
            return this.reexport;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof BundleRequirement)) {
                return false;
            }
            BundleRequirement other = (BundleRequirement)obj;
            return !(this.id == null ? other.id != null : !this.id.equals(other.id));
        }
    }

    public static class PackageExport {
        private final String name;
        private final Version version;
        private final String uses;

        public PackageExport(String name, Version version, String uses) {
            this.name = name;
            this.version = version;
            this.uses = uses;
        }

        public String getName() {
            return this.name;
        }

        public Version getVersion() {
            return this.version;
        }

        public String getUses() {
            return this.uses;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof PackageExport)) {
                return false;
            }
            PackageExport other = (PackageExport)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public String toString() {
            return String.format("[Export: %s - %s]", this.name, this.version);
        }
    }

    public static class PackageImport {
        private final String name;
        private final VersionRange versionRange;
        private final boolean optional;

        public PackageImport(String name, VersionRange versionRange, boolean optional) {
            this.name = name;
            this.versionRange = versionRange;
            this.optional = optional;
        }

        public String getName() {
            return this.name;
        }

        public VersionRange getVersionRange() {
            return this.versionRange;
        }

        public boolean isOptional() {
            return this.optional;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof PackageImport)) {
                return false;
            }
            PackageImport other = (PackageImport)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public String toString() {
            return String.format("[Import: %s - %s - %s", this.name, this.versionRange, this.optional ? "optional" : "required");
        }
    }
}

