/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.aspect.common.p2;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.eclipse.packagedrone.repo.aspect.common.p2.P2MetaDataInformation;
import org.eclipse.packagedrone.repo.utils.osgi.bundle.BundleInformation;
import org.eclipse.packagedrone.repo.utils.osgi.feature.FeatureInformation;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstallableUnit {
    private static final Logger logger = LoggerFactory.getLogger(InstallableUnit.class);
    private static final String DEFAULT_SYSTEM_BUNDLE_ALIAS = "org.eclipse.osgi";
    private String id;
    private Version version;
    private boolean singleton;
    private Map<String, String> properties = new HashMap<String, String>();
    private String filter;
    private String copyright;
    private String copyrightUrl;
    private List<License> licenses = new LinkedList<License>();
    private List<Entry<Requirement>> requires = new LinkedList<Entry<Requirement>>();
    private List<Entry<String>> provides = new LinkedList<Entry<String>>();
    private Set<Artifact> artifacts = new HashSet<Artifact>();
    private List<Touchpoint> touchpoints = new LinkedList<Touchpoint>();

    public void setLicenses(List<License> licenses) {
        this.licenses = licenses;
    }

    public List<License> getLicenses() {
        return this.licenses;
    }

    public void setCopyright(String copyright) {
        this.copyright = copyright;
    }

    public void setCopyright(String copyright, String copyrightUrl) {
        this.copyright = copyright;
        this.copyrightUrl = copyrightUrl;
    }

    public void setCopyrightUrl(String copyrightUrl) {
        this.copyrightUrl = copyrightUrl;
    }

    public void setArtifacts(Set<Artifact> artifacts) {
        this.artifacts = artifacts;
    }

    public Set<Artifact> getArtifacts() {
        return this.artifacts;
    }

    public void setTouchpoints(List<Touchpoint> touchpoints) {
        this.touchpoints = touchpoints;
    }

    public List<Touchpoint> getTouchpoints() {
        return this.touchpoints;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setRequires(List<Entry<Requirement>> requires) {
        this.requires = requires;
    }

    public List<Entry<Requirement>> getRequires() {
        return this.requires;
    }

    public void setProvides(List<Entry<String>> provides) {
        this.provides = provides;
    }

    public List<Entry<String>> getProvides() {
        return this.provides;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setSingleton(boolean singleton) {
        this.singleton = singleton;
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public Version getVersion() {
        return this.version;
    }

    public static List<InstallableUnit> fromFeature(FeatureInformation feature) {
        ArrayList<InstallableUnit> result = new ArrayList<InstallableUnit>(2);
        result.add(InstallableUnit.createFeatureGroup(feature));
        result.add(InstallableUnit.createFeatureJar(feature));
        return result;
    }

    private static InstallableUnit createFeatureJar(FeatureInformation feature) {
        InstallableUnit result = new InstallableUnit();
        result.setId(String.valueOf(feature.getId()) + ".feature.jar");
        result.setVersion(feature.getVersion());
        Map<String, String> props = result.getProperties();
        props.put("org.eclipse.equinox.p2.name", feature.getLabel());
        InstallableUnit.addProperty(props, "org.eclipse.equinox.p2.provider", feature.getProvider());
        InstallableUnit.addProperty(props, "org.eclipse.equinox.p2.description", feature.getDescription());
        InstallableUnit.addProperty(props, "org.eclipse.equinox.p2.description.url", feature.getDescriptionUrl());
        InstallableUnit.addProperty(props, "org.eclipse.update.feature.plugin", feature.getPlugin());
        InstallableUnit.addLocalization(props, result.getProvides(), feature.getLocalization());
        InstallableUnit.addProvides(result, "org.eclipse.equinox.p2.iu", String.valueOf(feature.getId()) + ".feature.jar", "" + feature.getVersion());
        InstallableUnit.addProvides(result, "org.eclipse.update.feature", feature.getId(), "" + feature.getVersion());
        InstallableUnit.addProvides(result, "org.eclipse.equinox.p2.eclipse.type", "feature", "1.0.0");
        result.setFilter("(org.eclipse.update.install.features=true)");
        result.getArtifacts().add(new Artifact(feature.getId(), "org.eclipse.update.feature", feature.getVersion()));
        result.setCopyright(feature.getCopyright(), feature.getCopyrightUrl());
        result.getLicenses().add(new License(feature.getLicense(), feature.getLicenseUrl()));
        HashMap<String, String> td = new HashMap<String, String>();
        td.put("zipped", "true");
        result.getTouchpoints().add(new Touchpoint("org.eclipse.equinox.p2.osgi", "1.0.0", td));
        return result;
    }

    private static InstallableUnit createFeatureGroup(FeatureInformation feature) {
        VersionRange range;
        String filter;
        logger.debug("Processing: {}", (Object)feature);
        InstallableUnit result = new InstallableUnit();
        Version version = feature.getVersion();
        if (version == null) {
            return null;
        }
        result.setId(String.valueOf(feature.getId()) + ".feature.group");
        result.setVersion(version);
        InstallableUnit.addProvides(result, "org.eclipse.equinox.p2.iu", String.valueOf(feature.getId()) + ".feature.group", "" + feature.getVersion());
        Map<String, String> props = result.getProperties();
        InstallableUnit.addProperty(props, "org.eclipse.equinox.p2.name", feature.getLabel());
        props.put("org.eclipse.equinox.p2.type.group", "true");
        InstallableUnit.addProperty(props, "org.eclipse.equinox.p2.provider", feature.getProvider());
        InstallableUnit.addProperty(props, "org.eclipse.equinox.p2.description", feature.getDescription());
        InstallableUnit.addProperty(props, "org.eclipse.equinox.p2.description.url", feature.getDescriptionUrl());
        InstallableUnit.addLocalization(props, result.getProvides(), feature.getLocalization());
        List<Entry<Requirement>> reqs = result.getRequires();
        String versionRange = String.format("[%1$s,%1$s]", version);
        logger.debug("VersionRange: {}", (Object)versionRange);
        InstallableUnit.addRequires(reqs, "org.eclipse.equinox.p2.iu", String.valueOf(feature.getId()) + ".feature.jar", new Requirement(new VersionRange(versionRange), false, null, "(org.eclipse.update.install.features=true)"));
        for (FeatureInformation.FeatureInclude fi : feature.getIncludedFeatures()) {
            filter = fi.getQualifiers().toFilterString();
            range = fi.makeVersionRange();
            InstallableUnit.addRequires(reqs, "org.eclipse.equinox.p2.iu", String.valueOf(fi.getId()) + ".feature.group", new Requirement(range, fi.isOptional(), null, filter));
        }
        for (FeatureInformation.PluginInclude pi : feature.getIncludedPlugins()) {
            filter = pi.getQualifiers().toFilterString();
            range = pi.makeVersionRange();
            InstallableUnit.addRequires(reqs, "org.eclipse.equinox.p2.iu", pi.getId(), new Requirement(range, false, null, filter));
        }
        for (FeatureInformation.Requirement ri : feature.getRequirements()) {
            String id;
            switch (ri.getType()) {
                case FEATURE: {
                    id = String.valueOf(ri.getId()) + ".feature.group";
                    break;
                }
                case PLUGIN: {
                    id = ri.getId();
                    break;
                }
                default: {
                    throw new IllegalStateException(String.format("Feature requirement type %s is unknown", ri.getType()));
                }
            }
            Version v = ri.getVersion();
            if (v == null) {
                v = Version.emptyVersion;
            }
            InstallableUnit.addRequires(reqs, "org.eclipse.equinox.p2.iu", id, new Requirement(ri.getMatchRule().makeRange(v), false, null, null));
        }
        result.setFilter(feature.getQualifiers().toFilterString());
        result.setCopyright(feature.getCopyright(), feature.getCopyrightUrl());
        result.getLicenses().add(new License(feature.getLicense(), feature.getLicenseUrl()));
        return result;
    }

    public static InstallableUnit fromBundle(BundleInformation bundle) {
        return InstallableUnit.fromBundle(bundle, null);
    }

    public static InstallableUnit fromBundle(BundleInformation bundle, P2MetaDataInformation info) {
        InstallableUnit result = new InstallableUnit();
        result.setId(bundle.getId());
        result.setVersion(bundle.getVersion());
        result.setSingleton(bundle.isSingleton());
        Map<String, String> props = result.getProperties();
        InstallableUnit.addProperty(props, "org.eclipse.equinox.p2.name", bundle.getName());
        InstallableUnit.addProperty(props, "org.eclipse.equinox.p2.provider", bundle.getVendor());
        InstallableUnit.addProperty(props, "org.eclipse.equinox.p2.bundle.localization", bundle.getBundleLocalization());
        InstallableUnit.addProvides(result, "osgi.bundle", bundle.getId(), "" + bundle.getVersion());
        InstallableUnit.addProvides(result, "org.eclipse.equinox.p2.iu", bundle.getId(), "" + bundle.getVersion());
        InstallableUnit.addProvides(result, "org.eclipse.equinox.p2.eclipse.type", "bundle", "1.0.0");
        for (BundleInformation.PackageExport pe : bundle.getPackageExports()) {
            InstallableUnit.addProvides(result, "java.package", pe.getName(), InstallableUnit.makeVersion(pe.getVersion()));
        }
        InstallableUnit.addLocalization(props, result.getProvides(), bundle.getLocalization());
        for (BundleInformation.PackageImport pi : bundle.getPackageImports()) {
            InstallableUnit.addRequires(result, "java.package", pi.getName(), new Requirement(pi.getVersionRange(), pi.isOptional(), pi.isOptional() ? Boolean.valueOf(false) : null, null));
        }
        String systemBundleAlias = InstallableUnit.getSystemBundleAlias(info);
        for (BundleInformation.BundleRequirement br : bundle.getBundleRequirements()) {
            InstallableUnit.addRequires(result, "osgi.bundle", InstallableUnit.transformBundleName(systemBundleAlias, br.getId()), new Requirement(br.getVersionRange(), br.isOptional(), br.isOptional() ? Boolean.valueOf(false) : null, null));
        }
        result.getArtifacts().add(new Artifact(bundle.getId(), "osgi.bundle", bundle.getVersion()));
        try {
            HashMap<String, String> td = new HashMap<String, String>(1);
            td.put("manifest", InstallableUnit.makeManifest(bundle.getId(), bundle.getVersion()));
            result.getTouchpoints().add(new Touchpoint("org.eclipse.equinox.p2.osgi", "1.0.0", td));
        }
        catch (Exception e) {
            logger.warn("Failed to generate manifest", (Throwable)e);
        }
        return result;
    }

    private static String getSystemBundleAlias(P2MetaDataInformation info) {
        if (info.getSystemBundleAlias() != null && !info.getSystemBundleAlias().isEmpty()) {
            return info.getSystemBundleAlias();
        }
        return DEFAULT_SYSTEM_BUNDLE_ALIAS;
    }

    private static String transformBundleName(String systemBundleAlias, String id) {
        if (id.equals("system.bundle")) {
            return systemBundleAlias;
        }
        return id;
    }

    private static void addProperty(Map<String, String> props, String key, String value) {
        if (value == null) {
            return;
        }
        props.put(key, value);
    }

    private static void addProvides(InstallableUnit result, String namespace, String key, String value) {
        InstallableUnit.addProvides(result.getProvides(), namespace, key, value);
    }

    private static void addProvides(List<Entry<String>> provides, String namespace, String key, String value) {
        provides.add(new Entry<String>(namespace, key, value));
    }

    private static void addRequires(InstallableUnit result, String namespace, String key, Requirement value) {
        InstallableUnit.addRequires(result.getRequires(), namespace, key, value);
    }

    private static void addRequires(List<Entry<Requirement>> requires, String namespace, String key, Requirement value) {
        requires.add(new Entry<Requirement>(namespace, key, value));
    }

    private static void addLocalization(Map<String, String> properties, List<Entry<String>> provides, Map<String, Properties> localization) {
        for (String string : localization.keySet()) {
            InstallableUnit.addProvides(provides, "org.eclipse.equinox.p2.localization", string, "1.0.0");
        }
        for (Map.Entry entry : localization.entrySet()) {
            String locale = (String)entry.getKey();
            for (Map.Entry<Object, Object> pe : ((Properties)entry.getValue()).entrySet()) {
                properties.put(String.valueOf(locale) + "." + pe.getKey(), "" + pe.getValue());
            }
        }
    }

    private static String makeVersion(Version version) {
        if (version == null) {
            return "0.0.0";
        }
        return version.toString();
    }

    public static void writeXml(XMLStreamWriter xsw, List<InstallableUnit> ius) throws XMLStreamException {
        xsw.writeStartElement("units");
        xsw.writeAttribute("size", "" + ius.size());
        for (InstallableUnit iu : ius) {
            iu.writeXmlForUnit(xsw);
        }
        xsw.writeEndElement();
    }

    public void writeXml(XMLStreamWriter xsw) throws XMLStreamException {
        InstallableUnit.writeXml(xsw, Collections.singletonList(this));
    }

    public void writeXmlForUnit(XMLStreamWriter xsw) throws XMLStreamException {
        xsw.writeStartElement("unit");
        xsw.writeAttribute("id", this.id);
        xsw.writeAttribute("version", "" + this.version);
        xsw.writeAttribute("singleton", "" + this.singleton);
        xsw.writeEmptyElement("update");
        xsw.writeAttribute("id", this.id);
        xsw.writeAttribute("range", "[0.0.0," + this.version + ")");
        xsw.writeAttribute("severity", "0");
        xsw.writeStartElement("properties");
        xsw.writeAttribute("size", "" + this.properties.size());
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            xsw.writeStartElement("property");
            xsw.writeAttribute("name", entry.getKey());
            if (entry.getValue() != null) {
                xsw.writeAttribute("value", entry.getValue());
            }
            xsw.writeEndElement();
        }
        xsw.writeEndElement();
        xsw.writeStartElement("provides");
        xsw.writeAttribute("size", "" + this.provides.size());
        for (Entry entry : this.provides) {
            xsw.writeStartElement("provided");
            xsw.writeAttribute("namespace", entry.getNamespace());
            xsw.writeAttribute("name", entry.getKey());
            xsw.writeAttribute("version", (String)entry.getValue());
            xsw.writeEndElement();
        }
        xsw.writeEndElement();
        xsw.writeStartElement("requires");
        xsw.writeAttribute("size", "" + this.requires.size());
        for (Entry entry : this.requires) {
            String filterString;
            xsw.writeStartElement("required");
            xsw.writeAttribute("namespace", entry.getNamespace());
            xsw.writeAttribute("name", entry.getKey());
            xsw.writeAttribute("range", this.makeString(((Requirement)entry.getValue()).getRange()));
            if (((Requirement)entry.getValue()).isOptional()) {
                xsw.writeAttribute("optional", "true");
            }
            if (((Requirement)entry.getValue()).getGreedy() != null) {
                xsw.writeAttribute("greedy", "" + ((Requirement)entry.getValue()).getGreedy());
            }
            if ((filterString = ((Requirement)entry.getValue()).getFilter()) != null && !filterString.isEmpty()) {
                xsw.writeStartElement("filter");
                xsw.writeCharacters(((Requirement)entry.getValue()).getFilter());
                xsw.writeEndElement();
            }
            xsw.writeEndElement();
        }
        xsw.writeEndElement();
        if (this.filter != null && !this.filter.isEmpty()) {
            xsw.writeStartElement("filter");
            xsw.writeCharacters(this.filter);
            xsw.writeEndElement();
        }
        if (!this.artifacts.isEmpty()) {
            xsw.writeStartElement("artifacts");
            xsw.writeAttribute("size", "" + this.artifacts.size());
            for (Artifact artifact : this.artifacts) {
                xsw.writeEmptyElement("artifact");
                xsw.writeAttribute("classifier", artifact.getClassifer());
                xsw.writeAttribute("id", artifact.getId());
                xsw.writeAttribute("version", "" + artifact.getVersion());
            }
            xsw.writeEndElement();
        }
        if (this.touchpoints.isEmpty()) {
            xsw.writeEmptyElement("touchpoint");
            xsw.writeAttribute("id", "null");
            xsw.writeAttribute("version", "0.0.0");
        } else {
            for (Touchpoint touchpoint : this.touchpoints) {
                xsw.writeEmptyElement("touchpoint");
                xsw.writeAttribute("id", touchpoint.getId());
                xsw.writeAttribute("version", touchpoint.getVersion());
                if (touchpoint.getInstructions().isEmpty()) continue;
                xsw.writeStartElement("touchpointData");
                xsw.writeAttribute("size", "1");
                xsw.writeStartElement("instructions");
                xsw.writeAttribute("size", "" + touchpoint.getInstructions().size());
                for (Map.Entry<String, String> entry : touchpoint.getInstructions().entrySet()) {
                    xsw.writeStartElement("instruction");
                    xsw.writeAttribute("key", entry.getKey());
                    xsw.writeCharacters(entry.getValue());
                    xsw.writeEndElement();
                }
                xsw.writeEndElement();
                xsw.writeEndElement();
            }
        }
        xsw.writeStartElement("licenses");
        xsw.writeAttribute("size", "" + this.licenses.size());
        for (License license : this.licenses) {
            xsw.writeStartElement("license");
            if (license.getUri() != null) {
                xsw.writeAttribute("url", license.getUri());
                xsw.writeAttribute("uri", license.getUri());
            }
            if (license.getText() != null) {
                xsw.writeCData(license.getText());
            }
            xsw.writeEndElement();
        }
        xsw.writeEndElement();
        if (this.copyright != null || this.copyrightUrl != null) {
            xsw.writeStartElement("copyright");
            if (this.copyrightUrl != null) {
                xsw.writeAttribute("url", this.copyrightUrl);
                xsw.writeAttribute("uri", this.copyrightUrl);
            }
            if (this.copyright != null) {
                xsw.writeCData(this.copyright);
            }
            xsw.writeEndElement();
        }
        xsw.writeEndElement();
    }

    private String makeString(VersionRange range) {
        if (range == null) {
            return "0.0.0";
        }
        return range.toString();
    }

    private static String makeManifest(String id, Version version) throws IOException {
        Manifest mf = new Manifest();
        mf.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        mf.getMainAttributes().putValue("Bundle-SymbolicName", id);
        mf.getMainAttributes().putValue("Bundle-Version", "" + version);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        mf.write(out);
        out.close();
        return out.toString("UTF-8");
    }

    public static class Artifact {
        private final String id;
        private final String classifer;
        private final Version version;

        public Artifact(String id, String classifer, Version version) {
            this.id = id;
            this.classifer = classifer;
            this.version = version;
        }

        public String getId() {
            return this.id;
        }

        public String getClassifer() {
            return this.classifer;
        }

        public Version getVersion() {
            return this.version;
        }
    }

    public static class Entry<T> {
        private final String namespace;
        private final String key;
        private final T value;

        public Entry(String namespace, String key, T value) {
            this.namespace = namespace;
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public T getValue() {
            return this.value;
        }
    }

    public static class License {
        private final String text;
        private final String uri;

        public License(String text, String uri) {
            this.text = text;
            this.uri = uri;
        }

        public String getText() {
            return this.text;
        }

        public String getUri() {
            return this.uri;
        }
    }

    public static class Requirement {
        private final VersionRange range;
        private final boolean optional;
        private final Boolean greedy;
        private final String filter;

        public Requirement(VersionRange range, boolean optional, Boolean greedy, String filter) {
            this.range = range;
            this.optional = optional;
            this.greedy = greedy;
            this.filter = filter;
        }

        public String getFilter() {
            return this.filter;
        }

        public VersionRange getRange() {
            return this.range;
        }

        public boolean isOptional() {
            return this.optional;
        }

        public Boolean getGreedy() {
            return this.greedy;
        }
    }

    public static class Touchpoint {
        private final String id;
        private final String version;
        private final Map<String, String> instructions;

        public Touchpoint(String id, String version, Map<String, String> instructions) {
            this.id = id;
            this.version = version;
            this.instructions = instructions;
        }

        public String getId() {
            return this.id;
        }

        public String getVersion() {
            return this.version;
        }

        public Map<String, String> getInstructions() {
            return Collections.unmodifiableMap(this.instructions);
        }
    }
}

