/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.util;

import java.util.IdentityHashMap;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ServiceUtil {
    private static Map<Object, ServiceReference<?>> services = new IdentityHashMap();

    private ServiceUtil() {
    }

    public static <T> T getServiceOrNull(BundleContext bundleContext, Class<T> serviceClass) {
        try {
            return ServiceUtil.getService(bundleContext, serviceClass);
        }
        catch (MissingServiceException missingServiceException) {
            return null;
        }
    }

    public static <T> T getService(BundleContext bundleContext, Class<T> serviceClass) throws MissingServiceException {
        String serviceName = serviceClass.getName();
        ServiceReference serviceRef = bundleContext.getServiceReference(serviceName);
        if (serviceRef == null) {
            throw new MissingServiceException("Missing OSGi service " + serviceName);
        }
        Object service = bundleContext.getService(serviceRef);
        if (service == null) {
            throw new MissingServiceException("Missing OSGi service " + serviceName);
        }
        services.put(service, serviceRef);
        return (T)service;
    }

    public static void ungetService(BundleContext bundleContext, Object service) {
        ServiceReference<?> serviceRef;
        if (service != null && (serviceRef = services.remove(service)) != null) {
            bundleContext.ungetService(serviceRef);
        }
    }

    public static class MissingServiceException
    extends IllegalStateException {
        private static final long serialVersionUID = 1L;

        public MissingServiceException(String s) {
            super(s);
        }
    }
}

