/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.BuildAction;
import org.eclipse.ui.actions.GlobalBuildAction;
import org.eclipse.ui.dialogs.SearchPattern;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.actions.BuildUtilities;
import org.eclipse.ui.internal.ide.dialogs.ResourceComparator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.IProgressConstants2;

public class CleanDialog
extends MessageDialog {
    private static final String DIALOG_SETTINGS_SECTION = "CleanDialogSettings";
    private static final String DIALOG_ORIGIN_X = "DIALOG_X_ORIGIN";
    private static final String DIALOG_ORIGIN_Y = "DIALOG_Y_ORIGIN";
    private static final String DIALOG_WIDTH = "DIALOG_WIDTH";
    private static final String DIALOG_HEIGHT = "DIALOG_HEIGHT";
    private static final String TOGGLE_SELECTED = "TOGGLE_SELECTED";
    private static final String BUILD_NOW = "BUILD_NOW";
    private static final String BUILD_ALL = "BUILD_ALL";
    private Button alwaysCleanButton;
    private Button buildNowButton;
    private Button globalBuildButton;
    private Button projectBuildButton;
    private CheckboxTableViewer projectNames;
    private Object[] selection;
    private IWorkbenchWindow window;
    private Text filterText;
    private SearchPattern searchPattern = new SearchPattern();
    private Label clearLabel;
    private static final String CLEAR_ICON = "org.eclipse.ui.internal.dialogs.CLEANDIALOG_CLEAR_ICON";
    private static final String DISABLED_CLEAR_ICON = "org.eclipse.ui.internal.dialogs.CLEANDIALOG_DCLEAR_ICON";

    static {
        ImageDescriptor descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.ui", (String)"$nl$/icons/full/etool16/clear_co.png");
        if (descriptor != null) {
            JFaceResources.getImageRegistry().put(CLEAR_ICON, descriptor);
        }
        if ((descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.ui", (String)"$nl$/icons/full/dtool16/clear_co.png")) != null) {
            JFaceResources.getImageRegistry().put(DISABLED_CLEAR_ICON, descriptor);
        }
    }

    private static String getQuestion() {
        boolean autoBuilding = ResourcesPlugin.getWorkspace().isAutoBuilding();
        if (autoBuilding) {
            return IDEWorkbenchMessages.CleanDialog_buildCleanAuto;
        }
        return IDEWorkbenchMessages.CleanDialog_buildCleanManual;
    }

    public CleanDialog(IWorkbenchWindow window, IProject[] selection) {
        super(window.getShell(), IDEWorkbenchMessages.CleanDialog_title, null, CleanDialog.getQuestion(), 0, 0, new String[]{IDEWorkbenchMessages.CleanDialog_clean_button_label, IDialogConstants.CANCEL_LABEL});
        this.window = window;
        this.selection = selection;
        if (this.selection == null) {
            this.selection = new Object[0];
        }
        this.searchPattern.setPattern("");
    }

    protected void buttonPressed(int buttonId) {
        final boolean cleanAll = this.alwaysCleanButton.getSelection();
        final boolean buildAll = this.buildNowButton != null && this.buildNowButton.getSelection();
        final boolean globalBuild = this.globalBuildButton != null && this.globalBuildButton.getSelection();
        super.buttonPressed(buttonId);
        if (buttonId != 0) {
            return;
        }
        BuildUtilities.saveEditors(null);
        WorkspaceJob cleanJob = new WorkspaceJob(cleanAll ? IDEWorkbenchMessages.CleanDialog_cleanAllTaskName : IDEWorkbenchMessages.CleanDialog_cleanSelectedTaskName){

            public boolean belongsTo(Object family) {
                return ResourcesPlugin.FAMILY_MANUAL_BUILD.equals(family);
            }

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                CleanDialog.this.doClean(cleanAll, monitor);
                if (buildAll) {
                    if (globalBuild) {
                        GlobalBuildAction build = new GlobalBuildAction(CleanDialog.this.window, 10);
                        build.doBuild();
                    } else {
                        IProject[] projects = new IProject[CleanDialog.this.selection.length];
                        int i = 0;
                        while (i < CleanDialog.this.selection.length) {
                            projects[i] = (IProject)CleanDialog.this.selection[i];
                            ++i;
                        }
                        ProjectSubsetBuildAction projectBuild = new ProjectSubsetBuildAction((IShellProvider)CleanDialog.this.window, 10, projects);
                        projectBuild.runInBackground(ResourcesPlugin.getWorkspace().getRuleFactory().buildRule());
                    }
                }
                return Status.OK_STATUS;
            }
        };
        cleanJob.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().buildRule());
        cleanJob.setUser(true);
        cleanJob.setProperty(IProgressConstants2.SHOW_IN_TASKBAR_ICON_PROPERTY, (Object)Boolean.TRUE);
        cleanJob.schedule();
    }

    protected Control createCustomArea(Composite parent) {
        Composite area = new Composite(parent, 0);
        GridLayout areaLayout = new GridLayout();
        areaLayout.marginHeight = 0;
        areaLayout.marginWidth = 0;
        areaLayout.numColumns = 1;
        areaLayout.makeColumnsEqualWidth = false;
        area.setLayout((Layout)areaLayout);
        area.setLayoutData((Object)new GridData(1808));
        IDialogSettings settings = this.getDialogSettings(DIALOG_SETTINGS_SECTION);
        this.alwaysCleanButton = new Button(area, 32);
        this.alwaysCleanButton.setText(IDEWorkbenchMessages.CleanDialog_alwaysCleanAllButton);
        this.alwaysCleanButton.setSelection(!settings.getBoolean(TOGGLE_SELECTED));
        this.alwaysCleanButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.updateEnablement();
            if (!this.alwaysCleanButton.getSelection()) {
                this.setInitialFilterText();
            } else {
                this.filterText.setText("");
            }
        }));
        Composite filterTextArea = null;
        if (CleanDialog.useNativeSearchField(area)) {
            filterTextArea = new Composite(area, 0);
            this.filterText = new Text(filterTextArea, 2436);
        } else {
            filterTextArea = new Composite(area, 2048);
            this.filterText = new Text(filterTextArea, 4);
        }
        GridLayout filterTextLayout = new GridLayout();
        filterTextLayout.marginWidth = 0;
        filterTextLayout.marginHeight = 0;
        filterTextLayout.numColumns = 1;
        filterTextLayout.horizontalSpacing = 0;
        filterTextLayout.makeColumnsEqualWidth = false;
        filterTextArea.setLayout((Layout)filterTextLayout);
        filterTextArea.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.filterText.setMessage(IDEWorkbenchMessages.CleanDialog_typeFilterText);
        GridData gd = new GridData(4, 0x1000000, true, false);
        this.filterText.setLayoutData((Object)gd);
        this.filterText.addModifyListener(e -> {
            String filter = this.filterText.getText();
            if (filter.startsWith("*") || filter.startsWith("?")) {
                this.searchPattern.setPattern(filter);
            } else {
                this.searchPattern.setPattern("*" + filter);
            }
            if (filter.isEmpty()) {
                this.filterText.setMessage(IDEWorkbenchMessages.CleanDialog_typeFilterText);
            }
            this.showClearButton(!filter.isEmpty() && !filter.equals(IDEWorkbenchMessages.CleanDialog_typeFilterText));
            this.projectNames.refresh();
        });
        this.filterText.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                if (CleanDialog.this.filterText.getText().equals(IDEWorkbenchMessages.CleanDialog_typeFilterText)) {
                    CleanDialog.this.filterText.setText("");
                }
            }

            public void focusGained(FocusEvent e) {
            }
        });
        this.createClearTextNew(filterTextArea);
        this.showClearButton(false);
        this.createProjectSelectionTable(area);
        if (!this.alwaysCleanButton.getSelection()) {
            this.setInitialFilterText();
        }
        if (!ResourcesPlugin.getWorkspace().isAutoBuilding()) {
            SelectionListener updateEnablement = SelectionListener.widgetSelectedAdapter(e -> this.updateEnablement());
            this.buildNowButton = new Button(parent, 32);
            this.buildNowButton.setText(IDEWorkbenchMessages.CleanDialog_buildNowButton);
            String buildNow = settings.get(BUILD_NOW);
            this.buildNowButton.setSelection(buildNow == null || Boolean.valueOf(buildNow) != false);
            this.buildNowButton.setLayoutData((Object)new GridData(32));
            this.buildNowButton.addSelectionListener(updateEnablement);
            this.globalBuildButton = new Button(parent, 16);
            this.globalBuildButton.setText(IDEWorkbenchMessages.CleanDialog_globalBuildButton);
            String buildAll = settings.get(BUILD_ALL);
            this.globalBuildButton.setSelection(buildAll == null || Boolean.valueOf(buildAll) != false);
            GridData data = new GridData(32);
            data.horizontalIndent = 10;
            this.globalBuildButton.setLayoutData((Object)data);
            this.globalBuildButton.setEnabled(this.buildNowButton.getSelection());
            this.projectBuildButton = new Button(parent, 16);
            this.projectBuildButton.setText(IDEWorkbenchMessages.CleanDialog_buildSelectedProjectsButton);
            this.projectBuildButton.setSelection(!this.globalBuildButton.getSelection());
            data = new GridData(32);
            data.horizontalIndent = 10;
            this.projectBuildButton.setLayoutData((Object)data);
            this.projectBuildButton.setEnabled(this.buildNowButton.getSelection());
            SelectionListener buildRadioSelected = SelectionListener.widgetSelectedAdapter(e -> this.updateBuildRadioEnablement());
            this.globalBuildButton.addSelectionListener(buildRadioSelected);
            this.projectBuildButton.addSelectionListener(buildRadioSelected);
        }
        return area;
    }

    private static boolean useNativeSearchField(Composite composite) {
        boolean useNativeSearchField = true;
        Text testText = null;
        try {
            testText = new Text(composite, 384);
            useNativeSearchField = (testText.getStyle() & 0x100) != 0;
        }
        finally {
            if (testText != null) {
                testText.dispose();
            }
        }
        return useNativeSearchField;
    }

    private void setInitialFilterText() {
        this.filterText.setText(IDEWorkbenchMessages.CleanDialog_typeFilterText);
        this.filterText.selectAll();
        this.filterText.setFocus();
    }

    protected void showClearButton(boolean visible) {
        if (this.clearLabel != null) {
            this.clearLabel.setVisible(visible);
            GridData layoutData = (GridData)this.clearLabel.getLayoutData();
            layoutData.exclude = !visible;
            this.clearLabel.getParent().requestLayout();
        }
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.updateEnablement();
        return contents;
    }

    private void checkAllItemsIfSelectAllEventIsFired(SelectionEvent e) {
        if (e.item == null) {
            this.projectNames.setAllChecked(true);
            this.checkStateChanged();
        }
    }

    private void createProjectSelectionTable(Composite parent) {
        this.projectNames = CheckboxTableViewer.newCheckList((Composite)parent, (int)2048);
        this.projectNames.getTable().addSelectionListener(SelectionListener.widgetSelectedAdapter(this::checkAllItemsIfSelectAllEventIsFired));
        this.projectNames.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        this.projectNames.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.projectNames.setComparator((ViewerComparator)new ResourceComparator(1));
        this.projectNames.addFilter(new ViewerFilter(){
            private final IProject[] projectHolder = new IProject[1];

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (!(element instanceof IProject)) {
                    return false;
                }
                IProject project = (IProject)element;
                boolean isProjectNameMatchingPattern = CleanDialog.this.searchPattern.matches(project.getName());
                if (!(project.isAccessible() && isProjectNameMatchingPattern || CleanDialog.this.filterText.getText().equals(IDEWorkbenchMessages.CleanDialog_typeFilterText))) {
                    return false;
                }
                this.projectHolder[0] = project;
                return BuildUtilities.isEnabled(this.projectHolder, 15);
            }
        });
        this.projectNames.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 200;
        this.projectNames.getTable().setLayoutData((Object)data);
        this.projectNames.setCheckedElements(this.selection);
        Object[] checked = this.projectNames.getCheckedElements();
        if (checked.length > 0) {
            this.projectNames.reveal(checked[0]);
        }
        this.projectNames.addCheckStateListener(event -> this.checkStateChanged());
    }

    private void checkStateChanged() {
        this.selection = this.projectNames.getCheckedElements();
        this.updateEnablement();
    }

    protected void doClean(boolean cleanAll, IProgressMonitor monitor) throws CoreException {
        if (cleanAll) {
            ResourcesPlugin.getWorkspace().build(15, monitor);
        } else {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)IDEWorkbenchMessages.CleanDialog_cleanSelectedTaskName, (int)this.selection.length);
            Object[] objectArray = this.selection;
            int n = this.selection.length;
            int n2 = 0;
            while (n2 < n) {
                Object currentSelection = objectArray[n2];
                ((IProject)currentSelection).build(15, (IProgressMonitor)subMonitor.split(1));
                ++n2;
            }
        }
    }

    protected void updateEnablement() {
        this.projectNames.getTable().setEnabled(!this.alwaysCleanButton.getSelection());
        this.filterText.setEnabled(!this.alwaysCleanButton.getSelection());
        boolean enabled = this.selection.length > 0 || this.alwaysCleanButton.getSelection();
        this.getButton(0).setEnabled(enabled);
        if (this.globalBuildButton != null) {
            this.globalBuildButton.setEnabled(this.buildNowButton.getSelection());
        }
        if (this.projectBuildButton != null) {
            this.projectBuildButton.setEnabled(this.buildNowButton.getSelection());
        }
    }

    protected void updateBuildRadioEnablement() {
        this.projectBuildButton.setSelection(!this.globalBuildButton.getSelection());
    }

    public boolean close() {
        this.persistDialogSettings(this.getShell(), DIALOG_SETTINGS_SECTION);
        return super.close();
    }

    protected Point getInitialLocation(Point initialSize) {
        Point p = this.getInitialLocation(DIALOG_SETTINGS_SECTION);
        return p != null ? p : super.getInitialLocation(initialSize);
    }

    protected Point getInitialSize() {
        Point p = super.getInitialSize();
        return this.getInitialSize(DIALOG_SETTINGS_SECTION, p);
    }

    public Point getInitialLocation(String dialogSettingsSectionName) {
        IDialogSettings settings = this.getDialogSettings(dialogSettingsSectionName);
        try {
            int x = settings.getInt(DIALOG_ORIGIN_X);
            int y = settings.getInt(DIALOG_ORIGIN_Y);
            return new Point(x, y);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private IDialogSettings getDialogSettings(String dialogSettingsSectionName) {
        IDialogSettings settings = IDEWorkbenchPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(dialogSettingsSectionName);
        if (section == null) {
            section = settings.addNewSection(dialogSettingsSectionName);
        }
        return section;
    }

    private void persistDialogSettings(Shell shell, String dialogSettingsSectionName) {
        Point shellLocation = shell.getLocation();
        Point shellSize = shell.getSize();
        IDialogSettings settings = this.getDialogSettings(dialogSettingsSectionName);
        settings.put(DIALOG_ORIGIN_X, shellLocation.x);
        settings.put(DIALOG_ORIGIN_Y, shellLocation.y);
        settings.put(DIALOG_WIDTH, shellSize.x);
        settings.put(DIALOG_HEIGHT, shellSize.y);
        if (this.buildNowButton != null) {
            settings.put(BUILD_NOW, this.buildNowButton.getSelection());
        }
        if (this.globalBuildButton != null) {
            settings.put(BUILD_ALL, this.globalBuildButton.getSelection());
        }
        settings.put(TOGGLE_SELECTED, !this.alwaysCleanButton.getSelection());
    }

    private Point getInitialSize(String dialogSettingsSectionName, Point initialSize) {
        IDialogSettings settings = this.getDialogSettings(dialogSettingsSectionName);
        try {
            int x = settings.getInt(DIALOG_WIDTH);
            int y = settings.getInt(DIALOG_HEIGHT);
            return new Point(Math.max(x, initialSize.x), Math.max(y, initialSize.y));
        }
        catch (NumberFormatException numberFormatException) {
            return initialSize;
        }
    }

    protected boolean isResizable() {
        return true;
    }

    private void createClearTextNew(Composite parent) {
        if ((this.filterText.getStyle() & 0x100) == 0) {
            ((GridLayout)parent.getLayout()).numColumns = 2;
            final Image inactiveImage = JFaceResources.getImageRegistry().getDescriptor(DISABLED_CLEAR_ICON).createImage();
            final Image activeImage = JFaceResources.getImageRegistry().getDescriptor(CLEAR_ICON).createImage();
            final Image pressedImage = new Image((Device)parent.getDisplay(), activeImage, 2);
            final Label clearButton = new Label(parent, 0);
            clearButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            clearButton.setImage(inactiveImage);
            clearButton.setBackground(parent.getDisplay().getSystemColor(25));
            clearButton.setToolTipText(IDEWorkbenchMessages.CleanDialog_clearToolTip);
            clearButton.addMouseListener((MouseListener)new MouseAdapter(){
                private MouseMoveListener fMoveListener;

                public void mouseDown(MouseEvent e) {
                    clearButton.setImage(pressedImage);
                    this.fMoveListener = new MouseMoveListener(){
                        private boolean fMouseInButton = true;

                        public void mouseMove(MouseEvent event) {
                            boolean mouseInButton = this.isMouseInButton(event);
                            if (mouseInButton != this.fMouseInButton) {
                                this.fMouseInButton = mouseInButton;
                                clearButton.setImage(mouseInButton ? pressedImage : inactiveImage);
                            }
                        }
                    };
                    clearButton.addMouseMoveListener(this.fMoveListener);
                }

                public void mouseUp(MouseEvent e) {
                    if (this.fMoveListener != null) {
                        clearButton.removeMouseMoveListener(this.fMoveListener);
                        this.fMoveListener = null;
                        boolean mouseInButton = this.isMouseInButton(e);
                        clearButton.setImage(mouseInButton ? activeImage : inactiveImage);
                        if (mouseInButton) {
                            CleanDialog.this.filterText.setText("");
                            CleanDialog.this.filterText.selectAll();
                            CleanDialog.this.filterText.setFocus();
                        }
                    }
                }

                private boolean isMouseInButton(MouseEvent e) {
                    Point buttonSize = clearButton.getSize();
                    return e.x >= 0 && e.x < buttonSize.x && e.y >= 0 && e.y < buttonSize.y;
                }
            });
            clearButton.addMouseTrackListener(new MouseTrackListener(){

                public void mouseEnter(MouseEvent e) {
                    clearButton.setImage(activeImage);
                }

                public void mouseExit(MouseEvent e) {
                    clearButton.setImage(inactiveImage);
                }

                public void mouseHover(MouseEvent e) {
                }
            });
            clearButton.addDisposeListener(e -> {
                inactiveImage.dispose();
                activeImage.dispose();
                pressedImage.dispose();
            });
            clearButton.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

                public void getName(AccessibleEvent e) {
                    e.result = IDEWorkbenchMessages.CleanDialog_AccessibleListenerClearButton;
                }
            });
            clearButton.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

                public void getRole(AccessibleControlEvent e) {
                    e.detail = 43;
                }
            });
            this.clearLabel = clearButton;
        }
    }

    private static class ProjectSubsetBuildAction
    extends BuildAction {
        private IProject[] projectsToBuild = new IProject[0];

        public ProjectSubsetBuildAction(IShellProvider shellProvider, int type, IProject[] projects) {
            super(shellProvider, type);
            this.projectsToBuild = projects;
        }

        @Override
        protected List<? extends IResource> getSelectedResources() {
            return Arrays.asList(this.projectsToBuild);
        }
    }
}

