/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.resources.backend;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Queue;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.oomph.resources.backend.BackendException;
import org.eclipse.oomph.resources.backend.BackendResource;
import org.eclipse.oomph.resources.backend.BackendSystem;
import org.eclipse.oomph.util.IOUtil;

public final class BackendFile
extends BackendResource {
    BackendFile(BackendSystem system, URI systemRelativeURI) {
        super(system, systemRelativeURI);
    }

    @Override
    public BackendResource.Type getType() {
        return BackendResource.Type.FILE;
    }

    public InputStream getContents(IProgressMonitor monitor) throws BackendException, OperationCanceledException, IOException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            BackendSystem system = this.getSystem();
            return system.getContents(this, monitor);
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (OperationCanceledException ex) {
            throw ex;
        }
        catch (BackendException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new BackendException(ex);
        }
    }

    public byte[] getContentBytes(IProgressMonitor monitor) throws BackendException, OperationCanceledException, IOException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IOUtil.copy((InputStream)this.getContents(monitor), (OutputStream)baos);
            return baos.toByteArray();
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (OperationCanceledException ex) {
            throw ex;
        }
        catch (BackendException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new BackendException(ex);
        }
    }

    @Override
    void visit(Queue<BackendResource> queue, BackendResource.Visitor visitor, IProgressMonitor monitor) throws BackendException, OperationCanceledException {
        visitor.visit(this, monitor);
    }
}

