/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.version.ui.quickfixes;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.oomph.internal.version.VersionBuilderArguments;
import org.eclipse.oomph.version.Markers;
import org.eclipse.oomph.version.ui.quickfixes.AbstractResolution;
import org.eclipse.oomph.version.ui.quickfixes.Messages;

public class ConfigureResolution
extends AbstractResolution {
    private String option;

    public ConfigureResolution(IMarker marker, String option) {
        super(marker, Messages.ConfigureResolution_label, "icons/correction_configure.gif");
        this.option = option;
    }

    public String getDescription() {
        IProject project = this.getMarker().getResource().getProject();
        return "Set " + this.option + " = true in '/" + project.getName() + "/.project'";
    }

    protected boolean isApplicable(IMarker marker) {
        String requiredOption = Markers.getQuickFixConfigureOption((IMarker)marker);
        return this.option.equals(requiredOption);
    }

    protected void apply(IMarker marker) throws Exception {
        String option = Markers.getQuickFixConfigureOption((IMarker)marker);
        String value = Markers.getQuickFixConfigureValue((IMarker)marker);
        IProject project = marker.getResource().getProject();
        VersionBuilderArguments arguments = new VersionBuilderArguments(project);
        arguments.put((Object)option, (Object)value);
        arguments.applyTo(project);
    }
}

