/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.transformation.ocl;

import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.mdht.transformation.ocl.OCLTransformation;
import org.eclipse.ocl.expressions.EnumLiteralExp;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.OperationCallExp;

public abstract class OCL2ProgrammingLanguageTransformation<PK, C, O extends EModelElement, P, EL, PM, S, COA, SSA, CT, CLS, E>
extends OCLTransformation<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> {
    private int iCounter;

    @Override
    public String step(String set, String property) {
        if (set.startsWith("Set(") && set.endsWith(")") && !set.contains(".")) {
            String i = set.substring("Set(".length(), set.length() - ")".length());
            return this.referVar(String.valueOf(i) + "." + property);
        }
        String i = this.newVar();
        return this.iterator(String.valueOf(i) + "." + property, i, "collect", set);
    }

    @Override
    public final String newVar() {
        return "i" + this.iCounter++;
    }

    @Override
    protected final String selfNode() {
        return this.referVar(this.selfVariable);
    }

    @Override
    protected String op(String operator) {
        if ("<>".equals(operator)) {
            return "!=";
        }
        if ("=".equals(operator)) {
            return "==";
        }
        if ("and".equals(operator)) {
            return " && ";
        }
        if ("or".equals(operator)) {
            return " || ";
        }
        if ("xor".equals(operator)) {
            return " ^ ";
        }
        if ("not".equals(operator)) {
            return "!";
        }
        return operator;
    }

    @Override
    public String compare(String opName, String xpath, String xpath2) {
        if ("=".equals(opName) && (xpath.startsWith("Set(") || xpath.startsWith("Flatten(")) && xpath.endsWith(")") && !xpath.endsWith(this.count(""))) {
            return this.contains(xpath, xpath2);
        }
        return "One(" + xpath + ")" + this.op(opName) + xpath2;
    }

    @Override
    public final String referVar(String variable) {
        return "Set(" + variable + ")";
    }

    @Override
    protected String transformDomainSpecific(OperationCallExp op, String opName) {
        if ("size".equals(opName)) {
            if ("String".equals(this.getName(op.getSource().getType()))) {
                return this.length("One(" + this.transform(op.getSource()) + ")");
            }
            return this.count(this.transform(op.getSource()));
        }
        return super.transformDomainSpecific(op, opName);
    }

    public abstract String length(String var1);

    public abstract String count(String var1);

    @Override
    public final String childNode(String step) {
        String i = this.newVar();
        return this.iterator("getClinicalStatement(" + i + ")", i, "collect", step);
    }

    @Override
    public String transform(OCLExpression exp) {
        if (exp instanceof EnumLiteralExp) {
            EnumLiteralExp enumLiteralExp = (EnumLiteralExp)exp;
            return String.valueOf(this.getName(enumLiteralExp.getType())) + "." + this.getName(enumLiteralExp.getReferredEnumLiteral());
        }
        return super.transform(exp);
    }

    @Override
    public String cosmetics(String result) {
        result = result.replace("true()", "true");
        result = result.replace("false()", "false");
        return result;
    }

    @Override
    public final String isEmpty(String set) {
        return String.valueOf(this.count(set)) + "==0";
    }

    @Override
    public final String isNotEmpty(String set) {
        return String.valueOf(this.count(set)) + "!=0";
    }

    @Override
    public String getValue(P property, String value) {
        Object type = this.getType(property);
        if (this.getOCLInstance().getEnvironment().getUMLReflection().isEnumeration(type)) {
            return String.valueOf(this.getName(type)) + "." + value;
        }
        if ("EBooleanObject".equals(this.getName(type)) || "Boolean".equals(this.getName(type))) {
            return value;
        }
        return "\"" + value.replace("\r", "").replace("\n", "\\n\"\n\t\t\t\t+ \"") + "\"";
    }

    @Override
    public abstract String typeCast(String var1, String var2);

    @Override
    public abstract String instanceOf(String var1, String var2);

    @Override
    public String one(String transform) {
        return "One(" + transform + ")";
    }
}

