/*
 * Decompiled with CFR 0.152.
 */
package traceability.presentation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import traceability.presentation.TraceUtils;
import traceability.presentation.Tracing;
import traceability.presentation.table.GroupItem;

public class GroupOrganizer {
    public static void organizeTreeByFanOut(List<Object> parents, Tracing tracing) {
        HashMap<Object, GroupItem> existingGroups = new HashMap<Object, GroupItem>();
        ArrayList<Object> elements = new ArrayList<Object>(parents);
        parents.clear();
        GroupItem rootGroup = null;
        for (Object e : elements) {
            EObject eObject = (EObject)e;
            rootGroup = TraceUtils.lookupOrCreate(eObject, existingGroups);
            EObject parent = tracing.backward.get(eObject);
            while (parent != null) {
                if (parent instanceof EObject) {
                    GroupItem parentGroup = TraceUtils.lookupOrCreate(parent, existingGroups);
                    parentGroup.addChild(rootGroup);
                    rootGroup = parentGroup;
                }
                parent = tracing.backward.get(parent);
            }
            if (parents.contains(rootGroup)) continue;
            parents.add(rootGroup);
        }
        GroupOrganizer.sortByFanOut(parents);
    }

    public static void sortByFanOut(List<Object> list) {
        for (Object object : list) {
            if (!(object instanceof GroupItem)) continue;
            GroupItem groupItem = (GroupItem)object;
            GroupOrganizer.sortByFanOut(groupItem.childrenOf);
            if (groupItem.childrenOf.size() != 1) continue;
            Object child = groupItem.childrenOf.get(0);
            groupItem.childrenOf.clear();
            if (!(child instanceof GroupItem)) continue;
            groupItem.childrenOf.addAll(((GroupItem)child).childrenOf);
        }
    }

    public static void organizeTreeByContainment(List<Object> parents, Tracing tracing, EObject model) {
        HashMap<Object, GroupItem> existingGroups = new HashMap<Object, GroupItem>();
        ArrayList<Object> elements = new ArrayList<Object>(parents);
        ArrayList<EObject> freeElements = new ArrayList<EObject>();
        parents.clear();
        GroupItem rootGroup = null;
        for (Object e : elements) {
            EObject eObject = (EObject)e;
            EObject dataComponent = tracing.findModel(model, eObject);
            if (dataComponent == null) {
                freeElements.add(eObject);
                continue;
            }
            rootGroup = TraceUtils.lookupOrCreate(dataComponent, existingGroups);
            rootGroup.addChild(eObject);
            EObject parent = dataComponent.eContainer();
            while (parent != null && tracing.findModel(model, parent) != null) {
                EObject dataComponent2 = parent;
                GroupItem parentGroup = TraceUtils.lookupOrCreate(dataComponent2, existingGroups);
                parents.remove(rootGroup);
                parentGroup.addChild(rootGroup);
                rootGroup = parentGroup;
                parent = parent.eContainer();
            }
            if (parents.contains(rootGroup)) continue;
            parents.add(rootGroup);
        }
        parents.addAll(freeElements);
        for (Object object : parents) {
            GroupOrganizer.sortByContainment(object, tracing);
        }
    }

    public static void sortByContainment(Object object, Tracing tracing) {
        if (!(object instanceof GroupItem)) {
            return;
        }
        GroupItem groupItem = (GroupItem)object;
        GroupOrganizer.removeRedundancy(groupItem);
        for (Object child : groupItem.childrenOf) {
            GroupOrganizer.sortByContainment(child, tracing);
        }
    }

    public static void removeRedundancy(GroupItem groupItem) {
        for (Object child : new ArrayList<Object>(groupItem.childrenOf)) {
            if (child instanceof GroupItem) continue;
            groupItem.element = (EObject)child;
            groupItem.childrenOf.remove(groupItem.element);
            break;
        }
    }
}

