/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.cda.xml.ui.handlers;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mdht.cda.xml.ui.handlers.CDAValueUtil;
import org.eclipse.mdht.cda.xml.ui.handlers.GenerateCDADataHandler;
import org.eclipse.mdht.cda.xml.ui.handlers.SheetHeaderUtil;
import org.eclipse.mdht.cda.xml.ui.handlers.SpreadsheetSerializer;
import org.eclipse.mdht.uml.cda.Act;
import org.eclipse.mdht.uml.cda.Author;
import org.eclipse.mdht.uml.cda.Encounter;
import org.eclipse.mdht.uml.cda.Observation;
import org.eclipse.mdht.uml.cda.Organizer;
import org.eclipse.mdht.uml.cda.Participant2;
import org.eclipse.mdht.uml.cda.PatientRole;
import org.eclipse.mdht.uml.cda.Procedure;
import org.eclipse.mdht.uml.cda.Section;
import org.eclipse.mdht.uml.cda.ServiceEvent;
import org.eclipse.mdht.uml.cda.StrucDocText;
import org.eclipse.mdht.uml.cda.SubstanceAdministration;
import org.eclipse.mdht.uml.cda.util.CDAUtil;
import org.eclipse.mdht.uml.hl7.datatypes.ANY;
import org.eclipse.mdht.uml.hl7.datatypes.CD;
import org.eclipse.mdht.uml.hl7.datatypes.CE;
import org.eclipse.mdht.uml.hl7.datatypes.II;
import org.openhealthtools.mdht.uml.cda.consol.AdmissionMedication;
import org.openhealthtools.mdht.uml.cda.consol.AdvanceDirectiveObservation;
import org.openhealthtools.mdht.uml.cda.consol.AdvanceDirectivesSectionEntriesOptional;
import org.openhealthtools.mdht.uml.cda.consol.AllergiesSectionEntriesOptional;
import org.openhealthtools.mdht.uml.cda.consol.AllergyObservation;
import org.openhealthtools.mdht.uml.cda.consol.AllergyObservation2;
import org.openhealthtools.mdht.uml.cda.consol.AllergyProblemAct;
import org.openhealthtools.mdht.uml.cda.consol.ChiefComplaintAndReasonForVisitSection;
import org.openhealthtools.mdht.uml.cda.consol.ComplicationsSection;
import org.openhealthtools.mdht.uml.cda.consol.CoverageActivity;
import org.openhealthtools.mdht.uml.cda.consol.CriticalityObservation;
import org.openhealthtools.mdht.uml.cda.consol.DischargeMedication;
import org.openhealthtools.mdht.uml.cda.consol.DischargeMedicationsSectionEntriesOptional2;
import org.openhealthtools.mdht.uml.cda.consol.FamilyHistorySection;
import org.openhealthtools.mdht.uml.cda.consol.GoalsSection;
import org.openhealthtools.mdht.uml.cda.consol.HealthStatusEvaluationsAndOutcomesSection;
import org.openhealthtools.mdht.uml.cda.consol.HistoryOfPastIllnessSection;
import org.openhealthtools.mdht.uml.cda.consol.HospitalAdmissionMedicationsSectionEntriesOptional;
import org.openhealthtools.mdht.uml.cda.consol.HospitalDischargeDiagnosisSection;
import org.openhealthtools.mdht.uml.cda.consol.ImmunizationsSectionEntriesOptional;
import org.openhealthtools.mdht.uml.cda.consol.Indication;
import org.openhealthtools.mdht.uml.cda.consol.Instructions;
import org.openhealthtools.mdht.uml.cda.consol.InstructionsSection;
import org.openhealthtools.mdht.uml.cda.consol.MedicationsAdministeredSection;
import org.openhealthtools.mdht.uml.cda.consol.MedicationsSectionEntriesOptional;
import org.openhealthtools.mdht.uml.cda.consol.NoteActivity;
import org.openhealthtools.mdht.uml.cda.consol.OutcomeObservation;
import org.openhealthtools.mdht.uml.cda.consol.PayersSection;
import org.openhealthtools.mdht.uml.cda.consol.PostprocedureDiagnosisSection;
import org.openhealthtools.mdht.uml.cda.consol.PreoperativeDiagnosisSection;
import org.openhealthtools.mdht.uml.cda.consol.ProblemConcernAct;
import org.openhealthtools.mdht.uml.cda.consol.ProblemObservation;
import org.openhealthtools.mdht.uml.cda.consol.ProblemSectionEntriesOptional;
import org.openhealthtools.mdht.uml.cda.consol.ProcedureActivityAct;
import org.openhealthtools.mdht.uml.cda.consol.ProcedureActivityObservation;
import org.openhealthtools.mdht.uml.cda.consol.ProcedureFindingsSection;
import org.openhealthtools.mdht.uml.cda.consol.ProcedureIndicationsSection;
import org.openhealthtools.mdht.uml.cda.consol.ProceduresSectionEntriesOptional;
import org.openhealthtools.mdht.uml.cda.consol.ReactionObservation;
import org.openhealthtools.mdht.uml.cda.consol.ResultOrganizer;
import org.openhealthtools.mdht.uml.cda.consol.ResultsSectionEntriesOptional;
import org.openhealthtools.mdht.uml.cda.consol.SeverityObservation;
import org.openhealthtools.mdht.uml.cda.consol.SocialHistorySection;
import org.openhealthtools.mdht.uml.cda.consol.VitalSignsSectionEntriesOptional;
import org.openhealthtools.mdht.uml.cda.consol.util.ConsolSwitch;

class SectionSwitch
extends ConsolSwitch<Boolean> {
    boolean firstpass = true;
    private static HashMap<String, Integer> emptySectionOffset = new HashMap();
    private CDAValueUtil.DocumentMetadata documentMetadata;
    private List<Encounter> encounters = null;
    private String fileName = null;
    private PatientRole patientRole = null;
    private CDAUtil.Query query = null;
    private ServiceEvent serviceEvent = null;
    private Sheet sheet = null;

    public boolean isFirstpass() {
        return this.firstpass;
    }

    public void setFirstpass(boolean firstpass) {
        this.firstpass = firstpass;
    }

    public Boolean caseHospitalAdmissionMedicationsSectionEntriesOptional(HospitalAdmissionMedicationsSectionEntriesOptional section) {
        if (section.getAdmissionMedications() != null && !section.getAdmissionMedications().isEmpty()) {
            for (AdmissionMedication admissionMedication : section.getAdmissionMedications()) {
                SpreadsheetSerializer.appendToSubstanceAdministrationSheet(this.query, this.sheet, this.documentMetadata, this.patientRole, this.serviceEvent, this.encounters, (List<? extends SubstanceAdministration>)admissionMedication.getMedicationActivities(), this.fileName);
            }
        } else {
            this.appendEmptySection(this.query, this.sheet, (Section)section, this.fileName);
        }
        return Boolean.TRUE;
    }

    public Boolean caseHospitalDischargeDiagnosisSection(HospitalDischargeDiagnosisSection section) {
        if (this.sheet.getPhysicalNumberOfRows() == 0) {
            Row row1 = null;
            Row row2 = this.sheet.createRow(0);
            int offset = SheetHeaderUtil.createPatientHeader(row1, row2, 0);
            offset = SheetHeaderUtil.createEncounterIDHeader(row1, row2, offset);
            offset = SheetHeaderUtil.createProblemObservationHeader(row1, row2, offset);
            emptySectionOffset.put(this.sheet.getSheetName(), offset);
        }
        if (section.getHospitalDischargeDiagnosis() != null && !section.getHospitalDischargeDiagnosis().getProblemObservations().isEmpty()) {
            this.appendToProblemsSheet2(this.query, this.sheet, this.patientRole, this.serviceEvent, (EList<ProblemObservation>)section.getHospitalDischargeDiagnosis().getProblemObservations(), this.encounters, this.fileName);
        } else {
            this.appendEmptySection(this.query, this.sheet, (Section)section, this.fileName);
        }
        return Boolean.TRUE;
    }

    public Boolean caseComplicationsSection(ComplicationsSection section) {
        if (this.sheet.getPhysicalNumberOfRows() == 0) {
            Row row1 = null;
            Row row2 = this.sheet.createRow(0);
            int offset = SheetHeaderUtil.createPatientHeader(row1, row2, 0);
            offset = SheetHeaderUtil.createEncounterIDHeader(row1, row2, offset);
            offset = SheetHeaderUtil.createProblemObservationHeader(row1, row2, offset);
            emptySectionOffset.put(this.sheet.getSheetName(), offset);
        }
        if (section.getProblemObservations() != null && !section.getProblemObservations().isEmpty()) {
            this.appendToProblemsSheet2(this.query, this.sheet, this.patientRole, this.serviceEvent, (EList<ProblemObservation>)section.getProblemObservations(), this.encounters, this.fileName);
        } else {
            this.appendEmptySection(this.query, this.sheet, (Section)section, this.fileName);
        }
        return Boolean.TRUE;
    }

    public SectionSwitch(CDAUtil.Query query, Sheet sheet, CDAValueUtil.DocumentMetadata organizationAndSoftware, PatientRole patientRole, ServiceEvent serviceEvent, List<Encounter> encounters, String fileName) {
        this.query = query;
        this.sheet = sheet;
        this.documentMetadata = organizationAndSoftware;
        this.patientRole = patientRole;
        this.serviceEvent = serviceEvent;
        this.encounters = encounters;
        this.fileName = fileName;
    }

    public Boolean caseProcedureIndicationsSection(ProcedureIndicationsSection section) {
        section.getIndications();
        if (this.sheet.getPhysicalNumberOfRows() == 0) {
            Row row1 = null;
            Row row2 = this.sheet.createRow(0);
            int offset = SheetHeaderUtil.createPatientHeader(row1, row2, 0);
            offset = SheetHeaderUtil.createEncounterIDHeader(row1, row2, offset);
            offset = SheetHeaderUtil.createObservationHeaderWithClinicalNotes(row1, row2, offset);
            emptySectionOffset.put(this.sheet.getSheetName(), offset);
        }
        if (section.getIndications() != null && !section.getIndications().isEmpty()) {
            this.appendIndicationSheet(this.query, this.sheet, this.documentMetadata, this.patientRole, this.serviceEvent, (EList<Indication>)section.getIndications(), this.encounters, this.fileName);
        } else {
            this.appendEmptySection(this.query, this.sheet, (Section)section, this.fileName);
        }
        return Boolean.TRUE;
    }

    public Boolean casePostprocedureDiagnosisSection(PostprocedureDiagnosisSection section) {
        if (this.sheet.getPhysicalNumberOfRows() == 0) {
            Row row1 = null;
            Row row2 = this.sheet.createRow(0);
            int offset = SheetHeaderUtil.createPatientHeader(row1, row2, 0);
            offset = SheetHeaderUtil.createEncounterIDHeader(row1, row2, offset);
            offset = SheetHeaderUtil.createProblemObservationHeader(row1, row2, offset);
            emptySectionOffset.put(this.sheet.getSheetName(), offset);
        }
        if (section.getPostprocedureDiagnosis() != null && !section.getPostprocedureDiagnosis().getProblemObservations().isEmpty()) {
            this.appendToProblemsSheet2(this.query, this.sheet, this.patientRole, this.serviceEvent, (EList<ProblemObservation>)section.getPostprocedureDiagnosis().getProblemObservations(), this.encounters, this.fileName);
        } else {
            this.appendEmptySection(this.query, this.sheet, (Section)section, this.fileName);
        }
        return Boolean.TRUE;
    }

    public Boolean casePreoperativeDiagnosisSection(PreoperativeDiagnosisSection section) {
        if (this.sheet.getPhysicalNumberOfRows() == 0) {
            Row row1 = null;
            Row row2 = this.sheet.createRow(0);
            int offset = SheetHeaderUtil.createPatientHeader(row1, row2, 0);
            offset = SheetHeaderUtil.createEncounterIDHeader(row1, row2, offset);
            offset = SheetHeaderUtil.createProblemObservationHeader(row1, row2, offset);
            emptySectionOffset.put(this.sheet.getSheetName(), offset);
        }
        if (section.getPreoperativeDiagnosis() != null && !section.getPreoperativeDiagnosis().getProblemObservations().isEmpty()) {
            this.appendToProblemsSheet2(this.query, this.sheet, this.patientRole, this.serviceEvent, (EList<ProblemObservation>)section.getPreoperativeDiagnosis().getProblemObservations(), this.encounters, this.fileName);
        } else {
            this.appendEmptySection(this.query, this.sheet, (Section)section, this.fileName);
        }
        return Boolean.TRUE;
    }

    public Boolean caseProcedureFindingsSection(ProcedureFindingsSection section) {
        if (this.sheet.getPhysicalNumberOfRows() == 0) {
            Row row1 = null;
            Row row2 = this.sheet.createRow(0);
            int offset = SheetHeaderUtil.createPatientHeader(row1, row2, 0);
            offset = SheetHeaderUtil.createEncounterIDHeader(row1, row2, offset);
            offset = SheetHeaderUtil.createProblemObservationHeader(row1, row2, offset);
            emptySectionOffset.put(this.sheet.getSheetName(), offset);
        }
        if (section.getProblemObservations() != null && !section.getProblemObservations().isEmpty()) {
            this.appendToProblemsSheet2(this.query, this.sheet, this.patientRole, this.serviceEvent, (EList<ProblemObservation>)section.getProblemObservations(), this.encounters, this.fileName);
        } else {
            this.appendEmptySection(this.query, this.sheet, (Section)section, this.fileName);
        }
        return Boolean.TRUE;
    }

    public Boolean caseAdvanceDirectivesSectionEntriesOptional(AdvanceDirectivesSectionEntriesOptional section) {
        if (this.sheet.getPhysicalNumberOfRows() == 0) {
            Row row1 = null;
            Row row2 = this.sheet.createRow(0);
            int offset = SheetHeaderUtil.createPatientHeader(row1, row2, 0);
            offset = SheetHeaderUtil.createEncounterIDHeader(row1, row2, offset);
            offset = SheetHeaderUtil.createAdvanceDirectivesHeader(row1, row2, offset);
            emptySectionOffset.put(this.sheet.getSheetName(), offset);
        }
        if (section.getAdvanceDirectiveObservations() != null && !section.getAdvanceDirectiveObservations().isEmpty()) {
            this.appendToAdvancedDirectivesSheet(this.query, this.sheet, this.patientRole, this.serviceEvent, (EList<AdvanceDirectiveObservation>)section.getAdvanceDirectiveObservations(), this.encounters, this.fileName);
        } else {
            this.appendEmptySection(this.query, this.sheet, (Section)section, this.fileName);
        }
        return Boolean.TRUE;
    }

    public Boolean casePayersSection(PayersSection section) {
        if (this.sheet.getPhysicalNumberOfRows() == 0) {
            Row row1 = null;
            Row row2 = this.sheet.createRow(0);
            int offset = SheetHeaderUtil.createPatientHeader(row1, row2, 0);
            offset = SheetHeaderUtil.createEncounterIDHeader(row1, row2, offset);
            offset = SheetHeaderUtil.createPayersHeader(row1, row2, offset);
            emptySectionOffset.put(this.sheet.getSheetName(), offset);
        }
        if (section.getCoverageActivities() != null && !section.getCoverageActivities().isEmpty()) {
            this.appendToCoverageActivitiesSheet(this.query, this.sheet, this.documentMetadata, this.patientRole, this.serviceEvent, (EList<CoverageActivity>)section.getCoverageActivities(), this.encounters, this.fileName);
        } else {
            this.appendEmptySection(this.query, this.sheet, (Section)section, this.fileName);
        }
        return Boolean.TRUE;
    }

    public Boolean caseInstructionsSection(InstructionsSection section) {
        if (this.sheet.getPhysicalNumberOfRows() == 0) {
            Row row1 = null;
            Row row2 = this.sheet.createRow(0);
            int offset = SheetHeaderUtil.createPatientHeader(row1, row2, 0);
            offset = SheetHeaderUtil.createEncounterIDHeader(row1, row2, offset);
            offset = SheetHeaderUtil.createInstructionsHeader(row1, row2, offset);
            emptySectionOffset.put(this.sheet.getSheetName(), offset);
        }
        if (section.getInstructionss() != null && !section.getInstructionss().isEmpty()) {
            this.appendToInstructionSheet(this.query, this.sheet, this.documentMetadata, this.patientRole, this.serviceEvent, (EList<Instructions>)section.getInstructionss(), this.encounters, this.fileName);
        } else {
            this.appendEmptySection(this.query, this.sheet, (Section)section, this.fileName);
        }
        return Boolean.TRUE;
    }

    public Boolean caseHealthStatusEvaluationsAndOutcomesSection(HealthStatusEvaluationsAndOutcomesSection section) {
        if (this.sheet.getPhysicalNumberOfRows() == 0) {
            Row row1 = null;
            Row row2 = this.sheet.createRow(0);
            int offset = SheetHeaderUtil.createPatientHeader(row1, row2, 0);
            offset = SheetHeaderUtil.createEncounterIDHeader(row1, row2, offset);
            offset = SheetHeaderUtil.createAllergyHeader(row1, row2, offset);
            emptySectionOffset.put(this.sheet.getSheetName(), offset);
        }
        if (section.getOutcomeObservations() != null && !section.getOutcomeObservations().isEmpty()) {
            this.appendToOutcomeObservationSheet(this.query, this.sheet, this.documentMetadata, this.patientRole, this.serviceEvent, (EList<OutcomeObservation>)section.getOutcomeObservations(), this.encounters, this.fileName);
        } else {
            this.appendEmptySection(this.query, this.sheet, (Section)section, this.fileName);
        }
        return Boolean.TRUE;
    }

    public Boolean caseAllergiesSectionEntriesOptional(AllergiesSectionEntriesOptional section) {
        if (this.sheet.getPhysicalNumberOfRows() == 0) {
            Row row1 = null;
            Row row2 = this.sheet.createRow(0);
            int offset = SheetHeaderUtil.createPatientHeader(row1, row2, 0);
            offset = SheetHeaderUtil.createEncounterIDHeader(row1, row2, offset);
            offset = SheetHeaderUtil.createAllergyHeader(row1, row2, offset);
            emptySectionOffset.put(this.sheet.getSheetName(), offset);
        }
        if (section.getAllergyProblemActs() != null && !section.getAllergyProblemActs().isEmpty()) {
            SectionSwitch.appendToAllergiesSheet(this.query, this.sheet, this.documentMetadata, this.patientRole, this.serviceEvent, (List<AllergyProblemAct>)section.getAllergyProblemActs(), this.encounters, this.fileName);
        } else {
            this.appendEmptySection(this.query, this.sheet, (Section)section, this.fileName);
        }
        return Boolean.TRUE;
    }

    public Boolean caseFamilyHistorySection(FamilyHistorySection section) {
        if (this.sheet.getPhysicalNumberOfRows() == 0) {
            Row row1 = null;
            Row row2 = this.sheet.createRow(0);
            int offset = SheetHeaderUtil.createPatientHeader(row1, row2, 0);
            offset = SheetHeaderUtil.createEncounterIDHeader(row1, row2, offset);
            offset = SheetHeaderUtil.createFamilyHistoryHeader(row1, row2, offset);
            emptySectionOffset.put(this.sheet.getSheetName(), offset);
        }
        if (section.getOrganizers() != null && !section.getOrganizers().isEmpty()) {
            this.appendToFamilyHistorySheet(this.query, this.sheet, this.patientRole, this.serviceEvent, (List<Organizer>)section.getOrganizers(), this.encounters, this.fileName);
        } else {
            this.appendEmptySection(this.query, this.sheet, (Section)section, this.fileName);
        }
        return Boolean.TRUE;
    }

    public Boolean caseGoalsSection(GoalsSection section) {
        if (this.sheet.getPhysicalNumberOfRows() == 0) {
            Row row1 = null;
            Row row2 = this.sheet.createRow(0);
            int offset = SheetHeaderUtil.createPatientHeader(row1, row2, 0);
            offset = SheetHeaderUtil.createEncounterIDHeader(row1, row2, offset);
            offset = SheetHeaderUtil.createGoalsSectionHeader(row1, row2, offset);
            emptySectionOffset.put(this.sheet.getSheetName(), offset);
        }
        if (section.getGoalObservations() != null && !section.getGoalObservations().isEmpty()) {
            this.appendToGoalSheet(this.query, this.sheet, this.patientRole, this.serviceEvent, (EList<? extends Observation>)section.getGoalObservations(), this.encounters, this.fileName);
        } else {
            this.appendEmptySection(this.query, this.sheet, (Section)section, this.fileName);
        }
        return Boolean.TRUE;
    }

    public Boolean caseHistoryOfPastIllnessSection(HistoryOfPastIllnessSection section) {
        if (this.sheet.getPhysicalNumberOfRows() == 0) {
            Row row1 = null;
            Row row2 = this.sheet.createRow(0);
            int offset = SheetHeaderUtil.createPatientHeader(row1, row2, 0);
            offset = SheetHeaderUtil.createEncounterIDHeader(row1, row2, offset);
            offset = SheetHeaderUtil.createProblemObservationHeader(row1, row2, offset);
            emptySectionOffset.put(this.sheet.getSheetName(), offset);
        }
        if (section.getProblemObservations() != null && !section.getProblemObservations().isEmpty()) {
            this.appendToProblemsSheet2(this.query, this.sheet, this.patientRole, this.serviceEvent, (EList<ProblemObservation>)section.getProblemObservations(), this.encounters, this.fileName);
        } else {
            this.appendEmptySection(this.query, this.sheet, (Section)section, this.fileName);
        }
        return Boolean.TRUE;
    }

    public Boolean caseImmunizationsSectionEntriesOptional(ImmunizationsSectionEntriesOptional section) {
        if (this.sheet.getPhysicalNumberOfRows() == 0) {
            Row row1 = null;
            Row row2 = this.sheet.createRow(0);
            int offset = SheetHeaderUtil.createPatientHeader(row1, row2, 0);
            offset = SheetHeaderUtil.createEncounterIDHeader(row1, row2, offset);
            offset = SheetHeaderUtil.createSubstanceAdministrationHeader(row1, row2, offset, "Immunization");
            emptySectionOffset.put(this.sheet.getSheetName(), offset);
        }
        if (section.getImmunizationActivities() != null && !section.getImmunizationActivities().isEmpty()) {
            SpreadsheetSerializer.appendToSubstanceAdministrationSheet(this.query, this.sheet, this.documentMetadata, this.patientRole, this.serviceEvent, this.encounters, (List<? extends SubstanceAdministration>)section.getImmunizationActivities(), this.fileName);
        } else {
            this.appendEmptySection(this.query, this.sheet, (Section)section, this.fileName);
        }
        return Boolean.TRUE;
    }

    public Boolean caseMedicationsAdministeredSection(MedicationsAdministeredSection section) {
        if (this.sheet.getPhysicalNumberOfRows() == 0) {
            Row row1 = null;
            Row row2 = this.sheet.createRow(0);
            int offset = SheetHeaderUtil.createPatientHeader(row1, row2, 0);
            offset = SheetHeaderUtil.createEncounterIDHeader(row1, row2, offset);
            offset = SheetHeaderUtil.createSubstanceAdministrationHeader(row1, row2, offset, "Medications");
            emptySectionOffset.put(this.sheet.getSheetName(), offset);
        }
        if (section.getMedicationActivities() != null && !section.getMedicationActivities().isEmpty()) {
            SpreadsheetSerializer.appendToSubstanceAdministrationSheet(this.query, this.sheet, this.documentMetadata, this.patientRole, this.serviceEvent, this.encounters, (List<? extends SubstanceAdministration>)section.getMedicationActivities(), this.fileName);
        } else {
            this.appendEmptySection(this.query, this.sheet, (Section)section, this.fileName);
        }
        return Boolean.TRUE;
    }

    public Boolean caseMedicationsSectionEntriesOptional(MedicationsSectionEntriesOptional section) {
        if (this.sheet.getPhysicalNumberOfRows() == 0) {
            Row row1 = null;
            Row row2 = this.sheet.createRow(0);
            int offset = SheetHeaderUtil.createPatientHeader(row1, row2, 0);
            offset = SheetHeaderUtil.createEncounterIDHeader(row1, row2, offset);
            offset = SheetHeaderUtil.createSubstanceAdministrationHeader(row1, row2, offset, "Medications");
            emptySectionOffset.put(this.sheet.getSheetName(), offset);
        }
        if (section.getMedicationActivities() != null && !section.getMedicationActivities().isEmpty()) {
            SpreadsheetSerializer.appendToSubstanceAdministrationSheet(this.query, this.sheet, this.documentMetadata, this.patientRole, this.serviceEvent, this.encounters, (List<? extends SubstanceAdministration>)section.getMedicationActivities(), this.fileName);
        } else {
            this.appendEmptySection(this.query, this.sheet, (Section)section, this.fileName);
        }
        return Boolean.TRUE;
    }

    public Boolean caseProblemSectionEntriesOptional(ProblemSectionEntriesOptional section) {
        if (this.sheet.getPhysicalNumberOfRows() == 0) {
            Row row1 = null;
            Row row2 = this.sheet.createRow(0);
            int offset = SheetHeaderUtil.createPatientHeader(row1, row2, 0);
            offset = SheetHeaderUtil.createEncounterIDHeader(row1, row2, offset);
            offset = SheetHeaderUtil.createProblemHeader(row1, row2, offset);
            emptySectionOffset.put(this.sheet.getSheetName(), offset);
        }
        if (section.getProblemConcerns() != null && !section.getProblemConcerns().isEmpty()) {
            this.appendToProblemsSheet(this.query, this.sheet, this.patientRole, this.serviceEvent, (EList<ProblemConcernAct>)section.getProblemConcerns(), this.encounters, this.fileName);
        } else {
            this.appendEmptySection(this.query, this.sheet, (Section)section, this.fileName);
        }
        return Boolean.TRUE;
    }

    public Boolean caseProceduresSectionEntriesOptional(ProceduresSectionEntriesOptional section) {
        if (this.sheet.getPhysicalNumberOfRows() == 0) {
            Row row1 = null;
            Row row2 = this.sheet.createRow(0);
            int offset = SheetHeaderUtil.createPatientHeader(row1, row2, 0);
            offset = SheetHeaderUtil.createEncounterIDHeader(row1, row2, offset);
            offset = SheetHeaderUtil.createProcedureHeader(row1, row2, offset);
            emptySectionOffset.put(this.sheet.getSheetName(), offset);
        }
        if (section.getProcedureActivityActs() != null && !section.getProcedureActivityActs().isEmpty()) {
            this.appendActToProcedureSheet(this.query, this.sheet, this.documentMetadata, this.patientRole, this.serviceEvent, (EList<ProcedureActivityAct>)section.getProcedureActivityActs(), this.encounters, this.fileName);
        }
        if (section.getProcedureActivityObservations() != null && !section.getProcedureActivityObservations().isEmpty()) {
            SectionSwitch.appendObservationToProcedureSheet(this.query, this.sheet, this.documentMetadata, this.patientRole, this.serviceEvent, (EList<ProcedureActivityObservation>)section.getProcedureActivityObservations(), this.encounters, this.fileName);
        }
        if (section.getProcedureActivityProcedures() != null && !section.getProcedureActivityProcedures().isEmpty()) {
            SpreadsheetSerializer.appendProcedureToProcedureSheet(this.query, this.sheet, this.documentMetadata, this.patientRole, this.serviceEvent, (EList<Procedure>)section.getProcedures(), this.encounters, this.fileName);
        }
        return Boolean.TRUE;
    }

    public Boolean caseResultsSectionEntriesOptional(ResultsSectionEntriesOptional section) {
        BasicEList resultOrganizers = new BasicEList();
        for (Organizer organizer : section.getOrganizers()) {
            if (!(organizer instanceof ResultOrganizer)) continue;
            resultOrganizers.add((Object)((ResultOrganizer)organizer));
        }
        if (!resultOrganizers.isEmpty()) {
            if (this.sheet.getPhysicalNumberOfRows() == 0) {
                Row row1 = null;
                Row row2 = this.sheet.createRow(0);
                int offset = SheetHeaderUtil.createPatientHeader(row1, row2, 0);
                offset = SheetHeaderUtil.createEncounterIDHeader(row1, row2, offset);
                offset = SheetHeaderUtil.createResultsHeader(row1, row2, offset);
                emptySectionOffset.put(this.sheet.getSheetName(), offset);
            }
            SpreadsheetSerializer.appendToResultsSheet(this.query, this.sheet, this.documentMetadata, this.patientRole, this.serviceEvent, (List<? extends Organizer>)resultOrganizers, this.encounters, this.fileName);
        }
        return Boolean.TRUE;
    }

    public Boolean caseSocialHistorySection(SocialHistorySection section) {
        if (this.sheet.getPhysicalNumberOfRows() == 0) {
            Row row1 = null;
            Row row2 = this.sheet.createRow(0);
            int offset = SheetHeaderUtil.createPatientHeader(row1, row2, 0);
            offset = SheetHeaderUtil.createEncounterIDHeader(row1, row2, offset);
            offset = SheetHeaderUtil.createObservationHeaderWithAuthor(row1, row2, offset);
            emptySectionOffset.put(this.sheet.getSheetName(), offset);
        }
        if (section.getObservations() != null && !section.getObservations().isEmpty()) {
            this.appendObservationsToSocialHistorySheet(this.query, this.sheet, this.patientRole, this.serviceEvent, (EList<Observation>)section.getObservations(), this.encounters, this.fileName);
        } else {
            this.appendEmptySection(this.query, this.sheet, (Section)section, this.fileName);
        }
        return Boolean.TRUE;
    }

    public Boolean caseVitalSignsSectionEntriesOptional(VitalSignsSectionEntriesOptional section) {
        if (section.getVitalSignsOrganizers() != null && !section.getVitalSignsOrganizers().isEmpty()) {
            if (this.sheet.getPhysicalNumberOfRows() == 0) {
                Row row1 = null;
                Row row2 = this.sheet.createRow(0);
                int offset = SheetHeaderUtil.createPatientHeader(row1, row2, 0);
                offset = SheetHeaderUtil.createEncounterIDHeader(row1, row2, offset);
                offset = SheetHeaderUtil.createVitalSignsHeader(row1, row2, offset);
                emptySectionOffset.put(this.sheet.getSheetName(), offset);
            }
            SpreadsheetSerializer.appendToVitalSignsSheet(this.query, this.sheet, this.documentMetadata, this.patientRole, this.serviceEvent, (List<Organizer>)section.getOrganizers(), this.encounters, this.fileName);
            return Boolean.TRUE;
        }
        return Boolean.TRUE;
    }

    public Boolean caseDischargeMedicationsSectionEntriesOptional2(DischargeMedicationsSectionEntriesOptional2 section) {
        if (this.sheet.getPhysicalNumberOfRows() == 0) {
            Row row1 = null;
            Row row2 = this.sheet.createRow(0);
            int offset = SheetHeaderUtil.createPatientHeader(row1, row2, 0);
            offset = SheetHeaderUtil.createEncounterIDHeader(row1, row2, offset);
            offset = SheetHeaderUtil.createClinicalStatmentHeader(row1, row2, offset);
            emptySectionOffset.put(this.sheet.getSheetName(), offset);
        }
        if (section.getDischargeMedications() != null && !section.getDischargeMedications().isEmpty()) {
            this.appendToDischargeMedications(this.query, this.sheet, this.documentMetadata, this.patientRole, this.serviceEvent, this.encounters, (EList<DischargeMedication>)section.getDischargeMedications(), this.fileName);
        } else {
            this.appendEmptySection(this.query, this.sheet, (Section)section, this.fileName);
        }
        return Boolean.TRUE;
    }

    public Boolean caseChiefComplaintAndReasonForVisitSection(ChiefComplaintAndReasonForVisitSection object) {
        return Boolean.TRUE;
    }

    public Boolean defaultCase(EObject object) {
        if (this.firstpass) {
            return Boolean.FALSE;
        }
        Section section = (Section)object;
        if (this.sheet.getPhysicalNumberOfRows() == 0) {
            Row row1 = null;
            Row row2 = this.sheet.createRow(0);
            int offset = SheetHeaderUtil.createPatientHeader(row1, row2, 0);
            offset = SheetHeaderUtil.createEncounterIDHeader(row1, row2, offset);
            offset = SheetHeaderUtil.createNarrativeHeader(row1, row2, offset);
            emptySectionOffset.put(this.sheet.getSheetName(), offset);
        }
        if (section.getText() != null) {
            this.appendNarrative(this.query, this.sheet, this.documentMetadata, this.patientRole, this.serviceEvent, this.encounters, section.getText(), this.fileName);
        } else {
            this.appendEmptySection(this.query, this.sheet, section, this.fileName);
        }
        return Boolean.TRUE;
    }

    private void appendActToProcedureSheet(CDAUtil.Query query, Sheet sheet, CDAValueUtil.DocumentMetadata organizationAndSoftware, PatientRole patientRole, ServiceEvent serviceEvent, EList<ProcedureActivityAct> eList, List<Encounter> encounters, String fileName) {
        for (Act sa : eList) {
            int offset = 0;
            Row row = sheet.createRow(sheet.getPhysicalNumberOfRows());
            offset = SpreadsheetSerializer.serializePatient(row, offset, organizationAndSoftware, patientRole);
            offset = SpreadsheetSerializer.serializeEnounterID(row, offset, sa, encounters);
            offset = SpreadsheetSerializer.serializeProcedureActivityAct(row, offset, sa, true);
            SpreadsheetSerializer.serializeSectionAndFileName(row, offset, sa.getSection(), fileName);
        }
    }

    private void appendEmptySection(CDAUtil.Query query2, Sheet sheet2, Section section, String fileName2) {
        Row row = this.sheet.createRow(this.sheet.getPhysicalNumberOfRows());
        int offset = SpreadsheetSerializer.serializePatient(row, 0, this.documentMetadata, this.patientRole);
        row.createCell(offset++).setCellValue("NO ENCOUNTER");
        row.createCell(offset++).setCellValue("NO ENTRIES");
        SpreadsheetSerializer.serializeSectionAndFileName(row, emptySectionOffset.get(sheet2.getSheetName()) - 3, section, this.fileName);
    }

    private void appendObservationsToSocialHistorySheet(CDAUtil.Query query2, Sheet sheet2, PatientRole patientRole2, ServiceEvent serviceEvent2, EList<Observation> observations, List<Encounter> encounters2, String fileName2) {
        for (Observation sa : observations) {
            int offset = 0;
            Row row = this.sheet.createRow(this.sheet.getPhysicalNumberOfRows());
            offset = SpreadsheetSerializer.serializePatient(row, offset, this.documentMetadata, this.patientRole);
            offset = SpreadsheetSerializer.serializeEnounterID(row, offset, sa, this.encounters);
            offset = SpreadsheetSerializer.serializeObservation(row, offset, sa, false, true, GenerateCDADataHandler.exportCDTranslations);
            SpreadsheetSerializer.serializeSectionAndFileName(row, offset, sa.getSection(), this.fileName);
        }
    }

    private void appendToAdvancedDirectivesSheet(CDAUtil.Query query2, Sheet sheet2, PatientRole patientRole2, ServiceEvent serviceEvent2, EList<AdvanceDirectiveObservation> advanceDirectiveObservations, List<Encounter> encounters2, String fileName2) {
        for (AdvanceDirectiveObservation ado : advanceDirectiveObservations) {
            int offset = 0;
            Row row = this.sheet.createRow(this.sheet.getPhysicalNumberOfRows());
            offset = SpreadsheetSerializer.serializePatient(row, offset, this.documentMetadata, this.patientRole);
            offset = SpreadsheetSerializer.serializeEnounterID(row, offset, (Observation)ado, this.encounters);
            offset = SpreadsheetSerializer.serializeClinicalStatement(row, offset, (Observation)ado);
            SpreadsheetSerializer.serializeSectionAndFileName(row, offset, ado.getSection(), this.fileName);
        }
    }

    private void appendToFamilyHistorySheet(CDAUtil.Query query2, Sheet sheet2, PatientRole patientRole2, ServiceEvent serviceEvent2, List<Organizer> observations, List<Encounter> encounters2, String fileName2) {
        for (Organizer organizer : observations) {
            for (Observation observation : organizer.getObservations()) {
                Row row = this.sheet.createRow(this.sheet.getPhysicalNumberOfRows());
                int offset = SpreadsheetSerializer.serializePatient(row, 0, this.documentMetadata, this.patientRole);
                offset = SpreadsheetSerializer.serializeEnounterID(row, offset, observation, this.encounters);
                offset = SpreadsheetSerializer.serializeOrganizer(row, offset, organizer, false, true);
                offset = SpreadsheetSerializer.serializeObservation(row, offset, observation, false, false, true);
                SpreadsheetSerializer.serializeSectionAndFileName(row, offset, observation.getSection(), this.fileName);
            }
        }
    }

    private void appendToGoalSheet(CDAUtil.Query query2, Sheet sheet2, PatientRole patientRole2, ServiceEvent serviceEvent2, EList<? extends Observation> observations, List<Encounter> encounters2, String fileName2) {
        for (Observation observation : observations) {
            Row row = this.sheet.createRow(this.sheet.getPhysicalNumberOfRows());
            int offset = SpreadsheetSerializer.serializePatient(row, 0, this.documentMetadata, this.patientRole);
            offset = SpreadsheetSerializer.serializeEnounterID(row, offset, observation, this.encounters);
            offset = SpreadsheetSerializer.serializeObservation(row, offset, observation, false, false, true);
            SpreadsheetSerializer.serializeSectionAndFileName(row, offset, observation.getSection(), this.fileName);
        }
    }

    private void appendToProblemsSheet(CDAUtil.Query query2, Sheet sheet2, PatientRole patientRole2, ServiceEvent serviceEvent2, EList<ProblemConcernAct> problemConcerns, List<Encounter> encounters2, String fileName2) {
        for (ProblemConcernAct sa : problemConcerns) {
            int offset = 0;
            Row row = this.sheet.createRow(this.sheet.getPhysicalNumberOfRows());
            offset = SpreadsheetSerializer.serializePatient(row, offset, this.documentMetadata, this.patientRole);
            offset = SpreadsheetSerializer.serializeEnounterID(row, offset, (Act)sa, this.encounters);
            offset = this.serializeProblemConcernAct(row, offset, sa);
            SpreadsheetSerializer.serializeSectionAndFileName(row, offset, sa.getSection(), this.fileName);
        }
    }

    private void appendToProblemsSheet2(CDAUtil.Query query2, Sheet sheet2, PatientRole patientRole2, ServiceEvent serviceEvent2, EList<ProblemObservation> problemObservations, List<Encounter> encounters2, String fileName2) {
        for (ProblemObservation sa : problemObservations) {
            int offset = 0;
            Row row = this.sheet.createRow(this.sheet.getPhysicalNumberOfRows());
            offset = SpreadsheetSerializer.serializePatient(row, offset, this.documentMetadata, this.patientRole);
            offset = SpreadsheetSerializer.serializeEnounterID(row, offset, (Observation)sa, this.encounters);
            offset = SpreadsheetSerializer.serializeProblemObservationClinicalStatement(row, offset, (Observation)sa, true);
            SpreadsheetSerializer.serializeSectionAndFileName(row, offset, sa.getSection(), this.fileName);
        }
    }

    private int serializeProblemConcernAct(Row row, int offset, ProblemConcernAct problemConcernAct) {
        StringBuffer sb = new StringBuffer();
        for (II ii : problemConcernAct.getIds()) {
            sb.append(CDAValueUtil.getKey2(ii));
        }
        row.createCell(offset++).setCellValue(sb.toString());
        sb = new StringBuffer();
        Date d = CDAValueUtil.getDate(CDAValueUtil.getValueAsString(problemConcernAct.getEffectiveTime()));
        if (d != null) {
            row.createCell(offset++).setCellValue(CDAValueUtil.DATE_PRETTY.format(d));
        } else {
            row.createCell(offset++).setCellValue("");
        }
        row.createCell(offset++).setCellValue(CDAUtil.getDomainPath((EObject)problemConcernAct.getEffectiveTime()));
        if (problemConcernAct.getStatusCode() != null && !StringUtils.isEmpty((String)problemConcernAct.getStatusCode().getCode())) {
            row.createCell(offset++).setCellValue(problemConcernAct.getStatusCode().getCode());
        } else {
            row.createCell(offset++).setCellValue("Missing Status");
        }
        row.createCell(offset++).setCellValue(CDAUtil.getDomainPath((EObject)problemConcernAct.getStatusCode()));
        offset = SpreadsheetSerializer.appendCode(row, offset, problemConcernAct.getSection(), problemConcernAct.getCode(), problemConcernAct.getText());
        Iterator iterator = problemConcernAct.getProblemObservations().iterator();
        if (iterator.hasNext()) {
            ProblemObservation problemObservation = (ProblemObservation)iterator.next();
            offset = SpreadsheetSerializer.serializeProblemObservationClinicalStatement(row, offset, (Observation)problemObservation, true);
        }
        return offset;
    }

    static void appendToAllergiesSheet(CDAUtil.Query query, Sheet sheet, CDAValueUtil.DocumentMetadata organizationAndSoftware, PatientRole patientRole, ServiceEvent serviceEvent, List<AllergyProblemAct> sas, List<Encounter> encounters, String fileName) {
        for (AllergyProblemAct sa : sas) {
            int offset = 0;
            Row row = sheet.createRow(sheet.getPhysicalNumberOfRows());
            offset = SpreadsheetSerializer.serializePatient(row, offset, organizationAndSoftware, patientRole);
            offset = SpreadsheetSerializer.serializeEnounterID(row, offset, (Act)sa, encounters);
            offset = SectionSwitch.serializeAllergyProblemAct(row, offset, sa, true);
            SpreadsheetSerializer.serializeSectionAndFileName(row, offset, sa.getSection(), fileName);
        }
    }

    static int serializeAllergyProblemAct(Row row, int offset, AllergyProblemAct allergyProblemAct, boolean checkForNotes) {
        StringBuffer sb = new StringBuffer();
        for (II ii : allergyProblemAct.getIds()) {
            sb.append(CDAValueUtil.getKey2(ii));
        }
        row.createCell(offset++).setCellValue(sb.toString());
        sb = new StringBuffer();
        if (allergyProblemAct.getStatusCode() != null && !StringUtils.isEmpty((String)allergyProblemAct.getStatusCode().getCode())) {
            row.createCell(offset++).setCellValue(allergyProblemAct.getStatusCode().getCode());
        } else {
            row.createCell(offset++).setCellValue("Missing Status");
        }
        Iterator iterator = allergyProblemAct.getAllergyObservations().iterator();
        if (iterator.hasNext()) {
            AllergyObservation allergyObservation = (AllergyObservation)iterator.next();
            Date d = CDAValueUtil.getDate(CDAValueUtil.getValueAsString(allergyObservation.getEffectiveTime()));
            if (d != null) {
                row.createCell(offset++).setCellValue(CDAValueUtil.DATE_PRETTY.format(d));
                row.createCell(offset++).setCellValue(CDAUtil.getDomainPath((EObject)allergyObservation.getEffectiveTime()));
            } else {
                row.createCell(offset++).setCellValue("");
                row.createCell(offset++).setCellValue("");
            }
            CD cd = null;
            for (ANY any : allergyObservation.getValues()) {
                if (!(any instanceof CD)) continue;
                cd = (CD)any;
            }
            row.createCell(offset++).setCellValue(Boolean.TRUE.equals(allergyObservation.getNegationInd()));
            offset = SpreadsheetSerializer.appendCode(row, offset, allergyProblemAct.getSection(), cd, allergyObservation.getText());
            CE material = null;
            try {
                material = ((Participant2)allergyObservation.getParticipants().get(0)).getParticipantRole().getPlayingEntity().getCode();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            offset = GenerateCDADataHandler.exportCDTranslations ? SpreadsheetSerializer.appendExtendedCode(row, offset, allergyProblemAct.getSection(), (CD)material, null, true) : SpreadsheetSerializer.appendCode(row, offset, allergyProblemAct.getSection(), (CD)material, null);
            SeverityObservation severity = null;
            if (!allergyObservation.getConsolReactionObservations().isEmpty()) {
                Iterator iterator2 = allergyObservation.getConsolReactionObservations().iterator();
                if (iterator2.hasNext()) {
                    ReactionObservation ro = (ReactionObservation)iterator2.next();
                    Iterator reactionCode = null;
                    for (ANY any : ro.getValues()) {
                        if (!(any instanceof CD)) continue;
                        reactionCode = (CD)any;
                    }
                    offset = SpreadsheetSerializer.appendCode(row, offset, allergyProblemAct.getSection(), (CD)reactionCode, ro.getText());
                    if (ro.getSeverityObservation() != null) {
                        severity = ro.getSeverityObservation();
                    }
                }
            } else {
                offset = SpreadsheetSerializer.appendCode(row, offset, allergyProblemAct.getSection(), null, null);
            }
            SeverityObservation severityObservation = severity = severity != null ? severity : allergyObservation.getConsolSeverityObservation();
            if (severity != null) {
                CD severityCode = null;
                for (ANY any : severity.getValues()) {
                    if (!(any instanceof CD)) continue;
                    severityCode = (CD)any;
                }
                offset = SpreadsheetSerializer.appendCode(row, offset, allergyProblemAct.getSection(), severityCode, severity.getText());
            } else {
                offset = SpreadsheetSerializer.appendCode(row, offset, allergyProblemAct.getSection(), null, null);
            }
            CD criticalityCode = null;
            if (allergyObservation instanceof AllergyObservation2) {
                AllergyObservation2 allergyObservation2 = (AllergyObservation2)allergyObservation;
                CriticalityObservation criticalityObservation = allergyObservation2.getCriticalityObservation();
                if (criticalityObservation != null) {
                    for (ANY any : criticalityObservation.getValues()) {
                        if (!(any instanceof CD)) continue;
                        criticalityCode = (CD)any;
                    }
                    offset = SpreadsheetSerializer.appendCode(row, offset, allergyProblemAct.getSection(), criticalityCode, criticalityObservation.getText());
                } else {
                    offset = SpreadsheetSerializer.appendCode(row, offset, allergyProblemAct.getSection(), null, null);
                }
            } else {
                offset = SpreadsheetSerializer.appendCode(row, offset, allergyProblemAct.getSection(), null, null);
            }
            if (checkForNotes) {
                boolean hasNotes = false;
                Act note = null;
                for (Act act : allergyObservation.getActs()) {
                    if (!(act instanceof NoteActivity)) continue;
                    hasNotes = true;
                    note = act;
                }
                if (hasNotes) {
                    row.createCell(offset++).setCellValue(hasNotes);
                    row.createCell(offset++).setCellValue(CDAUtil.getDomainPath((EObject)note));
                } else {
                    row.createCell(offset++).setCellValue(false);
                    row.createCell(offset++).setCellValue("");
                }
            }
            offset = SpreadsheetSerializer.appendOrganizationAndAuthor(row, offset, (EList<Author>)allergyObservation.getAuthors());
        }
        return offset;
    }

    static void appendObservationToProcedureSheet(CDAUtil.Query query, Sheet sheet, CDAValueUtil.DocumentMetadata organizationAndSoftware, PatientRole patientRole, ServiceEvent serviceEvent, EList<ProcedureActivityObservation> procedureActivityObservations, List<Encounter> encounters, String fileName) {
        for (ProcedureActivityObservation sa : procedureActivityObservations) {
            int offset = 0;
            Row row = sheet.createRow(sheet.getPhysicalNumberOfRows());
            offset = SpreadsheetSerializer.serializePatient(row, offset, organizationAndSoftware, patientRole);
            offset = SpreadsheetSerializer.serializeEnounterID(row, offset, (Observation)sa, encounters);
            offset = SpreadsheetSerializer.serializeProcedureActivityObservation(row, offset, (Observation)sa, true);
            SpreadsheetSerializer.serializeSectionAndFileName(row, offset, sa.getSection(), fileName);
        }
    }

    private void appendToOutcomeObservationSheet(CDAUtil.Query query2, Sheet sheet, CDAValueUtil.DocumentMetadata organizationAndSoftware, PatientRole patientRole, ServiceEvent serviceEvent, EList<OutcomeObservation> outcomeObservations, List<Encounter> encounters, String fileName2) {
        for (OutcomeObservation sa : outcomeObservations) {
            int offset = 0;
            Row row = sheet.createRow(sheet.getPhysicalNumberOfRows());
            offset = SpreadsheetSerializer.serializePatient(row, offset, organizationAndSoftware, patientRole);
            offset = SpreadsheetSerializer.serializeEnounterID(row, offset, (Observation)sa, encounters);
            offset = SpreadsheetSerializer.serializeClinicalStatement(row, offset, (Observation)sa);
            SpreadsheetSerializer.serializeSectionAndFileName(row, offset, sa.getSection(), this.fileName);
        }
    }

    private void appendIndicationSheet(CDAUtil.Query query2, Sheet sheet, CDAValueUtil.DocumentMetadata organizationAndSoftware, PatientRole patientRole, ServiceEvent serviceEvent, EList<Indication> indications, List<Encounter> encounters, String fileName2) {
        for (Indication sa : indications) {
            int offset = 0;
            Row row = sheet.createRow(sheet.getPhysicalNumberOfRows());
            offset = SpreadsheetSerializer.serializePatient(row, offset, organizationAndSoftware, patientRole);
            offset = SpreadsheetSerializer.serializeEnounterID(row, offset, (Observation)sa, encounters);
            offset = SpreadsheetSerializer.serializeClinicalStatement(row, offset, (Observation)sa);
            SpreadsheetSerializer.serializeSectionAndFileName(row, offset, sa.getSection(), this.fileName);
        }
    }

    private void appendToInstructionSheet(CDAUtil.Query query, Sheet sheet, CDAValueUtil.DocumentMetadata organizationAndSoftware, PatientRole patientRole, ServiceEvent serviceEvent2, EList<Instructions> instructionss, List<Encounter> encounters, String fileName2) {
        for (Instructions sa : instructionss) {
            int offset = 0;
            Row row = sheet.createRow(sheet.getPhysicalNumberOfRows());
            offset = SpreadsheetSerializer.serializePatient(row, offset, organizationAndSoftware, patientRole);
            offset = SpreadsheetSerializer.serializeEnounterID(row, offset, (Act)sa, encounters);
            offset = SpreadsheetSerializer.serializeClinicalStatement(row, offset, (Act)sa);
            SpreadsheetSerializer.serializeSectionAndFileName(row, offset, sa.getSection(), this.fileName);
        }
    }

    private void appendToCoverageActivitiesSheet(CDAUtil.Query query, Sheet sheet, CDAValueUtil.DocumentMetadata organizationAndSoftware, PatientRole patientRole, ServiceEvent serviceEvent2, EList<CoverageActivity> coverageActivities, List<Encounter> encounters, String fileName2) {
        for (CoverageActivity sa : coverageActivities) {
            int offset = 0;
            Row row = sheet.createRow(sheet.getPhysicalNumberOfRows());
            offset = SpreadsheetSerializer.serializePatient(row, offset, organizationAndSoftware, patientRole);
            offset = SpreadsheetSerializer.serializeEnounterID(row, offset, (Act)sa, encounters);
            offset = SpreadsheetSerializer.serializeCoverageActivity(row, offset, sa);
            SpreadsheetSerializer.serializeSectionAndFileName(row, offset, sa.getSection(), this.fileName);
        }
    }

    private void appendToDischargeMedications(CDAUtil.Query query2, Sheet sheet2, CDAValueUtil.DocumentMetadata organizationAndSoftware, PatientRole patientRole2, ServiceEvent serviceEvent2, List<Encounter> encounters2, EList<DischargeMedication> dischargeMedications, String fileName2) {
        for (DischargeMedication sa : dischargeMedications) {
            int offset = 0;
            Row row = this.sheet.createRow(this.sheet.getPhysicalNumberOfRows());
            offset = SpreadsheetSerializer.serializePatient(row, offset, organizationAndSoftware, this.patientRole);
            offset = SpreadsheetSerializer.serializeEnounterID(row, offset, (Act)sa, this.encounters);
            offset = SpreadsheetSerializer.serializeClinicalStatement(row, offset, (Act)sa);
            SpreadsheetSerializer.serializeSectionAndFileName(row, offset, sa.getSection(), this.fileName);
        }
    }

    private void appendNarrative(CDAUtil.Query query2, Sheet sheet2, CDAValueUtil.DocumentMetadata organizationAndSoftware, PatientRole patientRole2, ServiceEvent serviceEvent2, List<Encounter> encounters2, StrucDocText text, String fileName2) {
        int offset = 0;
        Row row = this.sheet.createRow(this.sheet.getPhysicalNumberOfRows());
        offset = SpreadsheetSerializer.serializePatient(row, offset, organizationAndSoftware, this.patientRole);
        offset = SpreadsheetSerializer.serializeNoEnounterID(row, offset);
        offset = SpreadsheetSerializer.serializeStrucDocText(row, offset, text);
        SpreadsheetSerializer.serializeSectionAndFileName(row, offset, (Section)text.eContainer(), this.fileName);
    }
}

