/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.valgrind.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.linuxtools.internal.valgrind.core.ValgrindInfo;
import org.eclipse.linuxtools.internal.valgrind.ui.CoreMessagesViewer;
import org.eclipse.linuxtools.internal.valgrind.ui.Messages;
import org.eclipse.linuxtools.internal.valgrind.ui.ValgrindUIPlugin;
import org.eclipse.linuxtools.valgrind.core.IValgrindMessage;
import org.eclipse.linuxtools.valgrind.ui.IValgrindToolView;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.ViewPart;

public class ValgrindViewPart
extends ViewPart {
    private static final String TOOLBAR_LOC_GROUP_ID = "toolbarLocal";
    private PageBook pageBook;
    private Composite dynamicViewHolder;
    private IValgrindToolView dynamicView;
    private ActionContributionItem[] dynamicActions;
    private IValgrindMessage[] messages;
    private CoreMessagesViewer messagesViewer;
    private Action showCoreAction;
    private Action showToolAction;
    private boolean hasDynamicContent = false;

    public void createPartControl(Composite parent) {
        this.setContentDescription(Messages.getString("ValgrindViewPart.No_Valgrind_output"));
        this.pageBook = new PageBook(parent, 0);
        this.pageBook.setLayoutData((Object)new GridData(1808));
        this.messagesViewer = new CoreMessagesViewer((Composite)this.pageBook, 0);
        this.dynamicViewHolder = new Composite((Composite)this.pageBook, 0);
        GridLayout dynamicViewLayout = new GridLayout();
        dynamicViewLayout.marginHeight = 0;
        dynamicViewLayout.marginWidth = 0;
        this.dynamicViewHolder.setLayout((Layout)dynamicViewLayout);
        this.dynamicViewHolder.setLayoutData((Object)new GridData(1808));
        this.showCoreAction = new Action(Messages.getString("ValgrindViewPart.Show_Core_Action"), 8){

            public void run() {
                ValgrindViewPart.this.showCorePage();
            }
        };
        this.showToolAction = new Action(Messages.getString("ValgrindViewPart.Show_Tool_Action"), 8){

            public void run() {
                ValgrindViewPart.this.showToolPage();
            }
        };
        ValgrindUIPlugin.getDefault().setView(this);
    }

    public IValgrindToolView createDynamicContent(String description, String toolID) throws CoreException {
        this.setContentDescription(description);
        IToolBarManager toolbar = this.getViewSite().getActionBars().getToolBarManager();
        ToolBar tb = ((ToolBarManager)toolbar).getControl();
        if (tb == null || tb.isDisposed()) {
            throw new CoreException(Status.error((String)"Toolbar is disposed"));
        }
        if (this.dynamicActions != null) {
            for (ActionContributionItem actionContributionItem : this.dynamicActions) {
                toolbar.remove((IContributionItem)actionContributionItem);
            }
        }
        if (this.dynamicView != null) {
            this.dynamicView.dispose();
        }
        if (this.messages != null) {
            this.messagesViewer.getTreeViewer().setInput(null);
            this.messages = null;
        }
        for (ActionContributionItem actionContributionItem : this.dynamicViewHolder.getChildren()) {
            if (actionContributionItem.isDisposed()) continue;
            actionContributionItem.dispose();
        }
        if (toolID != null) {
            this.dynamicView = ValgrindUIPlugin.getDefault().getToolView(toolID);
            this.dynamicView.createPartControl(this.dynamicViewHolder);
            IAction[] actions = this.dynamicView.getToolbarActions();
            if (actions != null) {
                this.dynamicActions = new ActionContributionItem[actions.length];
                for (int i = 0; i < actions.length; ++i) {
                    this.dynamicActions[i] = new ActionContributionItem(actions[i]);
                    toolbar.appendToGroup(TOOLBAR_LOC_GROUP_ID, (IContributionItem)this.dynamicActions[i]);
                }
            }
        } else {
            this.dynamicView = null;
        }
        IMenuManager menu = this.getViewSite().getActionBars().getMenuManager();
        menu.removeAll();
        boolean bl = this.hasDynamicContent = this.dynamicViewHolder.getChildren().length > 0;
        if (this.hasDynamicContent) {
            menu.add((IAction)this.showCoreAction);
            menu.add((IAction)this.showToolAction);
        }
        menu.update(true);
        toolbar.update(true);
        this.getViewSite().getActionBars().updateActionBars();
        this.dynamicViewHolder.layout(true);
        return this.dynamicView;
    }

    public void setMessages(IValgrindMessage[] messages) {
        this.messages = messages;
    }

    public IValgrindMessage[] getMessages() {
        return this.messages;
    }

    public void setFocus() {
        if (this.dynamicView != null) {
            this.dynamicView.setFocus();
        }
    }

    public void refreshView() {
        if (this.messages != null && this.messages.length > 0) {
            this.messagesViewer.getTreeViewer().setInput((Object)this.messages);
            if (this.hasDynamicContent && this.messages[0] instanceof ValgrindInfo) {
                this.showCoreAction.setEnabled(false);
                this.showToolPage();
            } else {
                this.showCoreAction.setEnabled(true);
                this.showCorePage();
            }
        }
        if (this.dynamicView != null) {
            this.dynamicView.refreshView();
        }
    }

    public void dispose() {
        if (this.dynamicView != null) {
            this.dynamicView.dispose();
        }
        ValgrindUIPlugin.getDefault().setView(null);
        super.dispose();
    }

    public IValgrindToolView getDynamicView() {
        return this.dynamicView;
    }

    public CoreMessagesViewer getMessagesViewer() {
        return this.messagesViewer;
    }

    private void showCorePage() {
        this.pageBook.showPage(this.messagesViewer.getTreeViewer().getControl());
        this.showCoreAction.setChecked(true);
        this.showToolAction.setChecked(false);
    }

    private void showToolPage() {
        this.pageBook.showPage((Control)this.dynamicViewHolder);
        this.showToolAction.setChecked(true);
        this.showCoreAction.setChecked(false);
    }
}

