/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.plugin.remotese.pluginse;

import org.eclipse.keyple.plugin.remotese.pluginse.RemoteSePlugin;
import org.eclipse.keyple.plugin.remotese.pluginse.RmConnectReaderExecutor;
import org.eclipse.keyple.plugin.remotese.pluginse.RmDisconnectReaderExecutor;
import org.eclipse.keyple.plugin.remotese.pluginse.RmEventExecutor;
import org.eclipse.keyple.plugin.remotese.pluginse.VirtualReader;
import org.eclipse.keyple.plugin.remotese.pluginse.VirtualReaderSessionFactory;
import org.eclipse.keyple.plugin.remotese.rm.RemoteMethod;
import org.eclipse.keyple.plugin.remotese.transport.DtoHandler;
import org.eclipse.keyple.plugin.remotese.transport.DtoSender;
import org.eclipse.keyple.plugin.remotese.transport.KeypleDtoHelper;
import org.eclipse.keyple.plugin.remotese.transport.factory.TransportNode;
import org.eclipse.keyple.plugin.remotese.transport.model.KeypleDto;
import org.eclipse.keyple.plugin.remotese.transport.model.TransportDto;
import org.eclipse.keyple.seproxy.ReaderPlugin;
import org.eclipse.keyple.seproxy.SeProxyService;
import org.eclipse.keyple.seproxy.SeReader;
import org.eclipse.keyple.seproxy.exception.KeypleReaderException;
import org.eclipse.keyple.seproxy.exception.KeypleReaderNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualReaderService
implements DtoHandler {
    private static final Logger logger = LoggerFactory.getLogger(VirtualReaderService.class);
    private final DtoSender dtoSender;
    private final RemoteSePlugin plugin;

    public VirtualReaderService(SeProxyService seProxyService, DtoSender dtoSender) {
        this.dtoSender = dtoSender;
        VirtualReaderSessionFactory sessionManager = new VirtualReaderSessionFactory();
        this.plugin = new RemoteSePlugin(sessionManager, dtoSender);
        seProxyService.addPlugin((ReaderPlugin)this.plugin);
    }

    public void bindDtoEndpoint(TransportNode node) {
        node.setDtoHandler(this);
    }

    public RemoteSePlugin getPlugin() {
        return this.plugin;
    }

    @Override
    public TransportDto onDTO(TransportDto transportDto) {
        KeypleDto keypleDTO = transportDto.getKeypleDTO();
        RemoteMethod method = RemoteMethod.get(keypleDTO.getAction());
        logger.trace("onDTO, Remote Method called : {} - isRequest : {} - keypleDto : {}", new Object[]{method, keypleDTO.isRequest(), KeypleDtoHelper.toJson(keypleDTO)});
        switch (method) {
            case READER_CONNECT: {
                if (keypleDTO.isRequest().booleanValue()) {
                    return new RmConnectReaderExecutor(this.plugin, this.dtoSender).execute(transportDto);
                }
                throw new IllegalStateException("a READER_CONNECT response has been received by VirtualReaderService");
            }
            case READER_DISCONNECT: {
                if (keypleDTO.isRequest().booleanValue()) {
                    return new RmDisconnectReaderExecutor(this.plugin).execute(transportDto);
                }
                throw new IllegalStateException("a READER_DISCONNECT response has been received by VirtualReaderService");
            }
            case READER_EVENT: {
                return new RmEventExecutor(this.plugin).execute(transportDto);
            }
            case READER_TRANSMIT: {
                if (keypleDTO.isRequest().booleanValue()) {
                    throw new IllegalStateException("a READER_TRANSMIT request has been received by VirtualReaderService");
                }
                try {
                    VirtualReader reader = this.getReaderBySessionId(keypleDTO.getSessionId());
                    return reader.getRmTxEngine().onDTO(transportDto);
                }
                catch (KeypleReaderNotFoundException e) {
                    throw new IllegalStateException("Virtual Reader was not found while receiving a transmitSet response", e);
                }
                catch (KeypleReaderException e) {
                    throw new IllegalStateException("Readers list has not been initializated", e);
                }
            }
            case DEFAULT_SELECTION_REQUEST: {
                if (keypleDTO.isRequest().booleanValue()) {
                    throw new IllegalStateException("a READER_TRANSMIT request has been received by VirtualReaderService");
                }
                try {
                    VirtualReader reader = this.getReaderBySessionId(keypleDTO.getSessionId());
                    return reader.getRmTxEngine().onDTO(transportDto);
                }
                catch (KeypleReaderNotFoundException e) {
                    throw new IllegalStateException("Virtual Reader was not found while receiving a transmitSet response", e);
                }
                catch (KeypleReaderException e) {
                    throw new IllegalStateException("Readers list has not been initializated", e);
                }
            }
        }
        logger.error("Receive a KeypleDto with no recognised action");
        return transportDto.nextTransportDTO(KeypleDtoHelper.NoResponse());
    }

    private VirtualReader getReaderBySessionId(String sessionId) throws KeypleReaderNotFoundException, KeypleReaderException {
        for (SeReader reader : this.plugin.getReaders()) {
            if (!((VirtualReader)reader).getSession().getSessionId().equals(sessionId)) continue;
            return (VirtualReader)reader;
        }
        throw new KeypleReaderNotFoundException("Reader session was not found for session : " + sessionId);
    }
}

