/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.plugins.viewepc.figures.epc;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.jwt.we.editors.preferences.PreferenceReader;
import org.eclipse.swt.graphics.Color;

public class EPCEventBorder
extends LineBorder {
    private Point topLeftPoint = new Point();
    private Point topRightPoint = new Point();
    private Point bottomLeftPoint = new Point();
    private Point bottomRightPoint = new Point();
    private Point middleLeftPoint = new Point();
    private Point middleRightPoint = new Point();

    public EPCEventBorder() {
        super(PreferenceReader.appearanceBorderColor.get(), PreferenceReader.appearanceLineWidth.get());
    }

    public Point getTopLeftPoint() {
        return this.topLeftPoint;
    }

    public Point getTopRightPoint() {
        return this.topRightPoint;
    }

    public Point getBottomLeftPoint() {
        return this.bottomLeftPoint;
    }

    public Point getBottomRightPoint() {
        return this.bottomRightPoint;
    }

    public Point getMiddleLeftPoint() {
        return this.middleLeftPoint;
    }

    public Point getMiddleRightPoint() {
        return this.middleRightPoint;
    }

    public void paint(IFigure figure, Graphics graphics, Insets insets) {
        boolean drawShadow;
        tempRect.setBounds(EPCEventBorder.getPaintRectangle((IFigure)figure, (Insets)insets));
        graphics.setLineWidth(this.getWidth());
        if (this.getColor() != null) {
            graphics.setForegroundColor(this.getColor());
        }
        if (drawShadow = PreferenceReader.appearanceShadowVisible.get()) {
            EPCEventBorder.tempRect.width -= 2;
            EPCEventBorder.tempRect.height -= 2;
        }
        int dx = EPCEventBorder.tempRect.width / 6;
        int dy = EPCEventBorder.tempRect.height / 2;
        PointList pointList = new PointList();
        this.topLeftPoint = new Point(EPCEventBorder.tempRect.x + dx, EPCEventBorder.tempRect.y);
        this.topRightPoint = new Point(EPCEventBorder.tempRect.x + EPCEventBorder.tempRect.width - dx, EPCEventBorder.tempRect.y);
        this.middleRightPoint = new Point(EPCEventBorder.tempRect.x + EPCEventBorder.tempRect.width - 1, EPCEventBorder.tempRect.y + dy);
        this.bottomRightPoint = new Point(EPCEventBorder.tempRect.x + EPCEventBorder.tempRect.width - dx, EPCEventBorder.tempRect.y + EPCEventBorder.tempRect.height - 1);
        this.bottomLeftPoint = new Point(EPCEventBorder.tempRect.x + dx, EPCEventBorder.tempRect.y + EPCEventBorder.tempRect.height - 1);
        this.middleLeftPoint = new Point(EPCEventBorder.tempRect.x, EPCEventBorder.tempRect.y + dy);
        if (PreferenceReader.appearanceShadowVisible.get()) {
            pointList.removeAllPoints();
            pointList.addPoint(this.topLeftPoint.x + 2, this.topLeftPoint.y + 2);
            pointList.addPoint(this.topRightPoint.x + 2, this.topRightPoint.y + 2);
            pointList.addPoint(this.middleRightPoint.x + 2, this.middleRightPoint.y + 2);
            pointList.addPoint(this.bottomRightPoint.x + 2, this.bottomRightPoint.y + 2);
            pointList.addPoint(this.bottomLeftPoint.x + 2, this.bottomLeftPoint.y + 2);
            pointList.addPoint(this.middleLeftPoint.x + 2, this.middleLeftPoint.y + 2);
            graphics.setAlpha(50);
            graphics.setBackgroundColor(PreferenceReader.appearanceShadowColor.get());
            graphics.fillPolygon(pointList);
            pointList.removeAllPoints();
            pointList.addPoint(this.topLeftPoint.x, this.topLeftPoint.y);
            pointList.addPoint(this.topRightPoint.x, this.topRightPoint.y);
            pointList.addPoint(this.middleRightPoint.x, this.middleRightPoint.y);
            pointList.addPoint(this.bottomRightPoint.x, this.bottomRightPoint.y);
            pointList.addPoint(this.bottomLeftPoint.x, this.bottomLeftPoint.y);
            pointList.addPoint(this.middleLeftPoint.x, this.middleLeftPoint.y);
            graphics.setAlpha(255);
            graphics.setBackgroundColor(figure.getBackgroundColor());
            graphics.fillPolygon(pointList);
        }
        pointList.removeAllPoints();
        pointList.addPoint(this.topLeftPoint.x, this.topLeftPoint.y);
        pointList.addPoint(this.topRightPoint.x, this.topRightPoint.y);
        pointList.addPoint(this.middleRightPoint.x, this.middleRightPoint.y);
        pointList.addPoint(this.bottomRightPoint.x, this.bottomRightPoint.y);
        pointList.addPoint(this.bottomLeftPoint.x, this.bottomLeftPoint.y);
        pointList.addPoint(this.middleLeftPoint.x, this.middleLeftPoint.y);
        graphics.setAlpha(50);
        graphics.setBackgroundColor(new Color(null, 250, 40, 100));
        graphics.fillPolygon(pointList);
        graphics.setBackgroundColor(PreferenceReader.appearanceBorderColor.get());
        graphics.drawPolygon(pointList);
    }
}

