/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.impl;

import io.quarkus.arc.ContextInstanceHandle;
import io.quarkus.arc.CurrentContext;
import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.InjectableContext;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.arc.ManagedContext;
import io.quarkus.arc.impl.ContextInstanceHandleImpl;
import io.quarkus.arc.impl.CreationalContextImpl;
import io.quarkus.arc.impl.EventImpl;
import io.quarkus.arc.impl.Scopes;
import jakarta.enterprise.context.ContextNotActiveException;
import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;

class RequestContext
implements ManagedContext {
    private static final Logger LOG = Logger.getLogger("io.quarkus.arc.requestContext");
    private final CurrentContext<RequestContextState> currentContext;
    private final EventImpl.Notifier<Object> initializedNotifier;
    private final EventImpl.Notifier<Object> beforeDestroyedNotifier;
    private final EventImpl.Notifier<Object> destroyedNotifier;

    public RequestContext(CurrentContext<RequestContextState> currentContext, EventImpl.Notifier<Object> initializedNotifier, EventImpl.Notifier<Object> beforeDestroyedNotifier, EventImpl.Notifier<Object> destroyedNotifier) {
        this.currentContext = currentContext;
        this.initializedNotifier = initializedNotifier;
        this.beforeDestroyedNotifier = beforeDestroyedNotifier;
        this.destroyedNotifier = destroyedNotifier;
    }

    @Override
    public Class<? extends Annotation> getScope() {
        return RequestScoped.class;
    }

    @Override
    public <T> T getIfActive(Contextual<T> contextual, Function<Contextual<T>, CreationalContext<T>> creationalContextFun) {
        Objects.requireNonNull(contextual, "Contextual must not be null");
        Objects.requireNonNull(creationalContextFun, "CreationalContext supplier must not be null");
        InjectableBean bean = (InjectableBean)contextual;
        if (!Scopes.scopeMatches(this, bean)) {
            throw Scopes.scopeDoesNotMatchException(this, bean);
        }
        RequestContextState ctxState = this.currentContext.get();
        if (ctxState == null) {
            return null;
        }
        ContextInstanceHandle<?> instance = ctxState.map.get(contextual);
        if (instance == null) {
            CreationalContext<T> creationalContext = creationalContextFun.apply(contextual);
            instance = new ContextInstanceHandleImpl((InjectableBean)contextual, contextual.create(creationalContext), creationalContext);
            ctxState.map.put(contextual, instance);
        }
        return instance.get();
    }

    @Override
    public <T> T get(Contextual<T> contextual, CreationalContext<T> creationalContext) {
        T result = this.getIfActive(contextual, CreationalContextImpl.unwrap(Objects.requireNonNull(creationalContext, "CreationalContext must not be null")));
        if (result == null) {
            throw this.notActive();
        }
        return result;
    }

    @Override
    public <T> T get(Contextual<T> contextual) {
        Objects.requireNonNull(contextual, "Contextual must not be null");
        InjectableBean bean = (InjectableBean)contextual;
        if (!Scopes.scopeMatches(this, bean)) {
            throw Scopes.scopeDoesNotMatchException(this, bean);
        }
        RequestContextState state = this.currentContext.get();
        if (state == null) {
            throw this.notActive();
        }
        ContextInstanceHandle<?> instance = state.map.get(contextual);
        return instance == null ? null : (T)instance.get();
    }

    @Override
    public boolean isActive() {
        return this.currentContext.get() != null;
    }

    @Override
    public void destroy(Contextual<?> contextual) {
        RequestContextState state = this.currentContext.get();
        if (state == null) {
            throw this.notActive();
        }
        ContextInstanceHandle<?> instance = state.map.remove(contextual);
        if (instance != null) {
            instance.destroy();
        }
    }

    @Override
    public void activate(InjectableContext.ContextState initialState) {
        if (LOG.isTraceEnabled()) {
            String stack = Arrays.stream(Thread.currentThread().getStackTrace()).skip(2L).limit(7L).map(se -> "\n\t" + se.toString()).collect(Collectors.joining());
            LOG.tracef("Activate %s %s\n\t...", (Object)(initialState != null ? Integer.toHexString(initialState.hashCode()) : "new"), (Object)stack);
        }
        if (initialState == null) {
            this.currentContext.set(new RequestContextState(new ConcurrentHashMap()));
            this.fireIfNotEmpty(this.initializedNotifier);
        } else if (initialState instanceof RequestContextState) {
            this.currentContext.set((RequestContextState)initialState);
        } else {
            throw new IllegalArgumentException("Invalid initial state: " + initialState.getClass().getName());
        }
    }

    @Override
    public InjectableContext.ContextState getState() {
        RequestContextState state = this.currentContext.get();
        if (state == null) {
            throw this.notActive();
        }
        return state;
    }

    @Override
    public InjectableContext.ContextState getStateIfActive() {
        return this.currentContext.get();
    }

    @Override
    public void deactivate() {
        if (LOG.isTraceEnabled()) {
            String stack = Arrays.stream(Thread.currentThread().getStackTrace()).skip(2L).limit(7L).map(se -> "\n\t" + se.toString()).collect(Collectors.joining());
            LOG.tracef("Deactivate%s\n\t...", (Object)stack);
        }
        this.currentContext.remove();
    }

    @Override
    public void destroy() {
        this.destroy(this.currentContext.get());
    }

    @Override
    public void destroy(InjectableContext.ContextState state) {
        if (LOG.isTraceEnabled()) {
            String stack = Arrays.stream(Thread.currentThread().getStackTrace()).skip(2L).limit(7L).map(se -> "\n\t" + se.toString()).collect(Collectors.joining());
            LOG.tracef("Destroy %s%s\n\t...", (Object)(state != null ? Integer.toHexString(state.hashCode()) : ""), (Object)stack);
        }
        if (state == null) {
            return;
        }
        if (state instanceof RequestContextState) {
            RequestContextState reqState = (RequestContextState)state;
            if (reqState.invalidate()) {
                this.fireIfNotEmpty(this.beforeDestroyedNotifier);
                Map<Contextual<?>, ContextInstanceHandle<?>> map = ((RequestContextState)state).map;
                if (!map.isEmpty()) {
                    map.forEach(this::destroyContextElement);
                    map.clear();
                }
                this.fireIfNotEmpty(this.destroyedNotifier);
            }
        } else {
            throw new IllegalArgumentException("Invalid state implementation: " + state.getClass().getName());
        }
    }

    private void destroyContextElement(Contextual<?> contextual, ContextInstanceHandle<?> contextInstanceHandle) {
        try {
            contextInstanceHandle.destroy();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to destroy instance" + contextInstanceHandle.get(), e);
        }
    }

    private void fireIfNotEmpty(EventImpl.Notifier<Object> notifier) {
        if (notifier != null && !notifier.isEmpty()) {
            try {
                notifier.notify(this.toString());
            }
            catch (Exception e) {
                LOG.warn((Object)("An error occurred during delivery of the container lifecycle event for qualifiers " + notifier.eventMetadata.getQualifiers()), e);
            }
        }
    }

    private ContextNotActiveException notActive() {
        String msg = "Request context is not active - you can activate the request context for a specific method using the @ActivateRequestContext interceptor binding";
        return new ContextNotActiveException(msg);
    }

    static class RequestContextState
    implements InjectableContext.ContextState {
        private static final VarHandle IS_VALID;
        private final Map<Contextual<?>, ContextInstanceHandle<?>> map;
        private volatile int isValid;

        RequestContextState(ConcurrentMap<Contextual<?>, ContextInstanceHandle<?>> value) {
            this.map = Objects.requireNonNull(value);
            this.isValid = 1;
        }

        @Override
        public Map<InjectableBean<?>, Object> getContextualInstances() {
            return this.map.values().stream().collect(Collectors.toUnmodifiableMap(InstanceHandle::getBean, InstanceHandle::get));
        }

        boolean invalidate() {
            return IS_VALID.compareAndSet(this, 1, 0);
        }

        @Override
        public boolean isValid() {
            return this.isValid == 1;
        }

        static {
            try {
                IS_VALID = MethodHandles.lookup().findVarHandle(RequestContextState.class, "isValid", Integer.TYPE);
            }
            catch (ReflectiveOperationException e) {
                throw new Error(e);
            }
        }
    }
}

