/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.util;

import org.eclipse.hono.util.RequestResponseApiConstants;

public final class CommandRouterConstants
extends RequestResponseApiConstants {
    public static final String DEFAULT_CACHE_NAME = "command-router";
    public static final String COMMAND_ROUTER_ENDPOINT = "cmd_router";

    private CommandRouterConstants() {
    }

    public static enum CommandRouterAction {
        SET_LAST_KNOWN_GATEWAY("set-last-known-gw"),
        REGISTER_COMMAND_CONSUMER("register-command-consumer"),
        UNREGISTER_COMMAND_CONSUMER("unregister-command-consumer"),
        ENABLE_COMMAND_ROUTING("enable-command-routing"),
        UNKNOWN("unknown");

        private final String subject;

        private CommandRouterAction(String subject) {
            this.subject = subject;
        }

        public String getSubject() {
            return this.subject;
        }

        public static CommandRouterAction from(String subject) {
            if (subject != null) {
                for (CommandRouterAction action : CommandRouterAction.values()) {
                    if (!subject.equals(action.getSubject())) continue;
                    return action;
                }
            }
            return UNKNOWN;
        }

        public static boolean isValid(String subject) {
            return CommandRouterAction.from(subject) != UNKNOWN;
        }
    }
}

