/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config.inject;

import io.smallrye.config.ConfigMappings;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.inject.SecuritySupport;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.inject.ConfigProperties;

public class ConfigPropertiesInjectionBean<T>
implements Bean<T> {
    private final ConfigMappings.ConfigClassWithPrefix configClassWithPrefix;
    private final Set<Annotation> qualifiers;

    ConfigPropertiesInjectionBean(ConfigMappings.ConfigClassWithPrefix configClassWithPrefix) {
        this.configClassWithPrefix = configClassWithPrefix;
        this.qualifiers = Collections.singleton(ConfigProperties.Literal.of(configClassWithPrefix.getPrefix()));
    }

    @Override
    public Class<T> getBeanClass() {
        return this.configClassWithPrefix.getKlass();
    }

    @Override
    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public T create(CreationalContext<T> creationalContext) {
        String prefix = this.configClassWithPrefix.getPrefix();
        if (prefix.equals("org.eclipse.microprofile.config.inject.configproperties.unconfiguredprefix") && (prefix = this.configClassWithPrefix.getKlass().getAnnotation(ConfigProperties.class).prefix()).equals("org.eclipse.microprofile.config.inject.configproperties.unconfiguredprefix")) {
            prefix = "";
        }
        SmallRyeConfig config = ConfigProvider.getConfig(SecuritySupport.getContextClassLoader()).unwrap(SmallRyeConfig.class);
        return config.getConfigMapping(this.getBeanClass(), prefix);
    }

    @Override
    public void destroy(T instance, CreationalContext<T> creationalContext) {
    }

    @Override
    public Set<Type> getTypes() {
        return Collections.singleton(this.configClassWithPrefix.getKlass());
    }

    @Override
    public Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    @Override
    public Class<? extends Annotation> getScope() {
        return Dependent.class;
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName() + "_" + this.configClassWithPrefix.getKlass().getName() + "_" + this.configClassWithPrefix.getPrefix();
    }

    @Override
    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }

    @Override
    public boolean isAlternative() {
        return false;
    }
}

