/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mutiny.runtime;

import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import org.jboss.logging.Logger;

@Recorder
public class MutinyInfrastructure {
    public static final String VERTX_EVENT_LOOP_THREAD_PREFIX = "vert.x-eventloop-thread-";

    public void configureMutinyInfrastructure(final ExecutorService exec, ShutdownContext shutdownContext) {
        Infrastructure.getDefaultWorkerPool().shutdown();
        Infrastructure.setDefaultExecutor(new Executor(){

            @Override
            public void execute(Runnable command) {
                block2: {
                    try {
                        exec.execute(command);
                    }
                    catch (RejectedExecutionException e) {
                        if (exec.isShutdown() || exec.isTerminated()) break block2;
                        throw e;
                    }
                }
            }
        });
        shutdownContext.addLastShutdownTask(new Runnable(){

            @Override
            public void run() {
                Infrastructure.getDefaultWorkerPool().shutdown();
            }
        });
    }

    public void configureDroppedExceptionHandler() {
        final Logger logger2 = Logger.getLogger(MutinyInfrastructure.class);
        Infrastructure.setDroppedExceptionHandler(new Consumer<Throwable>(){

            @Override
            public void accept(Throwable throwable) {
                logger2.error((Object)"Mutiny had to drop the following exception", throwable);
            }
        });
    }

    public void configureThreadBlockingChecker() {
        Infrastructure.setCanCallerThreadBeBlockedSupplier(new BooleanSupplier(){

            @Override
            public boolean getAsBoolean() {
                String threadName = Thread.currentThread().getName();
                return !threadName.startsWith(MutinyInfrastructure.VERTX_EVENT_LOOP_THREAD_PREFIX);
            }
        });
    }

    public void configureOperatorLogger() {
        final Logger logger2 = Logger.getLogger(MutinyInfrastructure.class);
        Infrastructure.setOperatorLogger(new Infrastructure.OperatorLogger(){

            @Override
            public void log(String identifier, String event, Object value, Throwable failure) {
                String log = identifier + " | ";
                log = failure != null ? log + event + "(" + failure.getClass() + "(" + failure.getMessage() + "))" : (value != null ? log + event + "(" + value + ")" : log + event + "()");
                logger2.info(log);
            }
        });
    }
}

