/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.graph.introspector;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.hawk.core.IMetaModelIntrospector;
import org.eclipse.hawk.core.IModelIndexer;
import org.eclipse.hawk.core.graph.IGraphDatabase;
import org.eclipse.hawk.core.graph.IGraphTransaction;
import org.eclipse.hawk.graph.GraphWrapper;
import org.eclipse.hawk.graph.MetamodelNode;
import org.eclipse.hawk.graph.Slot;
import org.eclipse.hawk.graph.TypeNode;
import org.eclipse.hawk.graph.updater.GraphMetaModelUpdater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphMetaModelIntrospector
implements IMetaModelIntrospector {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphMetaModelIntrospector.class);
    private final IModelIndexer indexer;

    protected GraphMetaModelIntrospector(IModelIndexer idx) {
        this.indexer = idx;
    }

    public List<String> getMetamodels() {
        ArrayList<String> plugins = new ArrayList<String>(this.indexer.getKnownMMUris());
        Collections.sort(plugins);
        return plugins;
    }

    public List<String> getTypes(String metamodelURI) throws NoSuchElementException {
        IGraphDatabase db = this.indexer.getGraph();
        ArrayList<String> typeNames = new ArrayList<String>();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (IGraphTransaction tx = db.beginTransaction();){
                GraphWrapper gw = new GraphWrapper(db);
                MetamodelNode mmNode = gw.getMetamodelNodeByNsURI(metamodelURI);
                for (TypeNode tn : mmNode.getTypes()) {
                    typeNames.add(tn.getTypeName());
                }
                Collections.sort(typeNames);
                tx.success();
                return typeNames;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e1) {
            LOGGER.error(e1.getMessage(), (Throwable)e1);
            return Collections.emptyList();
        }
    }

    public List<String> getAttributes(String metamodelURI, String typeName) throws NoSuchElementException {
        IGraphDatabase db = this.indexer.getGraph();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (IGraphTransaction tx = db.beginTransaction();){
                ArrayList<String> attributeSlots = new ArrayList<String>();
                GraphWrapper gw = new GraphWrapper(db);
                MetamodelNode mmNode = gw.getMetamodelNodeByNsURI(metamodelURI);
                if (mmNode == null) {
                    throw new NoSuchElementException("Metamodel " + metamodelURI + " not registered at this indexer");
                }
                boolean foundType = false;
                for (TypeNode tn : mmNode.getTypes()) {
                    if (!typeName.equals(tn.getTypeName())) continue;
                    foundType = true;
                    for (Slot slot : tn.getSlots().values()) {
                        if (!slot.isAttribute()) continue;
                        attributeSlots.add(slot.getName());
                    }
                }
                if (!foundType) {
                    throw new NoSuchElementException("Type " + typeName + " not found within metamodel " + metamodelURI);
                }
                Collections.sort(attributeSlots);
                tx.success();
                return attributeSlots;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    public static class Factory
    implements IMetaModelIntrospector.Factory {
        public boolean canIntrospect(IModelIndexer idx) {
            if (idx.getGraph() == null) {
                return false;
            }
            return idx.getMetaModelUpdater() instanceof GraphMetaModelUpdater;
        }

        public IMetaModelIntrospector createFor(IModelIndexer idx) {
            return new GraphMetaModelIntrospector(idx);
        }

        public String getHumanReadableName() {
            return "Local metamodel introspector factory";
        }
    }
}

