/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.service.emf.dt.editors;

import com.google.common.collect.ImmutableSet;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import org.apache.thrift.TException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hawk.service.api.EffectiveMetamodelRuleset;
import org.eclipse.hawk.service.api.Hawk;
import org.eclipse.hawk.service.api.HawkQueryOptions;
import org.eclipse.hawk.service.api.ModelElementType;
import org.eclipse.hawk.service.api.QueryResult;
import org.eclipse.hawk.service.api.SlotMetadata;
import org.eclipse.hawk.service.emf.HawkModelDescriptor;
import org.eclipse.hawk.service.emf.dt.Activator;
import org.eclipse.hawk.service.emf.dt.editors.HawkMultiPageEditor;
import org.eclipse.hawk.service.emf.dt.editors.Utils;
import org.eclipse.hawk.service.emf.dt.importers.EMMImporter;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class EffectiveMetamodelFormPage
extends FormPage {
    private static final String EMM_IMPORTER_EXTID = "org.eclipse.hawk.service.emf.dt.emmImporter";
    private EffectiveMetamodelRuleset store = new EffectiveMetamodelRuleset();
    private TreeViewer treeViewer;
    private Color clrExcludes;
    private Color clrIncludes;
    private Color clrPartial;

    public EffectiveMetamodelFormPage(HawkMultiPageEditor editor, String id, String title) {
        super((FormEditor)editor, id, title);
    }

    public HawkMultiPageEditor getEditor() {
        return (HawkMultiPageEditor)super.getEditor();
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        managedForm.getForm().setText("Effective Metamodel");
        this.clrIncludes = new Color((Device)managedForm.getForm().getDisplay(), new RGB(180, 255, 255));
        this.clrExcludes = new Color((Device)managedForm.getForm().getDisplay(), new RGB(255, 200, 255));
        this.clrPartial = new Color((Device)managedForm.getForm().getDisplay(), new RGB(255, 255, 220));
        FormToolkit toolkit = managedForm.getToolkit();
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 1;
        Composite formBody = managedForm.getForm().getBody();
        formBody.setLayout((Layout)layout);
        FormText formText = toolkit.createFormText(formBody, true);
        formText.setText("<p><p>This page allows for limiting the types and slots that should be retrieved through the Hawk API.</p><p>With everything set to 'Default', all metamodels, types and slots are retrieved.</p><p>With everything set to 'Default' or 'Includes', only the included elements are retrieved.</p><p>With everything set to 'Default' or 'Excludes', everything but the excluded elements is retrieved.</p><p>Using all three values, only the elements which are 1. included and 2. not excluded are retrieved.</p><p>The shown metamodels are those registered in the Hawk server: please make sure the Instance section of the descriptor has been setup correctly before using this page. If the table is empty, correct the Instance section and click on Reload when done.</p></p>", true, false);
        Composite cTable = toolkit.createComposite(formBody, 0);
        cTable.setLayoutData((Object)new TableWrapData(256, 256));
        cTable.setLayout((Layout)Utils.createTableWrapLayout(2));
        Composite cTree = new Composite(cTable, 0);
        TableWrapData cTreeLayoutData = new TableWrapData(256, 256);
        cTreeLayoutData.maxHeight = 500;
        cTree.setLayoutData((Object)cTreeLayoutData);
        TreeColumnLayout tcl_cTree = new TreeColumnLayout();
        cTree.setLayout((Layout)tcl_cTree);
        this.treeViewer = new TreeViewer(cTree, 66050);
        this.treeViewer.getTree().setHeaderVisible(true);
        final MetamodelContentProvider contentProvider = new MetamodelContentProvider();
        this.treeViewer.setUseHashlookup(true);
        this.treeViewer.setContentProvider((IContentProvider)contentProvider);
        MetamodelEditingSupport editingSupport = new MetamodelEditingSupport((ColumnViewer)this.treeViewer);
        TreeViewerColumn labelColumn = new TreeViewerColumn(this.treeViewer, 0);
        labelColumn.getColumn().setText("Element");
        labelColumn.setLabelProvider((CellLabelProvider)new MetamodelCellLabelProvider(editingSupport, 0));
        tcl_cTree.setColumnData((Widget)labelColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(100, 0, true));
        TreeViewerColumn stateColumn = new TreeViewerColumn(this.treeViewer, 0);
        stateColumn.getColumn().setText("State");
        stateColumn.setLabelProvider((CellLabelProvider)new MetamodelCellLabelProvider(editingSupport, 1));
        stateColumn.setEditingSupport((EditingSupport)editingSupport);
        tcl_cTree.setColumnData((Widget)stateColumn.getColumn(), (ColumnLayoutData)new ColumnPixelData(100));
        Composite cButtons = toolkit.createComposite(cTable, 64);
        FillLayout cButtonsLayout = new FillLayout(512);
        cButtonsLayout.spacing = 7;
        cButtonsLayout.marginWidth = 3;
        cButtons.setLayout((Layout)cButtonsLayout);
        Button btnIncludeAll = new Button(cButtons, 0);
        btnIncludeAll.setText("Include all");
        btnIncludeAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EffectiveMetamodelFormPage.this.setEffectiveMetamodel(new EffectiveMetamodelRuleset());
                EffectiveMetamodelFormPage.this.treeViewer.refresh();
                EffectiveMetamodelFormPage.this.getEditor().setDirty(true);
            }
        });
        Button btnExcludeAll = new Button(cButtons, 0);
        btnExcludeAll.setText("Exclude all");
        btnExcludeAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EffectiveMetamodelRuleset ruleset = new EffectiveMetamodelRuleset();
                Object[] objectArray = contentProvider.roots;
                int n = contentProvider.roots.length;
                int n2 = 0;
                while (n2 < n) {
                    Object on = objectArray[n2];
                    MetamodelNode mn = (MetamodelNode)on;
                    ruleset.exclude(mn.label);
                    ++n2;
                }
                EffectiveMetamodelFormPage.this.setEffectiveMetamodel(ruleset);
                EffectiveMetamodelFormPage.this.treeViewer.refresh();
                EffectiveMetamodelFormPage.this.getEditor().setDirty(true);
            }
        });
        final Button btnExclude = new Button(cButtons, 0);
        btnExclude.setText("Exclude");
        btnExclude.addSelectionListener((SelectionListener)new SetStateSelectionListener(editingSupport, RowState.EXCLUDED));
        btnExclude.setEnabled(false);
        final Button btnInclude = new Button(cButtons, 0);
        btnInclude.setText("Include");
        btnInclude.addSelectionListener((SelectionListener)new SetStateSelectionListener(editingSupport, RowState.INCLUDED));
        btnInclude.setEnabled(false);
        final Button btnReset = new Button(cButtons, 0);
        btnReset.setText("Reset");
        btnReset.addSelectionListener((SelectionListener)new SetStateSelectionListener(editingSupport, RowState.DEFAULT));
        btnReset.setEnabled(false);
        Button btnImport = new Button(cButtons, 0);
        btnImport.setText("Import...");
        btnImport.addSelectionListener((SelectionListener)new ImportEMMSelectionListener());
        Button btnReload = new Button(cButtons, 0);
        btnReload.setText("Reload");
        btnReload.addSelectionListener((SelectionListener)new ReloadSelectionListener());
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                boolean isAnySelected = !event.getSelection().isEmpty();
                btnExclude.setEnabled(isAnySelected);
                btnInclude.setEnabled(isAnySelected);
                btnReset.setEnabled(isAnySelected);
            }
        });
        this.treeViewer.setInput((Object)this.store);
        this.treeViewer.expandToLevel(2);
        managedForm.reflow(true);
    }

    public EffectiveMetamodelRuleset getEffectiveMetamodel() {
        return this.store;
    }

    public void setEffectiveMetamodel(EffectiveMetamodelRuleset newStore) {
        this.store = newStore;
        if (this.treeViewer != null) {
            this.treeViewer.setInput((Object)this.store);
        }
    }

    private final class ImportEMMSelectionListener
    extends SelectionAdapter {
        private ImportEMMSelectionListener() {
        }

        public void widgetSelected(SelectionEvent event) {
            IConfigurationElement[] importerElements;
            Object[] selected = importerElements = Platform.getExtensionRegistry().getConfigurationElementsFor(EffectiveMetamodelFormPage.EMM_IMPORTER_EXTID);
            if (importerElements.length > 1) {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                ListDialog lstDialog = new ListDialog(shell);
                lstDialog.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
                lstDialog.setLabelProvider((ILabelProvider)new LabelProvider(){

                    public String getText(Object element) {
                        return ((IConfigurationElement)element).getDeclaringExtension().getLabel();
                    }
                });
                lstDialog.setInput((Object)importerElements);
                lstDialog.setTitle("Select an importer");
                selected = lstDialog.open() == 0 ? lstDialog.getResult() : new Object[]{};
            }
            if (selected.length > 0) {
                IConfigurationElement selectedCE = selected[0];
                try {
                    EMMImporter importer = (EMMImporter)selectedCE.createExecutableExtension("class");
                    importer.importEffectiveMetamodelInto(EffectiveMetamodelFormPage.this.store);
                    EffectiveMetamodelFormPage.this.setEffectiveMetamodel(EffectiveMetamodelFormPage.this.store);
                    EffectiveMetamodelFormPage.this.treeViewer.refresh();
                    EffectiveMetamodelFormPage.this.getEditor().setDirty(true);
                }
                catch (CoreException ex) {
                    Activator.getDefault().logError(ex);
                }
            }
        }
    }

    private final class MetamodelCellLabelProvider
    extends CellLabelProvider {
        private final MetamodelEditingSupport editingSupport;
        private final int iColumn;

        private MetamodelCellLabelProvider(MetamodelEditingSupport editingSupport, int iColumn) {
            this.editingSupport = editingSupport;
            this.iColumn = iColumn;
        }

        public void update(ViewerCell cell) {
            Node element = (Node)cell.getElement();
            RowState state = this.editingSupport.getState(element);
            if (this.iColumn == 0) {
                cell.setText(element.label);
            } else {
                cell.setText(state.getLabel());
            }
            RowState inheritedState = this.getInheritedState(element, state);
            this.setBackgroundColor(cell, inheritedState);
        }

        private RowState getInheritedState(Node element, RowState state) {
            switch (state) {
                case EXCLUDED: 
                case INCLUDED: {
                    return state;
                }
            }
            if (element.parent == null) {
                return RowState.DEFAULT;
            }
            return this.getInheritedState(element.parent, this.editingSupport.getState(element.parent));
        }

        private void setBackgroundColor(ViewerCell cell, RowState state) {
            switch (state) {
                case INCLUDED: {
                    cell.setBackground(EffectiveMetamodelFormPage.this.clrIncludes);
                    break;
                }
                case EXCLUDED: {
                    cell.setBackground(EffectiveMetamodelFormPage.this.clrExcludes);
                    break;
                }
                default: {
                    if (cell.getElement() instanceof MetamodelNode) {
                        MetamodelNode mn = (MetamodelNode)cell.getElement();
                        if (EffectiveMetamodelFormPage.this.store.getInclusionRules().containsRow((Object)mn.label) || EffectiveMetamodelFormPage.this.store.getExclusionRules().containsRow((Object)mn.label)) {
                            cell.setBackground(EffectiveMetamodelFormPage.this.clrPartial);
                            break;
                        }
                        cell.setBackground(null);
                        break;
                    }
                    if (cell.getElement() instanceof TypeNode) {
                        TypeNode tn = (TypeNode)cell.getElement();
                        if (EffectiveMetamodelFormPage.this.store.getInclusionRules().contains((Object)tn.parent.label, (Object)tn.label) || EffectiveMetamodelFormPage.this.store.getExclusionRules().contains((Object)tn.parent.label, (Object)tn.label)) {
                            cell.setBackground(EffectiveMetamodelFormPage.this.clrPartial);
                            break;
                        }
                        cell.setBackground(null);
                        break;
                    }
                    cell.setBackground(null);
                }
            }
        }
    }

    private final class MetamodelContentProvider
    implements ITreeContentProvider {
        protected Object[] roots = null;

        private MetamodelContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput != null) {
                this.computeRoots();
            } else {
                this.roots = null;
            }
        }

        protected void computeRoots() {
            if (this.roots == null) {
                HawkMultiPageEditor editor = EffectiveMetamodelFormPage.this.getEditor();
                try {
                    HawkModelDescriptor descriptor = editor.buildDescriptor();
                    Hawk.Client client = editor.connectToHawk(descriptor);
                    QueryResult results = client.query(descriptor.getHawkInstance(), "return Model.types;", "org.eclipse.hawk.epsilon.emc.EOLQueryEngine", new HawkQueryOptions());
                    TreeMap<String, MetamodelNode> mmNodes = new TreeMap<String, MetamodelNode>();
                    for (QueryResult qr : results.getVList()) {
                        SlotNode sn;
                        if (!qr.isSetVModelElementType()) continue;
                        ModelElementType met = qr.getVModelElementType();
                        MetamodelNode mn = (MetamodelNode)mmNodes.get(met.getMetamodelUri());
                        if (mn == null) {
                            mn = new MetamodelNode(null, met.getMetamodelUri());
                            mmNodes.put(met.getMetamodelUri(), mn);
                        }
                        TypeNode tn = new TypeNode(mn, met.getTypeName());
                        mn.children.add(tn);
                        if (met.isSetAttributes()) {
                            for (SlotMetadata attr : met.getAttributes()) {
                                sn = new SlotNode(tn, attr.getName());
                                tn.children.add(sn);
                            }
                        }
                        if (met.isSetReferences()) {
                            for (SlotMetadata ref : met.getReferences()) {
                                sn = new SlotNode(tn, ref.getName());
                                tn.children.add(sn);
                            }
                        }
                        Collections.sort(tn.children);
                    }
                    this.roots = new ArrayList(mmNodes.values()).toArray();
                    for (Node root : mmNodes.values()) {
                        Collections.sort(root.children);
                    }
                }
                catch (URISyntaxException | TException e) {
                    Activator.getDefault().logError(e);
                }
            }
        }

        public void dispose() {
            this.roots = null;
            EffectiveMetamodelFormPage.this.clrExcludes.dispose();
            EffectiveMetamodelFormPage.this.clrIncludes.dispose();
            EffectiveMetamodelFormPage.this.clrPartial.dispose();
        }

        public Object getParent(Object element) {
            return ((Node)element).parent;
        }

        public Object[] getElements(Object inputElement) {
            this.computeRoots();
            if (this.roots == null) {
                return new Object[0];
            }
            return this.roots;
        }

        public Object[] getChildren(Object parentElement) {
            return ((Node)parentElement).children.toArray();
        }

        public boolean hasChildren(Object element) {
            return !((Node)element).children.isEmpty();
        }
    }

    private final class MetamodelEditingSupport
    extends EditingSupport {
        private MetamodelEditingSupport(ColumnViewer viewer) {
            super(viewer);
        }

        protected CellEditor getCellEditor(Object element) {
            TreeViewer viewer = (TreeViewer)this.getViewer();
            return new ComboBoxCellEditor((Composite)viewer.getTree(), RowState.getLabels());
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        public Object getValue(Object element) {
            RowState state = this.getState(element);
            return state == null ? 0 : state.ordinal();
        }

        protected RowState getState(Object element) {
            RowState state = null;
            if (element instanceof MetamodelNode) {
                MetamodelNode mn = (MetamodelNode)element;
                state = EffectiveMetamodelFormPage.this.store.getInclusionRules().contains((Object)mn.label, (Object)"*") ? RowState.INCLUDED : (EffectiveMetamodelFormPage.this.store.getExclusionRules().contains((Object)mn.label, (Object)"*") ? RowState.EXCLUDED : RowState.DEFAULT);
            } else if (element instanceof TypeNode) {
                ImmutableSet excludedSlots;
                TypeNode tn = (TypeNode)element;
                MetamodelNode mn = (MetamodelNode)tn.parent;
                ImmutableSet includedSlots = (ImmutableSet)EffectiveMetamodelFormPage.this.store.getInclusionRules().get((Object)mn.label, (Object)tn.label);
                state = includedSlots != null && includedSlots.contains((Object)"*") ? RowState.INCLUDED : ((excludedSlots = (ImmutableSet)EffectiveMetamodelFormPage.this.store.getExclusionRules().get((Object)mn.label, (Object)tn.label)) != null && excludedSlots.contains((Object)"*") ? RowState.EXCLUDED : RowState.DEFAULT);
            } else if (element instanceof SlotNode) {
                ImmutableSet excludedSlots;
                SlotNode sn = (SlotNode)element;
                TypeNode tn = (TypeNode)sn.parent;
                MetamodelNode mn = (MetamodelNode)tn.parent;
                ImmutableSet includedSlots = (ImmutableSet)EffectiveMetamodelFormPage.this.store.getInclusionRules().get((Object)mn.label, (Object)tn.label);
                state = includedSlots != null && includedSlots.contains((Object)sn.label) ? RowState.INCLUDED : ((excludedSlots = (ImmutableSet)EffectiveMetamodelFormPage.this.store.getExclusionRules().get((Object)mn.label, (Object)tn.label)) != null && excludedSlots.contains((Object)sn.label) ? RowState.EXCLUDED : RowState.DEFAULT);
            }
            return state;
        }

        protected void setValue(Object element, Object value) {
            RowState newValue;
            RowState oldValue = RowState.values()[(Integer)this.getValue(element)];
            if (oldValue.equals((Object)(newValue = RowState.values()[(Integer)value]))) {
                return;
            }
            ColumnViewer v = this.getViewer();
            if (element instanceof MetamodelNode) {
                MetamodelNode mn = (MetamodelNode)element;
                EffectiveMetamodelFormPage.this.store.reset(mn.label);
                switch (newValue) {
                    case INCLUDED: {
                        EffectiveMetamodelFormPage.this.store.include(mn.label);
                        break;
                    }
                    case EXCLUDED: {
                        EffectiveMetamodelFormPage.this.store.exclude(mn.label);
                        break;
                    }
                }
                v.update((Object)mn, null);
                for (Node tn : mn.children) {
                    v.update((Object)tn, null);
                    for (Node sn : tn.children) {
                        v.update((Object)sn, null);
                    }
                }
            } else if (element instanceof TypeNode) {
                TypeNode tn = (TypeNode)element;
                EffectiveMetamodelFormPage.this.store.reset(tn.parent.label, tn.label);
                switch (newValue) {
                    case INCLUDED: {
                        EffectiveMetamodelFormPage.this.store.include(tn.parent.label, tn.label);
                        break;
                    }
                    case EXCLUDED: {
                        EffectiveMetamodelFormPage.this.store.exclude(tn.parent.label, tn.label);
                        break;
                    }
                }
                v.update((Object)tn.parent, null);
                v.update((Object)tn, null);
                for (Node sn : tn.children) {
                    v.update((Object)sn, null);
                }
            } else if (element instanceof SlotNode) {
                ImmutableSet<String> newSlots;
                ImmutableSet oldSlots;
                SlotNode sn = (SlotNode)element;
                Node tn = sn.parent;
                switch (oldValue) {
                    case INCLUDED: {
                        oldSlots = (ImmutableSet)EffectiveMetamodelFormPage.this.store.getInclusionRules().get((Object)tn.parent.label, (Object)tn.label);
                        newSlots = this.removeSlot(sn, (ImmutableSet<String>)oldSlots);
                        if (newSlots == null) break;
                        EffectiveMetamodelFormPage.this.store.include(tn.parent.label, tn.label, newSlots);
                        break;
                    }
                    case EXCLUDED: {
                        oldSlots = (ImmutableSet)EffectiveMetamodelFormPage.this.store.getExclusionRules().get((Object)tn.parent.label, (Object)tn.label);
                        newSlots = this.removeSlot(sn, (ImmutableSet<String>)oldSlots);
                        if (newSlots == null) break;
                        EffectiveMetamodelFormPage.this.store.exclude(tn.parent.label, tn.label, newSlots);
                        break;
                    }
                }
                switch (newValue) {
                    case INCLUDED: {
                        oldSlots = (ImmutableSet)EffectiveMetamodelFormPage.this.store.getInclusionRules().get((Object)tn.parent.label, (Object)tn.label);
                        newSlots = this.addSlot(sn, (ImmutableSet<String>)oldSlots);
                        if (newSlots == null) break;
                        EffectiveMetamodelFormPage.this.store.include(tn.parent.label, tn.label, newSlots);
                        break;
                    }
                    case EXCLUDED: {
                        oldSlots = (ImmutableSet)EffectiveMetamodelFormPage.this.store.getExclusionRules().get((Object)tn.parent.label, (Object)tn.label);
                        newSlots = this.addSlot(sn, (ImmutableSet<String>)oldSlots);
                        if (newSlots == null) break;
                        EffectiveMetamodelFormPage.this.store.exclude(tn.parent.label, tn.label, newSlots);
                        break;
                    }
                }
                v.update((Object)sn.parent.parent, null);
                v.update((Object)sn.parent, null);
                v.update((Object)sn, null);
            }
            EffectiveMetamodelFormPage.this.getEditor().setDirty(true);
        }

        protected ImmutableSet<String> addSlot(SlotNode sn, ImmutableSet<String> oldSlots) {
            ImmutableSet newSlots = oldSlots;
            if (oldSlots == null) {
                return ImmutableSet.of((Object)sn.label);
            }
            if (!oldSlots.contains((Object)"*") && !oldSlots.contains((Object)sn.label)) {
                ImmutableSet.Builder builder = new ImmutableSet.Builder();
                builder.addAll(oldSlots);
                builder.add((Object)sn.label);
                newSlots = builder.build();
            }
            return newSlots;
        }

        protected ImmutableSet<String> removeSlot(SlotNode sn, ImmutableSet<String> oldSlots) {
            ImmutableSet newSlots = oldSlots;
            if (oldSlots != null && !oldSlots.contains((Object)"*") && oldSlots.contains((Object)sn.label)) {
                ImmutableSet.Builder builder = new ImmutableSet.Builder();
                for (String s : oldSlots) {
                    if (sn.label.equals(s)) continue;
                    builder.add((Object)s);
                }
                newSlots = builder.build();
            }
            return newSlots;
        }
    }

    private static class MetamodelNode
    extends Node {
        public MetamodelNode(Node parent, String mmURI) {
            super(parent, mmURI);
        }
    }

    private static abstract class Node
    implements Comparable<Node> {
        public final Node parent;
        public final List<Node> children = new ArrayList<Node>();
        public final String label;

        public Node(Node parent, String label) {
            this.parent = parent;
            this.label = label;
        }

        public String toString() {
            return this.label;
        }

        @Override
        public int compareTo(Node o) {
            return this.label.compareTo(o.label);
        }
    }

    private final class ReloadSelectionListener
    extends SelectionAdapter {
        private ReloadSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            EffectiveMetamodelFormPage.this.treeViewer.setInput(null);
            EffectiveMetamodelFormPage.this.treeViewer.setInput((Object)EffectiveMetamodelFormPage.this.store);
        }
    }

    private static enum RowState {
        DEFAULT("Default"),
        EXCLUDED("Excluded"),
        INCLUDED("Included");

        private final String label;

        private RowState(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }

        public static String[] getLabels() {
            ArrayList<String> labels = new ArrayList<String>();
            RowState[] rowStateArray = RowState.values();
            int n = rowStateArray.length;
            int n2 = 0;
            while (n2 < n) {
                RowState s = rowStateArray[n2];
                labels.add(s.label);
                ++n2;
            }
            return labels.toArray(new String[labels.size()]);
        }
    }

    private final class SetStateSelectionListener
    extends SelectionAdapter {
        private final MetamodelEditingSupport editingSupport;
        private final RowState newState;

        private SetStateSelectionListener(MetamodelEditingSupport editingSupport, RowState newState) {
            this.newState = newState;
            this.editingSupport = editingSupport;
        }

        public void widgetSelected(SelectionEvent e) {
            ISelection selection = EffectiveMetamodelFormPage.this.treeViewer.getSelection();
            if (selection instanceof IStructuredSelection) {
                IStructuredSelection ssel = (IStructuredSelection)selection;
                for (Object element : ssel) {
                    this.editingSupport.setValue(element, this.newState.ordinal());
                }
            }
        }
    }

    private static class SlotNode
    extends Node {
        public SlotNode(Node parent, String name) {
            super(parent, name);
        }
    }

    private static class TypeNode
    extends Node {
        public TypeNode(Node parent, String name) {
            super(parent, name);
        }
    }
}

