/*******************************************************************************
 * Copyright (c) 2008-2011 Chair for Applied Software Engineering,
 * Technische Universitaet Muenchen.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 ******************************************************************************/
package org.eclipse.emf.ecp.validation.refactoring.strategy;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.widgets.Shell;

/**
 * 
 * @author Carmen Carlan
 * 
 */
public interface RefactoringStrategy {
	/**
	 * This will start the refactoring.
	 * 
	 * @return the result
	 */
	RefactoringResult startRefactoring();

	/**
	 * @param status
	 *            the
	 */
	void setConstraintStatus(IStatus status);

	/**
	 * @return the description
	 */
	String getDescription();

	/**
	 * @return the id
	 */
	String getId();

	/**
	 * @param shell
	 *            the
	 */
	void setShell(Shell shell);

	/**
	 * @return the invalid model element
	 */
	EObject getInvalidModelElement();
}
